/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.machine;

import com.gigaspaces.internal.os.OSDetails;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.ElasticServiceManagers;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.GridServiceContainers;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.GridServiceManagers;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.dump.InternalOverviewBuilder;
import org.openspaces.admin.internal.esm.DefaultElasticServiceManagers;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.gsa.DefaultGridServiceAgents;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsc.DefaultGridServiceContainers;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsm.DefaultGridServiceManagers;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.lus.DefaultLookupServices;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.machine.InternalMachine;
import org.openspaces.admin.internal.os.DefaultOperatingSystem;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstances;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstances;
import org.openspaces.admin.internal.space.DefaultSpaceInstances;
import org.openspaces.admin.internal.space.InternalSpaceInstances;
import org.openspaces.admin.internal.transport.DefaultTransports;
import org.openspaces.admin.internal.transport.InternalTransports;
import org.openspaces.admin.internal.vm.DefaultVirtualMachines;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.LookupServices;
import org.openspaces.admin.os.OperatingSystem;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventManager;
import org.openspaces.admin.transport.Transports;
import org.openspaces.admin.vm.VirtualMachines;

public class DefaultMachine
implements InternalMachine {
    private final InternalAdmin admin;
    private final String uid;
    private final String hostAddress;
    private final InternalLookupServices lookupServices;
    private final InternalGridServiceAgents gridServiceAgents;
    private final InternalGridServiceManagers gridServiceManagers;
    private final InternalElasticServiceManagers elasticServiceManagers;
    private final InternalGridServiceContainers gridServiceContainers;
    private final InternalTransports transports;
    private final InternalVirtualMachines virtualMachines;
    private final InternalProcessingUnitInstances processingUnitInstances;
    private final InternalSpaceInstances spaceInstances;
    private volatile OperatingSystem operatingSystem;
    private static OperatingSystem NA_OPERATING_SYSTEM = new DefaultOperatingSystem(new OSDetails(), null);

    public DefaultMachine(InternalAdmin admin, String uid, String hostAddress) {
        this.admin = admin;
        this.uid = uid;
        this.hostAddress = hostAddress;
        this.gridServiceAgents = new DefaultGridServiceAgents(admin);
        this.lookupServices = new DefaultLookupServices(admin);
        this.gridServiceManagers = new DefaultGridServiceManagers(admin);
        this.elasticServiceManagers = new DefaultElasticServiceManagers(admin);
        this.gridServiceContainers = new DefaultGridServiceContainers(admin);
        this.virtualMachines = new DefaultVirtualMachines(admin);
        this.processingUnitInstances = new DefaultProcessingUnitInstances(admin);
        this.spaceInstances = new DefaultSpaceInstances(admin);
        this.transports = new DefaultTransports(admin);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getHostAddress() {
        return this.hostAddress;
    }

    @Override
    public String getHostName() {
        return this.operatingSystem.getDetails().getHostName();
    }

    @Override
    public GridServiceAgent getGridServiceAgent() {
        Iterator it = this.gridServiceAgents.iterator();
        if (it.hasNext()) {
            return (GridServiceAgent)it.next();
        }
        return null;
    }

    @Override
    public GridServiceAgents getGridServiceAgents() {
        return this.gridServiceAgents;
    }

    @Override
    public LookupServices getLookupServices() {
        return this.lookupServices;
    }

    @Override
    public GridServiceManagers getGridServiceManagers() {
        return this.gridServiceManagers;
    }

    @Override
    public ElasticServiceManagers getElasticServiceManagers() {
        return this.elasticServiceManagers;
    }

    @Override
    public GridServiceContainers getGridServiceContainers() {
        return this.gridServiceContainers;
    }

    @Override
    public boolean hasGridComponents() {
        return !this.gridServiceAgents.isEmpty() || !this.gridServiceManagers.isEmpty() || !this.elasticServiceManagers.isEmpty() || !this.gridServiceContainers.isEmpty() || !this.lookupServices.isEmpty();
    }

    @Override
    public Transports getTransports() {
        return this.transports;
    }

    @Override
    public ProcessingUnit[] getProcessingUnits() {
        if (this.processingUnitInstances.getInstances().length == 0) {
            return new ProcessingUnit[0];
        }
        HashSet<ProcessingUnit> processingUnitSet = new HashSet<ProcessingUnit>();
        for (ProcessingUnitInstance processingUnitInstance : this.processingUnitInstances.getInstances()) {
            processingUnitSet.add(processingUnitInstance.getProcessingUnit());
        }
        return processingUnitSet.toArray(new ProcessingUnit[processingUnitSet.size()]);
    }

    @Override
    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.assertStateChangesPermitted();
        this.operatingSystem = operatingSystem;
    }

    public boolean hasOperatingSystem() {
        return this.operatingSystem != null;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        if (this.operatingSystem == null) {
            return NA_OPERATING_SYSTEM;
        }
        return this.operatingSystem;
    }

    @Override
    public VirtualMachines getVirtualMachines() {
        return this.virtualMachines;
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstances.getProcessingUnitInstanceAdded();
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstances.getProcessingUnitInstanceRemoved();
    }

    @Override
    public void addLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.addProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public void removeLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.removeProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        return this.processingUnitInstances.getInstances();
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances(String processingUnitName) {
        return this.processingUnitInstances.getInstances(processingUnitName);
    }

    @Override
    public boolean contains(ProcessingUnitInstance processingUnitInstance) {
        return this.processingUnitInstances.contains(processingUnitInstance);
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        return this.spaceInstances.getSpaceInstances();
    }

    @Override
    public boolean contains(SpaceInstance spaceInstance) {
        return this.spaceInstances.contains(spaceInstance);
    }

    @Override
    public SpaceInstanceAddedEventManager getSpaceInstanceAdded() {
        return this.spaceInstances.getSpaceInstanceAdded();
    }

    @Override
    public SpaceInstanceRemovedEventManager getSpaceInstanceRemoved() {
        return this.spaceInstances.getSpaceInstanceRemoved();
    }

    @Override
    public void addLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstances.addLifecycleListener(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstances.removeLifecycleListener(eventListener);
    }

    @Override
    public void addProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.processingUnitInstances.addInstance(processingUnitInstance);
    }

    @Override
    public void removeProcessingUnitInstance(String uid) {
        this.processingUnitInstances.removeInstance(uid);
    }

    @Override
    public void addSpaceInstance(SpaceInstance spaceInstance) {
        this.spaceInstances.addSpaceInstance(spaceInstance);
    }

    @Override
    public void removeSpaceInstance(String uid) {
        this.spaceInstances.removeSpaceInstance(uid);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        if ((context = this.setMachineUidToContext(context)).containsKey("gsconly")) {
            for (GridServiceContainer gsc : this.gridServiceContainers) {
                dumpResult.add(gsc.generateDump(cause, context, processor));
            }
        } else {
            for (ElasticServiceManager esm : this.elasticServiceManagers) {
                dumpResult.add(esm.generateDump(cause, context, processor));
            }
            for (GridServiceManager gsm : this.gridServiceManagers) {
                dumpResult.add(gsm.generateDump(cause, context, processor));
            }
            for (GridServiceContainer gsc : this.gridServiceContainers) {
                dumpResult.add(gsc.generateDump(cause, context, processor));
            }
            for (GridServiceAgent gsa : this.gridServiceAgents) {
                dumpResult.add(gsa.generateDump(cause, context, processor));
            }
            for (LookupService lus : this.lookupServices) {
                dumpResult.add(lus.generateDump(cause, context, processor));
            }
        }
        if (this.includeOverviewFile(context)) {
            dumpResult.addDumpFile(InternalOverviewBuilder.createOverviewDumpResult(this.admin));
        }
        return dumpResult;
    }

    private boolean includeOverviewFile(Map<String, Object> context) {
        boolean include = true;
        if (context != null && context.containsKey("include-overview")) {
            include = (Boolean)context.get("include-overview");
        }
        return include;
    }

    private Map<String, Object> setMachineUidToContext(Map<String, Object> context) {
        String parentDirName = this.getHostName() != null ? this.getHostName() : this.getHostAddress();
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        context.put("parentDirName", parentDirName);
        return context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMachine that = (DefaultMachine)o;
        return this.uid.equals(that.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

