/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.machine;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.machine.InternalMachine;
import org.openspaces.admin.internal.machine.InternalMachines;
import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningFailureEventManager;
import org.openspaces.admin.internal.machine.events.DefaultElasticMachineProvisioningProgressChangedEventManager;
import org.openspaces.admin.internal.machine.events.DefaultMachineAddedEventManager;
import org.openspaces.admin.internal.machine.events.DefaultMachineRemovedEventManager;
import org.openspaces.admin.internal.machine.events.InternalElasticMachineProvisioningFailureEventManager;
import org.openspaces.admin.internal.machine.events.InternalElasticMachineProvisioningProgressChangedEventManager;
import org.openspaces.admin.internal.machine.events.InternalMachineAddedEventManager;
import org.openspaces.admin.internal.machine.events.InternalMachineRemovedEventManager;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningFailureEvent;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningFailureEventManager;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningProgressChangedEvent;
import org.openspaces.admin.machine.events.ElasticMachineProvisioningProgressChangedEventManager;
import org.openspaces.admin.machine.events.MachineAddedEventListener;
import org.openspaces.admin.machine.events.MachineAddedEventManager;
import org.openspaces.admin.machine.events.MachineLifecycleEventListener;
import org.openspaces.admin.machine.events.MachineRemovedEventListener;
import org.openspaces.admin.machine.events.MachineRemovedEventManager;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;

public class DefaultMachines
implements InternalMachines {
    private final InternalAdmin admin;
    private final InternalMachineAddedEventManager machineAddedEventManager;
    private final InternalMachineRemovedEventManager machineRemovedEventManager;
    private final InternalElasticMachineProvisioningProgressChangedEventManager elasticMachineProvisioningProgressChangedEventManager;
    private final InternalElasticMachineProvisioningFailureEventManager elasticMachineProvisioningFailureEventManager;
    private final Map<String, Machine> machinesById = new SizeConcurrentHashMap();
    private final Map<String, Machine> machinesByHostAddress = new ConcurrentHashMap<String, Machine>();
    private final Map<String, Machine> machinesByHostNames = new ConcurrentHashMap<String, Machine>();

    public DefaultMachines(InternalAdmin admin) {
        this.admin = admin;
        this.machineAddedEventManager = new DefaultMachineAddedEventManager(this);
        this.machineRemovedEventManager = new DefaultMachineRemovedEventManager(this);
        this.elasticMachineProvisioningProgressChangedEventManager = new DefaultElasticMachineProvisioningProgressChangedEventManager(admin);
        this.elasticMachineProvisioningFailureEventManager = new DefaultElasticMachineProvisioningFailureEventManager(admin);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public Machine[] getMachines() {
        return this.machinesById.values().toArray(new Machine[0]);
    }

    @Override
    public MachineAddedEventManager getMachineAdded() {
        return this.machineAddedEventManager;
    }

    @Override
    public MachineRemovedEventManager getMachineRemoved() {
        return this.machineRemovedEventManager;
    }

    @Override
    public int getSize() {
        return this.machinesById.size();
    }

    @Override
    public boolean isEmpty() {
        return this.machinesById.isEmpty();
    }

    @Override
    public boolean waitFor(int numberOfMachines) {
        return this.waitFor(numberOfMachines, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfMachines, long timeout, TimeUnit timeUnit) {
        if (numberOfMachines == 0) {
            final CountDownLatch latch = new CountDownLatch(this.getSize());
            MachineRemovedEventListener removed = new MachineRemovedEventListener(){

                @Override
                public void machineRemoved(Machine machine) {
                    latch.countDown();
                }
            };
            this.getMachineRemoved().add(removed);
            try {
                boolean bl = latch.await(timeout, timeUnit);
                return bl;
            }
            catch (InterruptedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.getMachineRemoved().remove(removed);
            }
        }
        final CountDownLatch latch = new CountDownLatch(numberOfMachines);
        MachineAddedEventListener added = new MachineAddedEventListener(){

            @Override
            public void machineAdded(Machine machine) {
                latch.countDown();
            }
        };
        this.getMachineAdded().add(added);
        try {
            boolean e = latch.await(timeout, timeUnit);
            return e;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getMachineAdded().remove(added);
        }
    }

    @Override
    public Machine waitFor(String hostAddress) {
        return this.waitFor(hostAddress, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Machine waitFor(final String hostAddress, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        MachineAddedEventListener added = new MachineAddedEventListener(){

            @Override
            public void machineAdded(Machine machine) {
                if (machine.getHostAddress().equalsIgnoreCase(hostAddress) || machine.getHostName().equalsIgnoreCase(hostAddress)) {
                    ref.set(machine);
                    latch.countDown();
                }
            }
        };
        this.getMachineAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            Machine machine = (Machine)ref.get();
            return machine;
        }
        catch (InterruptedException e) {
            Machine machine = null;
            return machine;
        }
        finally {
            this.getMachineAdded().remove(added);
        }
    }

    @Override
    public Iterator<Machine> iterator() {
        return Collections.unmodifiableCollection(this.machinesById.values()).iterator();
    }

    @Override
    public Machine getMachineByUID(String uid) {
        return this.machinesById.get(uid);
    }

    @Override
    public Machine getMachineByHostAddress(String ipAddress) {
        return this.machinesByHostAddress.get(ipAddress);
    }

    @Override
    public Machine getMachineByHostName(String hostName) {
        return this.machinesByHostNames.get(hostName);
    }

    @Override
    public Map<String, Machine> getUids() {
        return Collections.unmodifiableMap(this.machinesById);
    }

    @Override
    public Map<String, Machine> getHostsByAddress() {
        return Collections.unmodifiableMap(this.machinesByHostAddress);
    }

    @Override
    public Map<String, Machine> getHostsByName() {
        return Collections.unmodifiableMap(this.machinesByHostNames);
    }

    @Override
    public void addLifecycleListener(MachineLifecycleEventListener eventListener) {
        this.getMachineAdded().add(eventListener);
        this.getMachineRemoved().add(eventListener);
    }

    @Override
    public void removeLifeycleListener(MachineLifecycleEventListener eventListener) {
        this.getMachineAdded().remove(eventListener);
        this.getMachineRemoved().remove(eventListener);
    }

    @Override
    public void addMachine(InternalMachine machine) {
        this.assertStateChangesPermitted();
        this.machinesByHostAddress.put(machine.getHostAddress(), machine);
        this.machinesByHostNames.put(machine.getHostName(), machine);
        Machine existingMachine = this.machinesById.put(machine.getUid(), machine);
        if (existingMachine == null) {
            this.machineAddedEventManager.machineAdded(machine);
        }
    }

    @Override
    public void removeMachine(Machine machine) {
        this.assertStateChangesPermitted();
        if (machine.getVirtualMachines().isEmpty()) {
            this.machinesByHostAddress.remove(machine.getHostAddress());
            this.machinesByHostNames.remove(machine.getHostName());
            Machine existingMachine = this.machinesById.remove(machine.getUid());
            if (existingMachine != null) {
                this.machineRemovedEventManager.machineRemoved(machine);
            }
        }
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public ElasticMachineProvisioningFailureEventManager getElasticMachineProvisioningFailure() {
        return this.elasticMachineProvisioningFailureEventManager;
    }

    @Override
    public ElasticMachineProvisioningProgressChangedEventManager getElasticMachineProvisioningProgressChanged() {
        return this.elasticMachineProvisioningProgressChangedEventManager;
    }

    @Override
    public void processElasticScaleStrategyEvent(ElasticProcessingUnitEvent event) {
        if (event instanceof ElasticMachineProvisioningFailureEvent) {
            this.elasticMachineProvisioningFailureEventManager.elasticMachineProvisioningFailure((ElasticMachineProvisioningFailureEvent)event);
        } else if (event instanceof ElasticMachineProvisioningProgressChangedEvent) {
            this.elasticMachineProvisioningProgressChangedEventManager.elasticMachineProvisioningProgressChanged((ElasticMachineProvisioningProgressChangedEvent)event);
        }
    }
}

