/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.machine.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.machine.InternalMachines;
import org.openspaces.admin.internal.machine.events.ClosureMachineAddedEventListener;
import org.openspaces.admin.internal.machine.events.InternalMachineAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.events.MachineAddedEventListener;

public class DefaultMachineAddedEventManager
implements InternalMachineAddedEventManager {
    private final InternalMachines machines;
    private final InternalAdmin admin;
    private final List<MachineAddedEventListener> machineAddedEventListeners = new CopyOnWriteArrayList<MachineAddedEventListener>();

    public DefaultMachineAddedEventManager(InternalMachines machines) {
        this.machines = machines;
        this.admin = (InternalAdmin)machines.getAdmin();
    }

    @Override
    public void machineAdded(final Machine machine) {
        for (final MachineAddedEventListener listener : this.machineAddedEventListeners) {
            this.admin.pushEventAsFirst(listener, new Runnable(){

                @Override
                public void run() {
                    listener.machineAdded(machine);
                }
            });
        }
    }

    @Override
    public void add(final MachineAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (Machine machine : DefaultMachineAddedEventManager.this.machines.getMachines()) {
                        eventListener.machineAdded(machine);
                    }
                }
            });
        }
        this.machineAddedEventListeners.add(eventListener);
    }

    @Override
    public void add(MachineAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(MachineAddedEventListener eventListener) {
        this.machineAddedEventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureMachineAddedEventListener(eventListener));
        } else {
            this.add((MachineAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureMachineAddedEventListener(eventListener));
        } else {
            this.remove((MachineAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

