/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.machine.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.machine.InternalMachines;
import org.openspaces.admin.internal.machine.events.ClosureMachineRemovedEventListener;
import org.openspaces.admin.internal.machine.events.InternalMachineRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.machine.events.MachineRemovedEventListener;

public class DefaultMachineRemovedEventManager
implements InternalMachineRemovedEventManager {
    private final InternalMachines machines;
    private final InternalAdmin admin;
    private final List<MachineRemovedEventListener> machineRemovedEventListeners = new CopyOnWriteArrayList<MachineRemovedEventListener>();

    public DefaultMachineRemovedEventManager(InternalMachines machines) {
        this.machines = machines;
        this.admin = (InternalAdmin)machines.getAdmin();
    }

    @Override
    public void machineRemoved(final Machine machine) {
        for (final MachineRemovedEventListener listener : this.machineRemovedEventListeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.machineRemoved(machine);
                }
            });
        }
    }

    @Override
    public void add(MachineRemovedEventListener eventListener) {
        this.machineRemovedEventListeners.add(eventListener);
    }

    @Override
    public void remove(MachineRemovedEventListener eventListener) {
        this.machineRemovedEventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureMachineRemovedEventListener(eventListener));
        } else {
            this.add((MachineRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureMachineRemovedEventListener(eventListener));
        } else {
            this.remove((MachineRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

