/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os;

import com.gigaspaces.internal.os.OSDetails;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.os.DefaultOperatingSystemDetails;
import org.openspaces.admin.internal.os.DefaultOperatingSystemStatistics;
import org.openspaces.admin.internal.os.InternalOperatingSystem;
import org.openspaces.admin.internal.os.InternalOperatingSystemInfoProvider;
import org.openspaces.admin.internal.os.InternalOperatingSystems;
import org.openspaces.admin.internal.os.events.DefaultOperatingSystemStatisticsChangedEventManager;
import org.openspaces.admin.internal.os.events.InternalOperatingSystemStatisticsChangedEventManager;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEvent;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEventManager;
import org.openspaces.core.util.ConcurrentHashSet;

public class DefaultOperatingSystem
implements InternalOperatingSystem {
    private final String uid;
    private final OperatingSystemDetails details;
    private final InternalAdmin admin;
    private final InternalOperatingSystems operatingSystems;
    private final Set<InternalOperatingSystemInfoProvider> operatingSystemInfoProviders = new ConcurrentHashSet();
    private final InternalOperatingSystemStatisticsChangedEventManager statisticsChangedEventManager;
    private final LastStatisticsHolder<OperatingSystemStatistics> lastStatisticsHolder = new LastStatisticsHolder<DefaultOperatingSystemStatistics>(new DefaultOperatingSystemStatistics());
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private volatile long timeDelta = Integer.MIN_VALUE;

    public DefaultOperatingSystem(OSDetails osDetails, InternalOperatingSystems operatingSystems) {
        this.details = new DefaultOperatingSystemDetails(osDetails);
        this.uid = this.details.getUid();
        this.operatingSystems = operatingSystems;
        this.admin = operatingSystems != null ? (InternalAdmin)operatingSystems.getAdmin() : null;
        this.statisticsChangedEventManager = new DefaultOperatingSystemStatisticsChangedEventManager(this.admin, this);
        if (this.admin != null) {
            this.admin.getScheduler().schedule(new Runnable(){

                @Override
                public void run() {
                    long localTimestamp = System.currentTimeMillis();
                    long machineCurrentTimestamp = DefaultOperatingSystem.this.getCurrentTimeInMillis();
                    if (System.currentTimeMillis() - localTimestamp > 200L) {
                        DefaultOperatingSystem.this.admin.getScheduler().schedule(this, 50L, TimeUnit.MILLISECONDS);
                    } else if (machineCurrentTimestamp != -1L) {
                        DefaultOperatingSystem.this.timeDelta = localTimestamp - machineCurrentTimestamp;
                    } else {
                        DefaultOperatingSystem.this.admin.getScheduler().schedule(this, 50L, TimeUnit.MILLISECONDS);
                    }
                }
            }, 10L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public void addOperatingSystemInfoProvider(InternalOperatingSystemInfoProvider provider) {
        this.assertStateChangesPermitted();
        this.operatingSystemInfoProviders.add(provider);
    }

    @Override
    public void removeOperatingSystemInfoProvider(InternalOperatingSystemInfoProvider provider) {
        this.assertStateChangesPermitted();
        this.operatingSystemInfoProviders.remove(provider);
    }

    @Override
    public boolean hasOperatingSystemInfoProviders() {
        return !this.operatingSystemInfoProviders.isEmpty();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public long getTimeDelta() {
        return this.timeDelta;
    }

    @Override
    public long getCurrentTimeInMillis() {
        for (InternalOperatingSystemInfoProvider provider : this.operatingSystemInfoProviders) {
            try {
                return provider.getCurrentTimeInMillis();
            }
            catch (RemoteException remoteException) {
            }
        }
        return -1L;
    }

    @Override
    public OperatingSystemDetails getDetails() {
        return this.details;
    }

    @Override
    public OperatingSystemStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics().isNA()) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private OperatingSystemStatistics doGetStatistics() {
        for (InternalOperatingSystemInfoProvider provider : this.operatingSystemInfoProviders) {
            try {
                OperatingSystemStatistics previousStats = this.lastStatisticsHolder.getLastStatistics();
                return new DefaultOperatingSystemStatistics(provider.getOSStatistics(), this.getDetails(), previousStats, this.scheduledStatisticsHolder.getStatisticsHistorySize(), this.timeDelta);
            }
            catch (RemoteException remoteException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.stopStatisticsMonitor();
                this.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            final DefaultOperatingSystem operatingSystem = this;
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    OperatingSystemStatistics stats = operatingSystem.getStatistics();
                    if (!stats.isNA()) {
                        OperatingSystemStatisticsChangedEvent event = new OperatingSystemStatisticsChangedEvent(operatingSystem, stats);
                        DefaultOperatingSystem.this.statisticsChangedEventManager.operatingSystemStatisticsChanged(event);
                        ((InternalOperatingSystemStatisticsChangedEventManager)DefaultOperatingSystem.this.operatingSystems.getOperatingSystemStatisticsChanged()).operatingSystemStatisticsChanged(event);
                    }
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    @Override
    public OperatingSystemStatisticsChangedEventManager getStatisticsChanged() {
        return this.statisticsChangedEventManager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultOperatingSystem that = (DefaultOperatingSystem)o;
        return this.uid.equals(that.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

