/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os;

import com.gigaspaces.internal.os.OSDetails;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.support.StatisticsUtils;

public class DefaultOperatingSystemDetails
implements OperatingSystemDetails {
    private final OSDetails details;
    private final Map<String, OperatingSystemDetails.NetworkDetails> networkDetailsMap = new HashMap<String, OperatingSystemDetails.NetworkDetails>();
    private final Map<String, OperatingSystemDetails.DriveDetails> driveDetailsMap = new HashMap<String, OperatingSystemDetails.DriveDetails>();
    private final OperatingSystemDetails.VendorDetails vendorDetails;

    public DefaultOperatingSystemDetails(OSDetails details) {
        OSDetails.OSDriveDetails[] driveConfigs;
        this.details = details;
        OSDetails.OSNetInterfaceDetails[] netInterfaceConfigs = details.getNetInterfaceConfigs();
        if (netInterfaceConfigs != null) {
            for (OSDetails.OSNetInterfaceDetails netInterfaceConfig : netInterfaceConfigs) {
                this.networkDetailsMap.put(netInterfaceConfig.getName(), new DefaultNetworkDetails(netInterfaceConfig));
            }
        }
        if ((driveConfigs = details.getDriveConfigs()) != null) {
            for (OSDetails.OSDriveDetails driveConfig : driveConfigs) {
                this.driveDetailsMap.put(driveConfig.getName(), new DefaultDriveDetails(driveConfig));
            }
        }
        this.vendorDetails = details.getVendorDetails() != null ? new DefaultVendorDetails(details.getVendorDetails()) : null;
    }

    @Override
    public boolean isNA() {
        return this.details.isNA();
    }

    @Override
    public String getUid() {
        return this.details.getUID();
    }

    @Override
    public String getName() {
        return this.details.getName();
    }

    @Override
    public String getArch() {
        return this.details.getArch();
    }

    @Override
    public String getVersion() {
        return this.details.getVersion();
    }

    @Override
    public int getAvailableProcessors() {
        return this.details.getAvailableProcessors();
    }

    @Override
    public long getTotalSwapSpaceSizeInBytes() {
        return this.details.getTotalSwapSpaceSize();
    }

    @Override
    public double getTotalSwapSpaceSizeInMB() {
        return StatisticsUtils.convertToMB(this.getTotalSwapSpaceSizeInBytes());
    }

    @Override
    public double getTotalSwapSpaceSizeInGB() {
        return StatisticsUtils.convertToGB(this.getTotalSwapSpaceSizeInBytes());
    }

    @Override
    public long getTotalPhysicalMemorySizeInBytes() {
        return this.details.getTotalPhysicalMemorySize();
    }

    @Override
    public double getTotalPhysicalMemorySizeInMB() {
        return StatisticsUtils.convertToMB(this.getTotalPhysicalMemorySizeInBytes());
    }

    @Override
    public double getTotalPhysicalMemorySizeInGB() {
        return StatisticsUtils.convertToGB(this.getTotalPhysicalMemorySizeInBytes());
    }

    @Override
    public String getHostName() {
        return this.details.getHostName();
    }

    @Override
    public String getHostAddress() {
        return this.details.getHostAddress();
    }

    @Override
    public Map<String, OperatingSystemDetails.NetworkDetails> getNetworkDetails() {
        return Collections.unmodifiableMap(this.networkDetailsMap);
    }

    @Override
    public Map<String, OperatingSystemDetails.DriveDetails> getDriveDetails() {
        return Collections.unmodifiableMap(this.driveDetailsMap);
    }

    @Override
    public OperatingSystemDetails.VendorDetails getVendorDetails() {
        return this.vendorDetails;
    }

    private static class DefaultVendorDetails
    implements OperatingSystemDetails.VendorDetails {
        private final String vendor;
        private final String vendorCodeName;
        private final String vendorName;
        private final String vendorVersion;

        public DefaultVendorDetails(OSDetails.OSVendorDetails vendorDetails) {
            this.vendor = vendorDetails.getVendor();
            this.vendorCodeName = vendorDetails.getVendorCodeName();
            this.vendorName = vendorDetails.getVendorName();
            this.vendorVersion = vendorDetails.getVendorVersion();
        }

        @Override
        public String getVendor() {
            return this.vendor;
        }

        @Override
        public String getVendorCodeName() {
            return this.vendorCodeName;
        }

        @Override
        public String getVendorName() {
            return this.vendorName;
        }

        @Override
        public String getVendorVersion() {
            return this.vendorVersion;
        }
    }

    private static class DefaultDriveDetails
    implements OperatingSystemDetails.DriveDetails {
        private final String name;
        private final Long capacityInMB;

        private DefaultDriveDetails(OSDetails.OSDriveDetails driveDetails) {
            this.name = driveDetails.getName();
            this.capacityInMB = driveDetails.getCapacityInMB();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Long getCapacityInMB() {
            return this.capacityInMB;
        }
    }

    private static class DefaultNetworkDetails
    implements OperatingSystemDetails.NetworkDetails {
        private final String name;
        private final String description;
        private final String address;

        private DefaultNetworkDetails(OSDetails.OSNetInterfaceDetails networkInterfaceDetails) {
            this.name = networkInterfaceDetails.getName();
            this.description = networkInterfaceDetails.getDescription();
            this.address = networkInterfaceDetails.getAddress();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getAddress() {
            return this.address;
        }
    }
}

