/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os;

import com.gigaspaces.internal.os.OSStatistics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.support.StatisticsUtils;

public class DefaultOperatingSystemStatistics
implements OperatingSystemStatistics {
    private static final OSStatistics NA_STATS = new OSStatistics();
    private final long timeDelta;
    private final OSStatistics stats;
    private final OperatingSystemDetails details;
    private volatile OperatingSystemStatistics previousStats;
    private Map<String, OperatingSystemStatistics.NetworkStatistics> netStats;

    public DefaultOperatingSystemStatistics() {
        this(NA_STATS, null, null, 0, -1L);
    }

    public DefaultOperatingSystemStatistics(OSStatistics stats, OperatingSystemDetails details, OperatingSystemStatistics previousStats, int historySize, long timeDelta) {
        this.stats = stats;
        this.details = details;
        this.previousStats = previousStats;
        this.timeDelta = timeDelta;
        OperatingSystemStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultOperatingSystemStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.stats.isNA();
    }

    @Override
    public List<OperatingSystemStatistics> getTimeline() {
        ArrayList<OperatingSystemStatistics> timeline = new ArrayList<OperatingSystemStatistics>();
        timeline.add(this);
        for (OperatingSystemStatistics current = this.getPrevious(); current != null && !current.isNA(); current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }

    @Override
    public long getTimestamp() {
        return this.stats.getTimestamp();
    }

    @Override
    public long getAdminTimestamp() {
        if (this.stats.getTimestamp() != -1L && this.timeDelta != Integer.MIN_VALUE) {
            return this.stats.getTimestamp() + this.timeDelta;
        }
        return -1L;
    }

    @Override
    public OperatingSystemDetails getDetails() {
        return this.details;
    }

    @Override
    public OperatingSystemStatistics getPrevious() {
        return this.previousStats;
    }

    public void setPreviousStats(OperatingSystemStatistics previosStats) {
        this.previousStats = previosStats;
    }

    @Override
    public long getFreeSwapSpaceSizeInBytes() {
        return this.stats.getFreeSwapSpaceSize();
    }

    @Override
    public double getFreeSwapSpaceSizeInMB() {
        return StatisticsUtils.convertToMB(this.getFreeSwapSpaceSizeInBytes());
    }

    @Override
    public double getFreeSwapSpaceSizeInGB() {
        return StatisticsUtils.convertToGB(this.getFreeSwapSpaceSizeInBytes());
    }

    @Override
    public double getSwapSpaceUsedPerc() {
        if (this.isNA()) {
            return -1.0;
        }
        return StatisticsUtils.computePerc(this.getDetails().getTotalSwapSpaceSizeInBytes() - this.getFreeSwapSpaceSizeInBytes(), this.getDetails().getTotalSwapSpaceSizeInBytes());
    }

    @Override
    public long getFreePhysicalMemorySizeInBytes() {
        return this.stats.getFreePhysicalMemorySize();
    }

    @Override
    public double getFreePhysicalMemorySizeInMB() {
        return StatisticsUtils.convertToMB(this.getFreePhysicalMemorySizeInBytes());
    }

    @Override
    public double getFreePhysicalMemorySizeInGB() {
        return StatisticsUtils.convertToGB(this.getFreePhysicalMemorySizeInBytes());
    }

    @Override
    public long getActualFreePhysicalMemorySizeInBytes() {
        return this.stats.getActualFreePhysicalMemorySize();
    }

    @Override
    public double getActualFreePhysicalMemorySizeInMB() {
        return StatisticsUtils.convertToMB(this.getActualFreePhysicalMemorySizeInBytes());
    }

    @Override
    public double getActualFreePhysicalMemorySizeInGB() {
        return StatisticsUtils.convertToGB(this.getActualFreePhysicalMemorySizeInBytes());
    }

    @Override
    public double getPhysicalMemoryUsedPerc() {
        if (this.isNA()) {
            return -1.0;
        }
        return this.stats.getUsedMemoryPerc() < 0.0 ? StatisticsUtils.computePerc(this.getDetails().getTotalPhysicalMemorySizeInBytes() - this.getFreePhysicalMemorySizeInBytes(), this.getDetails().getTotalPhysicalMemorySizeInBytes()) : this.stats.getUsedMemoryPerc();
    }

    @Override
    public double getActualPhysicalMemoryUsedPerc() {
        if (this.isNA()) {
            return -1.0;
        }
        return StatisticsUtils.computePerc(this.getDetails().getTotalPhysicalMemorySizeInBytes() - this.getActualFreePhysicalMemorySizeInBytes(), this.getDetails().getTotalPhysicalMemorySizeInBytes());
    }

    @Override
    public double getCpuPerc() {
        return this.stats.getCpuPerc();
    }

    @Override
    public String getCpuPercFormatted() {
        return StatisticsUtils.formatPerc(this.getCpuPerc());
    }

    @Override
    public long getActualMemoryUsed() {
        return this.stats.getActualMemoryUsed();
    }

    @Override
    public Map<String, OperatingSystemStatistics.NetworkStatistics> getNetworkStats() {
        if (this.netStats != null) {
            return this.netStats;
        }
        if (this.stats.getNetStats() == null) {
            return null;
        }
        HashMap<String, OperatingSystemStatistics.NetworkStatistics> netStats = new HashMap<String, OperatingSystemStatistics.NetworkStatistics>();
        for (int i = 0; i < this.stats.getNetStats().length; ++i) {
            OperatingSystemStatistics.NetworkStatistics previousNetStats = null;
            if (this.getPrevious() != null && !this.getPrevious().isNA()) {
                previousNetStats = this.getPrevious().getNetworkStats().get(this.stats.getNetStats()[i].getName());
            }
            netStats.put(this.stats.getNetStats()[i].getName(), new DefaultNetworkStatistics(this.stats.getNetStats()[i], previousNetStats));
        }
        this.netStats = netStats;
        return netStats;
    }

    private class DefaultNetworkStatistics
    implements OperatingSystemStatistics.NetworkStatistics {
        private final OSStatistics.OSNetInterfaceStats netStats;
        private final OperatingSystemStatistics.NetworkStatistics prevNetStats;

        private DefaultNetworkStatistics(OSStatistics.OSNetInterfaceStats netStats, OperatingSystemStatistics.NetworkStatistics prevNetStats) {
            this.netStats = netStats;
            this.prevNetStats = prevNetStats;
        }

        @Override
        public OperatingSystemStatistics.NetworkStatistics getPrevious() {
            return this.prevNetStats;
        }

        @Override
        public String getName() {
            return this.netStats.getName();
        }

        @Override
        public long getRxBytes() {
            return this.netStats.getRxBytes();
        }

        @Override
        public double getRxBytesPerSecond() {
            if (this.prevNetStats == null || DefaultOperatingSystemStatistics.this.previousStats == null) {
                return -1.0;
            }
            return StatisticsUtils.computePerSecond(this.getRxBytes(), this.prevNetStats.getRxBytes(), DefaultOperatingSystemStatistics.this.getTimestamp(), DefaultOperatingSystemStatistics.this.previousStats.getTimestamp());
        }

        @Override
        public long getTxBytes() {
            return this.netStats.getTxBytes();
        }

        @Override
        public double getTxBytesPerSecond() {
            if (this.prevNetStats == null || DefaultOperatingSystemStatistics.this.previousStats == null) {
                return -1.0;
            }
            return StatisticsUtils.computePerSecond(this.getTxBytes(), this.prevNetStats.getTxBytes(), DefaultOperatingSystemStatistics.this.getTimestamp(), DefaultOperatingSystemStatistics.this.previousStats.getTimestamp());
        }

        @Override
        public long getRxPackets() {
            return this.netStats.getRxPackets();
        }

        @Override
        public double getRxPacketsPerSecond() {
            if (this.prevNetStats == null || DefaultOperatingSystemStatistics.this.previousStats == null) {
                return -1.0;
            }
            return StatisticsUtils.computePerSecond(this.getRxPackets(), this.prevNetStats.getRxPackets(), DefaultOperatingSystemStatistics.this.getTimestamp(), DefaultOperatingSystemStatistics.this.previousStats.getTimestamp());
        }

        @Override
        public long getTxPackets() {
            return this.netStats.getTxPackets();
        }

        @Override
        public double getTxPacketsPerSecond() {
            if (this.prevNetStats == null || DefaultOperatingSystemStatistics.this.previousStats == null) {
                return -1.0;
            }
            return StatisticsUtils.computePerSecond(this.getTxPackets(), this.prevNetStats.getTxPackets(), DefaultOperatingSystemStatistics.this.getTimestamp(), DefaultOperatingSystemStatistics.this.previousStats.getTimestamp());
        }

        @Override
        public long getRxErrors() {
            return this.netStats.getRxErrors();
        }

        @Override
        public long getTxErrors() {
            return this.netStats.getTxErrors();
        }

        @Override
        public long getRxDropped() {
            return this.netStats.getRxDropped();
        }

        @Override
        public long getTxDropped() {
            return this.netStats.getTxDropped();
        }
    }
}

