/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.os.DefaultOperatingSystemsDetails;
import org.openspaces.admin.internal.os.DefaultOperatingSystemsStatistics;
import org.openspaces.admin.internal.os.InternalOperatingSystems;
import org.openspaces.admin.internal.os.events.DefaultOperatingSystemStatisticsChangedEventManager;
import org.openspaces.admin.internal.os.events.DefaultOperatingSystemsStatisticsChangedEventManager;
import org.openspaces.admin.internal.os.events.InternalOperatingSystemStatisticsChangedEventManager;
import org.openspaces.admin.internal.os.events.InternalOperatingSystemsStatisticsChangedEventManager;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.os.OperatingSystem;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.os.OperatingSystemsDetails;
import org.openspaces.admin.os.OperatingSystemsStatistics;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEventManager;
import org.openspaces.admin.os.events.OperatingSystemsStatisticsChangedEvent;
import org.openspaces.admin.os.events.OperatingSystemsStatisticsChangedEventManager;

public class DefaultOperatingSystems
implements InternalOperatingSystems {
    private final InternalAdmin admin;
    private final Map<String, OperatingSystem> operatingSystemsByUID = new SizeConcurrentHashMap();
    private final InternalOperatingSystemsStatisticsChangedEventManager statisticsChangedEventManager;
    private final InternalOperatingSystemStatisticsChangedEventManager operatingSystemStatisticsChangedEventManager;
    private final LastStatisticsHolder<OperatingSystemsStatistics> lastStatisticsHolder = new LastStatisticsHolder();
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();

    public DefaultOperatingSystems(InternalAdmin admin) {
        this.admin = admin;
        this.statisticsChangedEventManager = new DefaultOperatingSystemsStatisticsChangedEventManager(admin, this);
        this.operatingSystemStatisticsChangedEventManager = new DefaultOperatingSystemStatisticsChangedEventManager(admin, this);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public OperatingSystem[] getOperatingSystems() {
        return this.operatingSystemsByUID.values().toArray(new OperatingSystem[0]);
    }

    @Override
    public Iterator<OperatingSystem> iterator() {
        return Collections.unmodifiableCollection(this.operatingSystemsByUID.values()).iterator();
    }

    @Override
    public int getSize() {
        return this.operatingSystemsByUID.size();
    }

    @Override
    public OperatingSystemsDetails getDetails() {
        ArrayList<OperatingSystemDetails> details = new ArrayList<OperatingSystemDetails>();
        for (OperatingSystem os : this.operatingSystemsByUID.values()) {
            details.add(os.getDetails());
        }
        return new DefaultOperatingSystemsDetails(details.toArray(new OperatingSystemDetails[details.size()]));
    }

    @Override
    public OperatingSystemsStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics() == null) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private OperatingSystemsStatistics doGetStatistics() {
        ArrayList<OperatingSystemStatistics> stats = new ArrayList<OperatingSystemStatistics>();
        ArrayList<OperatingSystemDetails> details = new ArrayList<OperatingSystemDetails>();
        for (OperatingSystem os : this.operatingSystemsByUID.values()) {
            stats.add(os.getStatistics());
            details.add(os.getDetails());
        }
        OperatingSystemsStatistics prevStatistics = this.lastStatisticsHolder.getLastStatistics();
        return new DefaultOperatingSystemsStatistics(stats.toArray(new OperatingSystemStatistics[stats.size()]), prevStatistics, new DefaultOperatingSystemsDetails(details.toArray(new OperatingSystemDetails[details.size()])), this.scheduledStatisticsHolder.getStatisticsHistorySize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.rescheduleStatisticsMonitor();
            }
            for (OperatingSystem operatingSystem : this.operatingSystemsByUID.values()) {
                operatingSystem.setStatisticsInterval(interval, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
            for (OperatingSystem operatingSystem : this.operatingSystemsByUID.values()) {
                operatingSystem.setStatisticsHistorySize(historySize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.rescheduleStatisticsMonitor();
            for (OperatingSystem operatingSystem : this.operatingSystemsByUID.values()) {
                operatingSystem.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.stopScheduledStatisticsMonitor();
            for (OperatingSystem operatingSystem : this.operatingSystemsByUID.values()) {
                operatingSystem.stopStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScheduledStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    OperatingSystemsStatistics stats = DefaultOperatingSystems.this.getStatistics();
                    OperatingSystemsStatisticsChangedEvent event = new OperatingSystemsStatisticsChangedEvent(DefaultOperatingSystems.this, stats);
                    DefaultOperatingSystems.this.statisticsChangedEventManager.operatingSystemsStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public OperatingSystemsStatisticsChangedEventManager getStatisticsChanged() {
        return this.statisticsChangedEventManager;
    }

    @Override
    public OperatingSystemStatisticsChangedEventManager getOperatingSystemStatisticsChanged() {
        return this.operatingSystemStatisticsChangedEventManager;
    }

    @Override
    public OperatingSystem getByUID(String uid) {
        return this.operatingSystemsByUID.get(uid);
    }

    @Override
    public Map<String, OperatingSystem> getUids() {
        return Collections.unmodifiableMap(this.operatingSystemsByUID);
    }

    @Override
    public void addOperatingSystem(final OperatingSystem operatingSystem) {
        this.assertStateChangesPermitted();
        OperatingSystem existing = this.operatingSystemsByUID.put(operatingSystem.getUid(), operatingSystem);
        if (existing == null && this.isMonitoring()) {
            this.admin.raiseEvent(this, new Runnable(){

                @Override
                public void run() {
                    operatingSystem.setStatisticsHistorySize(DefaultOperatingSystems.this.scheduledStatisticsHolder.getStatisticsHistorySize());
                    operatingSystem.setStatisticsInterval(DefaultOperatingSystems.this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS);
                    operatingSystem.startStatisticsMonitor();
                }
            });
        }
    }

    @Override
    public void removeOperatingSystem(String uid) {
        this.assertStateChangesPermitted();
        OperatingSystem existing = this.operatingSystemsByUID.remove(uid);
        if (existing != null) {
            existing.stopStatisticsMonitor();
        }
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

