/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os;

import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.os.OperatingSystemsDetails;
import org.openspaces.admin.support.StatisticsUtils;

public class DefaultOperatingSystemsDetails
implements OperatingSystemsDetails {
    private final OperatingSystemDetails[] details;

    public DefaultOperatingSystemsDetails(OperatingSystemDetails[] details) {
        this.details = details;
    }

    @Override
    public int getAvailableProcessors() {
        int total = 0;
        for (OperatingSystemDetails detail : this.details) {
            total += detail.getAvailableProcessors();
        }
        return total;
    }

    @Override
    public long getTotalSwapSpaceSizeInBytes() {
        long total = 0L;
        for (OperatingSystemDetails detail : this.details) {
            if (detail.getTotalSwapSpaceSizeInBytes() == -1L) continue;
            total += detail.getTotalSwapSpaceSizeInBytes();
        }
        return total;
    }

    @Override
    public double getTotalSwapSpaceSizeInMB() {
        return StatisticsUtils.convertToMB(this.getTotalSwapSpaceSizeInBytes());
    }

    @Override
    public double getTotalSwapSpaceSizeInGB() {
        return StatisticsUtils.convertToGB(this.getTotalSwapSpaceSizeInBytes());
    }

    @Override
    public long getTotalPhysicalMemorySizeInBytes() {
        long total = 0L;
        for (OperatingSystemDetails detail : this.details) {
            if (detail.getTotalPhysicalMemorySizeInBytes() == -1L) continue;
            total += detail.getTotalPhysicalMemorySizeInBytes();
        }
        return total;
    }

    @Override
    public double getTotalPhysicalMemorySizeInMB() {
        return StatisticsUtils.convertToMB(this.getTotalPhysicalMemorySizeInBytes());
    }

    @Override
    public double getTotalPhysicalMemorySizeInGB() {
        return StatisticsUtils.convertToGB(this.getTotalPhysicalMemorySizeInBytes());
    }
}

