/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os;

import java.util.ArrayList;
import java.util.List;
import org.openspaces.admin.os.OperatingSystemDetails;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.os.OperatingSystemsDetails;
import org.openspaces.admin.os.OperatingSystemsStatistics;
import org.openspaces.admin.support.StatisticsUtils;

public class DefaultOperatingSystemsStatistics
implements OperatingSystemsStatistics {
    private final long timestamp = System.currentTimeMillis();
    private final OperatingSystemStatistics[] stats;
    private volatile OperatingSystemsStatistics previousStats;
    private final OperatingSystemsDetails details;

    public DefaultOperatingSystemsStatistics(OperatingSystemStatistics[] stats, OperatingSystemsStatistics previousStats, OperatingSystemsDetails details, int historySize) {
        this.stats = stats;
        this.previousStats = previousStats;
        this.details = details;
        OperatingSystemsStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultOperatingSystemsStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.stats == null || this.stats.length == 0 || this.stats[0].isNA();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getSize() {
        return this.stats.length;
    }

    @Override
    public OperatingSystemsStatistics getPrevious() {
        return this.previousStats;
    }

    @Override
    public List<OperatingSystemsStatistics> getTimeline() {
        ArrayList<OperatingSystemsStatistics> timeline = new ArrayList<OperatingSystemsStatistics>();
        timeline.add(this);
        for (OperatingSystemsStatistics current = this.getPrevious(); current != null && !current.isNA(); current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }

    public void setPreviousStats(OperatingSystemsStatistics previousStats) {
        this.previousStats = previousStats;
    }

    @Override
    public OperatingSystemsDetails getDetails() {
        return this.details;
    }

    @Override
    public long getFreeSwapSpaceSizeInBytes() {
        long total = 0L;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getFreeSwapSpaceSizeInBytes() == -1L) continue;
            total += stat.getFreeSwapSpaceSizeInBytes();
        }
        return total;
    }

    @Override
    public double getFreeSwapSpaceSizeInMB() {
        return StatisticsUtils.convertToMB(this.getFreeSwapSpaceSizeInBytes());
    }

    @Override
    public double getFreeSwapSpaceSizeInGB() {
        return StatisticsUtils.convertToGB(this.getFreeSwapSpaceSizeInBytes());
    }

    @Override
    public long getFreePhysicalMemorySizeInBytes() {
        long total = 0L;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getFreePhysicalMemorySizeInBytes() == -1L) continue;
            total += stat.getFreePhysicalMemorySizeInBytes();
        }
        return total;
    }

    @Override
    public double getFreePhysicalMemorySizeInMB() {
        return StatisticsUtils.convertToMB(this.getFreePhysicalMemorySizeInBytes());
    }

    @Override
    public double getFreePhysicalMemorySizeInGB() {
        return StatisticsUtils.convertToGB(this.getFreePhysicalMemorySizeInBytes());
    }

    @Override
    public long getActualFreePhysicalMemorySizeInBytes() {
        long total = 0L;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getActualFreePhysicalMemorySizeInBytes() == -1L) continue;
            total += stat.getActualFreePhysicalMemorySizeInBytes();
        }
        return total;
    }

    @Override
    public double getActualFreePhysicalMemorySizeInMB() {
        return StatisticsUtils.convertToMB(this.getActualFreePhysicalMemorySizeInBytes());
    }

    @Override
    public double getActualFreePhysicalMemorySizeInGB() {
        return StatisticsUtils.convertToGB(this.getActualFreePhysicalMemorySizeInBytes());
    }

    @Override
    public double getCpuPerc() {
        int count = 0;
        double total = 0.0;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getCpuPerc() == -1.0) continue;
            ++count;
            total += stat.getCpuPerc();
        }
        if (count == 0) {
            return -1.0;
        }
        return total / (double)count;
    }

    @Override
    public String getCpuPercFormatted() {
        return StatisticsUtils.formatPerc(this.getCpuPerc());
    }

    @Override
    public double getMinCpuPerc() {
        double min = this.stats.length > 0 ? this.stats[0].getCpuPerc() : 0.0;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getCpuPerc() == -1.0) continue;
            min = Math.min(min, stat.getCpuPerc());
        }
        return min;
    }

    @Override
    public String getMinCpuPercFormatted() {
        return StatisticsUtils.formatPerc(this.getMinCpuPerc());
    }

    @Override
    public double getMaxCpuPerc() {
        double max = this.stats.length > 0 ? this.stats[0].getCpuPerc() : 0.0;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getCpuPerc() == -1.0) continue;
            max = Math.max(max, stat.getCpuPerc());
        }
        return max;
    }

    @Override
    public String getMaxCpuPercFormatted() {
        return StatisticsUtils.formatPerc(this.getMaxCpuPerc());
    }

    @Override
    public double getMemoryUsedPerc() {
        int count = 0;
        double total = 0.0;
        for (OperatingSystemStatistics stat : this.stats) {
            double usedMemoryPerc = this.calculateOSUsedMemoryPerc(stat);
            if (!(usedMemoryPerc >= 0.0)) continue;
            ++count;
            total += usedMemoryPerc;
        }
        if (count == 0) {
            return -1.0;
        }
        return total / (double)count;
    }

    @Override
    public double getMinMemoryUsedPerc() {
        double min = this.stats.length == 0 ? 0.0 : 1.0;
        for (OperatingSystemStatistics stat : this.stats) {
            double usedMemoryPerc = this.calculateOSUsedMemoryPerc(stat);
            if (!(usedMemoryPerc >= 0.0)) continue;
            min = Math.min(min, usedMemoryPerc);
        }
        return min;
    }

    @Override
    public double getMaxMemoryUsedPerc() {
        double max = 0.0;
        for (OperatingSystemStatistics stat : this.stats) {
            double usedMemoryPerc = this.calculateOSUsedMemoryPerc(stat);
            if (!(usedMemoryPerc >= 0.0)) continue;
            max = Math.max(max, usedMemoryPerc);
        }
        return max;
    }

    @Override
    public String getMemoryUsedPercFormatted() {
        return StatisticsUtils.formatPerc(this.getMemoryUsedPerc());
    }

    @Override
    public String getMinMemoryUsedPercFormatted() {
        return StatisticsUtils.formatPerc(this.getMinMemoryUsedPerc());
    }

    @Override
    public String getMaxMemoryUsedPercFormatted() {
        return StatisticsUtils.formatPerc(this.getMaxMemoryUsedPerc());
    }

    @Override
    public long getActualMemoryUsed() {
        long total = 0L;
        for (OperatingSystemStatistics stat : this.stats) {
            if (stat.getActualMemoryUsed() == -1L) continue;
            total += stat.getActualMemoryUsed();
        }
        return total;
    }

    private double calculateOSUsedMemoryPerc(OperatingSystemStatistics stat) {
        OperatingSystemDetails osDetails = stat.getDetails();
        if (osDetails != null && !osDetails.isNA()) {
            if (stat.getPhysicalMemoryUsedPerc() > 0.0) {
                return stat.getPhysicalMemoryUsedPerc() / 100.0;
            }
            long totalPhysicalMemorySize = osDetails.getTotalPhysicalMemorySizeInBytes();
            double usedMemory = totalPhysicalMemorySize - stat.getFreePhysicalMemorySizeInBytes();
            return usedMemory / (double)totalPhysicalMemorySize;
        }
        return -1.0;
    }
}

