/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.os.events.ClosureOperatingSystemStatisticsChangedEventListener;
import org.openspaces.admin.internal.os.events.InternalOperatingSystemStatisticsChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.os.OperatingSystem;
import org.openspaces.admin.os.OperatingSystemStatistics;
import org.openspaces.admin.os.OperatingSystems;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEvent;
import org.openspaces.admin.os.events.OperatingSystemStatisticsChangedEventListener;

public class DefaultOperatingSystemStatisticsChangedEventManager
implements InternalOperatingSystemStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final OperatingSystem operatingSystem;
    private final OperatingSystems operatingSystems;
    private final List<OperatingSystemStatisticsChangedEventListener> listeners = new CopyOnWriteArrayList<OperatingSystemStatisticsChangedEventListener>();

    public DefaultOperatingSystemStatisticsChangedEventManager(InternalAdmin admin, OperatingSystems operatingSystems) {
        this.admin = admin;
        this.operatingSystems = operatingSystems;
        this.operatingSystem = null;
    }

    public DefaultOperatingSystemStatisticsChangedEventManager(InternalAdmin admin, OperatingSystem operatingSystem) {
        this.admin = admin;
        this.operatingSystem = operatingSystem;
        this.operatingSystems = null;
    }

    @Override
    public void operatingSystemStatisticsChanged(final OperatingSystemStatisticsChangedEvent event) {
        for (final OperatingSystemStatisticsChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.operatingSystemStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(OperatingSystemStatisticsChangedEventListener eventListener) {
        this.add(eventListener, false);
    }

    @Override
    public void add(final OperatingSystemStatisticsChangedEventListener eventListener, boolean withHistory) {
        if (withHistory) {
            ArrayList<OperatingSystem> oss = new ArrayList<OperatingSystem>();
            if (this.operatingSystems != null) {
                oss.addAll(Arrays.asList(this.operatingSystems.getOperatingSystems()));
            } else if (this.operatingSystem != null) {
                oss.add(this.operatingSystem);
            }
            for (final OperatingSystem os : oss) {
                OperatingSystemStatistics stats = os.getStatistics();
                if (stats.isNA()) continue;
                List<OperatingSystemStatistics> timeline = stats.getTimeline();
                Collections.reverse(timeline);
                for (final OperatingSystemStatistics osStats : timeline) {
                    this.admin.raiseEvent(eventListener, new Runnable(){

                        @Override
                        public void run() {
                            eventListener.operatingSystemStatisticsChanged(new OperatingSystemStatisticsChangedEvent(os, osStats));
                        }
                    });
                }
            }
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(OperatingSystemStatisticsChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureOperatingSystemStatisticsChangedEventListener(eventListener));
        } else {
            this.add((OperatingSystemStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureOperatingSystemStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((OperatingSystemStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

