/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.os.events;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.os.events.ClosureOperatingSystemsStatisticsChangedEventListener;
import org.openspaces.admin.internal.os.events.InternalOperatingSystemsStatisticsChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.os.OperatingSystems;
import org.openspaces.admin.os.OperatingSystemsStatistics;
import org.openspaces.admin.os.events.OperatingSystemsStatisticsChangedEvent;
import org.openspaces.admin.os.events.OperatingSystemsStatisticsChangedEventListener;

public class DefaultOperatingSystemsStatisticsChangedEventManager
implements InternalOperatingSystemsStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final OperatingSystems operatingSystems;
    private final List<OperatingSystemsStatisticsChangedEventListener> listeners = new CopyOnWriteArrayList<OperatingSystemsStatisticsChangedEventListener>();

    public DefaultOperatingSystemsStatisticsChangedEventManager(InternalAdmin admin, OperatingSystems operatingSystems) {
        this.admin = admin;
        this.operatingSystems = operatingSystems;
    }

    @Override
    public void operatingSystemsStatisticsChanged(final OperatingSystemsStatisticsChangedEvent event) {
        for (final OperatingSystemsStatisticsChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.operatingSystemsStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(OperatingSystemsStatisticsChangedEventListener eventListener) {
        this.add(eventListener, false);
    }

    @Override
    public void add(final OperatingSystemsStatisticsChangedEventListener eventListener, boolean withHistory) {
        OperatingSystemsStatistics stats;
        if (withHistory && !(stats = this.operatingSystems.getStatistics()).isNA()) {
            List<OperatingSystemsStatistics> timeline = stats.getTimeline();
            Collections.reverse(timeline);
            for (final OperatingSystemsStatistics osStats : timeline) {
                this.admin.raiseEvent(eventListener, new Runnable(){

                    @Override
                    public void run() {
                        eventListener.operatingSystemsStatisticsChanged(new OperatingSystemsStatisticsChangedEvent(DefaultOperatingSystemsStatisticsChangedEventManager.this.operatingSystems, osStats));
                    }
                });
            }
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(OperatingSystemsStatisticsChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureOperatingSystemsStatisticsChangedEventListener(eventListener));
        } else {
            this.add((OperatingSystemsStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureOperatingSystemsStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((OperatingSystemsStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

