/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.admin.DefaultAdmin;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;

public class DefaultAdminProcessingUnitInstances {
    private static final Log logger = LogFactory.getLog(DefaultAdmin.class);
    private final Map<String, ProcessingUnitInstance> removedProcessingUnitInstances = new ConcurrentHashMap<String, ProcessingUnitInstance>();
    private final Map<String, ProcessingUnitInstance> orphanedProcessingUnitInstances = new ConcurrentHashMap<String, ProcessingUnitInstance>();

    public void addRemovedProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.removeProcessingUnitInstanceByName(processingUnitInstance);
        this.removedProcessingUnitInstances.put(processingUnitInstance.getUid(), processingUnitInstance);
    }

    public ProcessingUnitInstance getRemovedProcessingUnitInstance(String uid) {
        return this.removedProcessingUnitInstances.get(uid);
    }

    public void delRemovedProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.removedProcessingUnitInstances.remove(processingUnitInstance.getUid());
        this.removeProcessingUnitInstanceByName(processingUnitInstance);
    }

    public void processRemovedOnProcessingUnitRemoval(ProcessingUnit processingUnit) {
        Iterator<ProcessingUnitInstance> iterator = this.removedProcessingUnitInstances.values().iterator();
        while (iterator.hasNext()) {
            ProcessingUnitInstance next = iterator.next();
            if (!next.getProcessingUnit().equals(processingUnit)) continue;
            iterator.remove();
        }
    }

    private void removeProcessingUnitInstanceByName(ProcessingUnitInstance processingUnitInstance) {
        Iterator<ProcessingUnitInstance> iterator = this.removedProcessingUnitInstances.values().iterator();
        while (iterator.hasNext()) {
            ProcessingUnitInstance next = iterator.next();
            if (!next.getProcessingUnitInstanceName().equals(processingUnitInstance.getProcessingUnitInstanceName())) continue;
            iterator.remove();
        }
    }

    public void addOrphaned(ProcessingUnitInstance orphanProcessingUnitInstance) {
        this.orphanedProcessingUnitInstances.put(orphanProcessingUnitInstance.getUid(), orphanProcessingUnitInstance);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(orphanProcessingUnitInstance.getProcessingUnitInstanceName() + " is orphaned until it's hosting container is discovered."));
        }
    }

    public ProcessingUnitInstance removeOrphaned(String uid) {
        ProcessingUnitInstance orphanProcessingUnitInstance = this.orphanedProcessingUnitInstances.remove(uid);
        if (orphanProcessingUnitInstance != null && logger.isDebugEnabled()) {
            logger.debug((Object)("Orphan " + orphanProcessingUnitInstance.getProcessingUnitInstanceName() + " with id [" + orphanProcessingUnitInstance.getUid() + "] has been removed."));
        }
        return orphanProcessingUnitInstance;
    }

    public ProcessingUnitInstance[] getOrphanProcessingUnitInstances() {
        return this.orphanedProcessingUnitInstances.values().toArray(new ProcessingUnitInstance[0]);
    }
}

