/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import com.gigaspaces.admin.quiesce.InstancesQuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.grid.gsm.PUDetails;
import com.gigaspaces.grid.zone.ZoneHelper;
import com.gigaspaces.internal.quiesce.InternalQuiesceDetails;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.time.SystemTime;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jini.rio.core.RequiredDependencies;
import org.jini.rio.monitor.ProvisionLifeCycleEvent;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.application.Application;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.application.InternalApplication;
import org.openspaces.admin.internal.esm.InternalElasticServiceManager;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitPartition;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstance;
import org.openspaces.admin.internal.pu.InternalProcessingUnitPartition;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.internal.pu.InternalProvisionStatusHolder;
import org.openspaces.admin.internal.pu.ProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.dependency.DefaultProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependency;
import org.openspaces.admin.internal.pu.events.DefaultBackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitSpaceCorrelatedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalBackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitSpaceCorrelatedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitStatusChangedEventManager;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatistics;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.ProcessingUnitInstanceStatistics;
import org.openspaces.admin.pu.ProcessingUnitPartition;
import org.openspaces.admin.pu.ProcessingUnitType;
import org.openspaces.admin.pu.ProcessingUnits;
import org.openspaces.admin.pu.ProvisionStatus;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.events.BackupGridServiceManagerChangedEvent;
import org.openspaces.admin.pu.events.BackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.pu.events.ManagingGridServiceManagerChangedEvent;
import org.openspaces.admin.pu.events.ManagingGridServiceManagerChangedEventListener;
import org.openspaces.admin.pu.events.ManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionFailure;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitSpaceCorrelatedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitSpaceCorrelatedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitSpaceCorrelatedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEventManager;
import org.openspaces.admin.pu.statistics.InstancesStatisticsConfig;
import org.openspaces.admin.pu.statistics.LastSampleTimeWindowStatisticsConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsIdConfigurer;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfig;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfigurer;
import org.openspaces.admin.quiesce.QuiesceDetails;
import org.openspaces.admin.quiesce.QuiesceRequest;
import org.openspaces.admin.quiesce.QuiesceResult;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.zone.config.AnyZonesConfig;
import org.openspaces.admin.zone.config.AtLeastOneZoneConfigurer;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.RequiredZonesConfig;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.pu.sla.SLA;
import org.openspaces.pu.sla.requirement.Requirement;
import org.openspaces.pu.sla.requirement.ZoneRequirement;

public class DefaultProcessingUnit
implements InternalProcessingUnit {
    private static final Log logger = LogFactory.getLog(DefaultProcessingUnit.class);
    private final InternalProcessingUnits processingUnits;
    private final InternalAdmin admin;
    private final String name;
    private final String simpleName;
    private volatile int numberOfInstances;
    private volatile int numberOfBackups;
    private volatile boolean backupGsmIsInSync;
    private final BeanLevelProperties beanLevelProperties;
    private final SLA sla;
    private final Map<String, String> elasticProperties;
    private volatile DeploymentStatus deploymentStatus = DeploymentStatus.NA;
    private volatile GridServiceManager managingGridServiceManager;
    private final Map<String, GridServiceManager> backupGridServiceManagers = new ConcurrentHashMap<String, GridServiceManager>();
    private final Map<String, ProcessingUnitInstance> processingUnitInstances = new ConcurrentHashMap<String, ProcessingUnitInstance>();
    private final Map<Integer, ProcessingUnitPartition> processingUnitPartitions = new ConcurrentHashMap<Integer, ProcessingUnitPartition>();
    private final ConcurrentMap<String, Space> spaces = new ConcurrentHashMap<String, Space>();
    private final InternalManagingGridServiceManagerChangedEventManager managingGridServiceManagerChangedEventManager;
    private final InternalBackupGridServiceManagerChangedEventManager backupGridServiceManagerChangedEventManager;
    private final InternalProcessingUnitStatusChangedEventManager processingUnitStatusChangedEventManager;
    private final InternalProcessingUnitInstanceAddedEventManager processingUnitInstanceAddedEventManager;
    private final InternalProcessingUnitInstanceRemovedEventManager processingUnitInstanceRemovedEventManager;
    private final InternalProcessingUnitSpaceCorrelatedEventManager spaceCorrelatedEventManager;
    private final InternalProcessingUnitInstanceStatisticsChangedEventManager processingUnitInstanceStatisticsChangedEventManager;
    private final Map<String, InternalProvisionStatusHolder> provisionStatus = new HashMap<String, InternalProvisionStatusHolder>();
    private final InternalProcessingUnitInstanceProvisionStatusChangedEventManager processingUnitInstanceProvisionStatusChangedEventManager;
    private final InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager processingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
    private final LastStatisticsHolder<ProcessingUnitStatistics> lastStatisticsHolder = new LastStatisticsHolder();
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private final ProcessingUnitType processingUnitType;
    private final String archiveName;
    private static final String APPLICATION_NAME_CONTEXT_PROPERTY = "com.gs.application";
    private static final String APPLICATION_DEPENDENCIES_CONTEXT_PROPERTY = "com.gs.application.dependsOn";
    private final String applicationName;
    private volatile InternalApplication application;
    private final InternalProcessingUnitDependencies<ProcessingUnitDependency, InternalProcessingUnitDependency> dependencies;
    private final ConcurrentHashSet<ProcessingUnitStatisticsId> statisticsIds;

    public DefaultProcessingUnit(InternalAdmin admin, InternalProcessingUnits processingUnits, PUDetails details, BeanLevelProperties beanLevelProperties) {
        String applNamePrefix;
        RequiredDependencies instanceStartDependencies;
        this.admin = admin;
        this.processingUnits = processingUnits;
        this.name = details.getName();
        this.numberOfInstances = details.getNumberOfInstances();
        this.numberOfBackups = details.getNumberOfBackups();
        ProcessingUnitType type = ProcessingUnitType.UNKNOWN;
        try {
            type = ProcessingUnitType.valueOf(details.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.processingUnitType = type;
        this.elasticProperties = details.getElasticProperties();
        this.dependencies = new DefaultProcessingUnitDependencies();
        RequiredDependencies instanceDeploymentDependencies = details.getInstanceDeploymentDependencies();
        if (instanceDeploymentDependencies != null) {
            this.dependencies.addDetailedDependenciesByCommandLineOption("deployment-dependencies", instanceDeploymentDependencies);
        }
        if ((instanceStartDependencies = details.getInstanceStartDependencies()) != null) {
            this.dependencies.addDetailedDependenciesByCommandLineOption("start-dependencies", instanceStartDependencies);
        }
        this.beanLevelProperties = beanLevelProperties;
        this.applicationName = details.getApplicationName() != null ? details.getApplicationName() : this.getBeanLevelProperties().getContextProperties().getProperty(APPLICATION_NAME_CONTEXT_PROPERTY);
        this.simpleName = this.applicationName != null && this.applicationName.trim().length() > 0 ? (this.name.startsWith(applNamePrefix = this.applicationName + ".") ? this.name.substring(applNamePrefix.length()) : this.name) : this.name;
        try {
            this.sla = (SLA)details.getSla().get();
        }
        catch (Exception e) {
            throw new AdminException("Failed to get sla", e);
        }
        if (this.numberOfBackups == 0) {
            this.processingUnitPartitions.put(0, new DefaultProcessingUnitPartition(this, 0));
        } else {
            for (int i = 0; i < this.numberOfInstances; ++i) {
                this.processingUnitPartitions.put(i, new DefaultProcessingUnitPartition(this, i));
            }
        }
        this.managingGridServiceManagerChangedEventManager = new DefaultManagingGridServiceManagerChangedEventManager(admin, this);
        this.backupGridServiceManagerChangedEventManager = new DefaultBackupGridServiceManagerChangedEventManager(admin, this);
        this.processingUnitStatusChangedEventManager = new DefaultProcessingUnitStatusChangedEventManager(admin, this);
        this.processingUnitInstanceAddedEventManager = new DefaultProcessingUnitInstanceAddedEventManager(this, admin);
        this.processingUnitInstanceRemovedEventManager = new DefaultProcessingUnitInstanceRemovedEventManager(admin);
        this.spaceCorrelatedEventManager = new DefaultProcessingUnitSpaceCorrelatedEventManager(this);
        this.processingUnitInstanceStatisticsChangedEventManager = new DefaultProcessingUnitInstanceStatisticsChangedEventManager(admin);
        this.processingUnitInstanceProvisionStatusChangedEventManager = new DefaultProcessingUnitInstanceProvisionStatusChangedEventManager(admin, this);
        this.processingUnitInstanceMemberAliveIndicatorStatusChangedEventManager = new DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager(admin, this);
        this.statisticsIds = new ConcurrentHashSet();
        this.archiveName = details.getArchiveName();
    }

    @Override
    public ProcessingUnits getProcessingUnits() {
        return this.processingUnits;
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BeanLevelProperties getBeanLevelProperties() {
        return this.beanLevelProperties;
    }

    @Override
    public ProcessingUnitType getType() {
        return this.processingUnitType;
    }

    @Override
    public ManagingGridServiceManagerChangedEventManager getManagingGridServiceManagerChanged() {
        return this.managingGridServiceManagerChangedEventManager;
    }

    @Override
    public BackupGridServiceManagerChangedEventManager getBackupGridServiceManagerChanged() {
        return this.backupGridServiceManagerChangedEventManager;
    }

    @Override
    public Space getSpace() {
        Iterator it = this.spaces.values().iterator();
        if (it.hasNext()) {
            return (Space)it.next();
        }
        return null;
    }

    @Override
    public Space[] getSpaces() {
        return this.spaces.values().toArray(new Space[0]);
    }

    @Override
    public void addEmbeddedSpace(Space space) {
        this.assertStateChangesPermitted();
        Space existingSpace = this.spaces.putIfAbsent(space.getName(), space);
        if (existingSpace == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Processing Unit " + this.getName() + " discovered embedded space " + space.getName()));
            }
            this.spaceCorrelatedEventManager.processingUnitSpaceCorrelated(new ProcessingUnitSpaceCorrelatedEvent(space, this));
        }
    }

    @Override
    public boolean removeEmbeddedSpace(Space space) {
        this.assertStateChangesPermitted();
        return this.spaces.remove(space.getName()) != null;
    }

    @Override
    public Map<String, String> getElasticProperties() {
        return this.elasticProperties;
    }

    @Override
    public ProcessingUnitStatusChangedEventManager getProcessingUnitStatusChanged() {
        return this.processingUnitStatusChangedEventManager;
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstanceAddedEventManager;
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstanceRemovedEventManager;
    }

    @Override
    public ProcessingUnitSpaceCorrelatedEventManager getSpaceCorrelated() {
        return this.spaceCorrelatedEventManager;
    }

    @Override
    public void addLifecycleListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.getProcessingUnitInstanceAdded().add(eventListener);
        this.getProcessingUnitInstanceRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.getProcessingUnitInstanceAdded().remove(eventListener);
        this.getProcessingUnitInstanceRemoved().remove(eventListener);
    }

    @Override
    @Deprecated
    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    @Override
    public int getPlannedNumberOfPartitions() {
        return this.getNumberOfInstances();
    }

    @Override
    public int getPlannedNumberOfInstances() {
        Integer planned;
        if (this.isElastic() && this.getType() != ProcessingUnitType.STATEFUL && (planned = ((InternalProcessingUnits)this.getProcessingUnits()).getPlannedNumberOfInstancesOfElasticPU(this)) != null) {
            return planned;
        }
        return this.getTotalNumberOfInstances();
    }

    private boolean isElastic() {
        return !this.elasticProperties.isEmpty();
    }

    @Override
    public void setNumberOfInstances(int numberOfInstances) {
        this.assertStateChangesPermitted();
        this.numberOfInstances = numberOfInstances;
    }

    @Override
    public int getNumberOfBackups() {
        return this.numberOfBackups;
    }

    @Override
    public void setNumberOfBackups(int numberOfBackups) {
        this.assertStateChangesPermitted();
        this.numberOfBackups = numberOfBackups;
    }

    @Override
    @Deprecated
    public int getTotalNumberOfInstances() {
        return this.getNumberOfInstances() * (this.getNumberOfBackups() + 1);
    }

    @Override
    public int getMaxInstancesPerVM() {
        return this.sla.getMaxInstancesPerVM();
    }

    @Override
    public boolean isRequiresIsolation() {
        return this.sla.isRequiresIsolation();
    }

    @Override
    public int getMaxInstancesPerMachine() {
        return this.sla.getMaxInstancesPerMachine();
    }

    @Override
    public String getClusterSchema() {
        return this.sla.getClusterSchema();
    }

    @Override
    public Map<String, Integer> getMaxInstancesPerZone() {
        return Collections.unmodifiableMap(this.sla.getMaxInstancesPerZone());
    }

    @Override
    public String[] getRequiredZones() {
        ArrayList<String> zones = new ArrayList<String>();
        for (Requirement req : this.sla.getRequirements()) {
            if (!(req instanceof ZoneRequirement)) continue;
            zones.add(((ZoneRequirement)req).getZone());
        }
        return zones.toArray(new String[zones.size()]);
    }

    @Override
    public Set<String> getPrimaryZones() {
        return ZoneHelper.parseZones((String)this.sla.getPrimaryZone());
    }

    @Override
    public DeploymentStatus getStatus() {
        return this.deploymentStatus;
    }

    @Override
    public boolean waitFor(int numberOfProcessingUnitInstances) {
        return this.waitFor(numberOfProcessingUnitInstances, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfProcessingUnitInstances, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(numberOfProcessingUnitInstances);
        ProcessingUnitInstanceAddedEventListener added = new ProcessingUnitInstanceAddedEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                latch.countDown();
            }
        };
        this.getProcessingUnitInstanceAdded().add(added);
        try {
            boolean bl = latch.await(timeout, timeUnit);
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getProcessingUnitInstanceAdded().remove(added);
        }
    }

    @Override
    public Space waitForSpace() {
        return this.waitForSpace(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Space waitForSpace(long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ProcessingUnitSpaceCorrelatedEventListener correlated = new ProcessingUnitSpaceCorrelatedEventListener(){

            @Override
            public void processingUnitSpaceCorrelated(ProcessingUnitSpaceCorrelatedEvent event) {
                ref.set(event.getSpace());
                latch.countDown();
            }
        };
        this.getSpaceCorrelated().add(correlated);
        try {
            latch.await(timeout, timeUnit);
            Space space = (Space)ref.get();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("pu " + this.getName() + " #waitForSpace() " + (space == null ? "timed out" : " returns space " + space.getName())));
            }
            Space space2 = space;
            return space2;
        }
        catch (InterruptedException e) {
            Space space = null;
            return space;
        }
        finally {
            this.getSpaceCorrelated().remove(correlated);
        }
    }

    @Override
    public GridServiceManager waitForManaged() {
        return this.waitForManaged(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridServiceManager waitForManaged(long timeout, TimeUnit timeUnit) {
        if (this.isManaged()) {
            return this.managingGridServiceManager;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ManagingGridServiceManagerChangedEventListener listener = new ManagingGridServiceManagerChangedEventListener(){

            @Override
            public void processingUnitManagingGridServiceManagerChanged(ManagingGridServiceManagerChangedEvent event) {
                if (event.getNewGridServiceManager() != null) {
                    ref.set(event.getNewGridServiceManager());
                    latch.countDown();
                }
            }
        };
        this.getManagingGridServiceManagerChanged().add(listener);
        if (this.isManaged()) {
            this.getManagingGridServiceManagerChanged().remove(listener);
            return this.managingGridServiceManager;
        }
        try {
            latch.await(timeout, timeUnit);
            GridServiceManager gridServiceManager = (GridServiceManager)ref.get();
            return gridServiceManager;
        }
        catch (InterruptedException e) {
            GridServiceManager gridServiceManager = null;
            return gridServiceManager;
        }
        finally {
            this.getManagingGridServiceManagerChanged().remove(listener);
        }
    }

    @Override
    public boolean canIncrementInstance() {
        return this.getSpaces().length == 0;
    }

    @Override
    public boolean canDecrementInstance() {
        return this.getSpaces().length == 0;
    }

    @Override
    public void incrementInstance() {
        if (!this.isManaged()) {
            throw new AdminException("Processing Unit " + this.getName() + " does not have an associated managing GSM");
        }
        ((InternalGridServiceManager)this.managingGridServiceManager).incrementInstance(this);
    }

    @Override
    public void decrementInstance() {
        if (!this.isManaged()) {
            throw new AdminException("Processing Unit " + this.getName() + " does not have an associated managing GSM");
        }
        if (this.decrementPlannedInstances()) {
            return;
        }
        Iterator<ProcessingUnitInstance> it = this.iterator();
        if (it.hasNext()) {
            ((InternalGridServiceManager)this.managingGridServiceManager).decrementInstance(it.next());
        }
    }

    @Override
    public GridServiceManager getManagingGridServiceManager() {
        return this.managingGridServiceManager;
    }

    @Override
    public GridServiceManager[] getBackupGridServiceManagers() {
        return this.backupGridServiceManagers.values().toArray(new GridServiceManager[0]);
    }

    @Override
    public boolean isManaged() {
        return this.managingGridServiceManager != null;
    }

    @Override
    public GridServiceManager getBackupGridServiceManager(String gridServiceManagerUID) {
        return this.backupGridServiceManagers.get(gridServiceManagerUID);
    }

    @Override
    public boolean undeployAndWait(long timeout, TimeUnit timeUnit) {
        if (this.isManaged()) {
            return ((InternalGridServiceManager)this.managingGridServiceManager).undeployProcessingUnitsAndWait(new ProcessingUnit[]{this}, timeout, timeUnit);
        }
        return ((InternalGridServiceManagers)this.admin.getGridServiceManagers()).undeployProcessingUnitsAndWait(new ProcessingUnit[]{this}, timeout, timeUnit);
    }

    @Override
    public void undeployAndWait() {
        this.undeployAndWait(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undeploy() {
        if (!this.isManaged()) {
            throw new AdminException("No managing GSM to undeploy from");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        ProcessingUnitRemovedEventListener listener = new ProcessingUnitRemovedEventListener(){

            @Override
            public void processingUnitRemoved(ProcessingUnit processingUnit) {
                if (DefaultProcessingUnit.this.getName().equals(processingUnit.getName())) {
                    latch.countDown();
                }
            }
        };
        this.getProcessingUnits().getProcessingUnitRemoved().add(listener);
        try {
            ((InternalGridServiceManager)this.managingGridServiceManager).undeployProcessingUnit(this.getName());
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new AdminException("Failed to undeploy", e);
            }
        }
        finally {
            this.getProcessingUnits().getProcessingUnitRemoved().remove(listener);
        }
    }

    @Override
    public void setManagingGridServiceManager(GridServiceManager gridServiceManager) {
        this.assertStateChangesPermitted();
        this.managingGridServiceManager = gridServiceManager;
    }

    @Override
    public void addManagingGridServiceManager(GridServiceManager gridServiceManager) {
        this.assertStateChangesPermitted();
        GridServiceManager previousManaging = gridServiceManager == this.managingGridServiceManager ? null : this.managingGridServiceManager;
        GridServiceManager newManaging = gridServiceManager;
        this.managingGridServiceManager = gridServiceManager;
        ManagingGridServiceManagerChangedEvent event = new ManagingGridServiceManagerChangedEvent(this, newManaging, previousManaging);
        this.managingGridServiceManagerChangedEventManager.processingUnitManagingGridServiceManagerChanged(event);
        ((InternalManagingGridServiceManagerChangedEventManager)this.processingUnits.getManagingGridServiceManagerChanged()).processingUnitManagingGridServiceManagerChanged(event);
    }

    @Override
    public void addBackupGridServiceManager(GridServiceManager backupGridServiceManager) {
        this.assertStateChangesPermitted();
        GridServiceManager gridServiceManager = this.backupGridServiceManagers.put(backupGridServiceManager.getUid(), backupGridServiceManager);
        if (gridServiceManager == null) {
            BackupGridServiceManagerChangedEvent event = new BackupGridServiceManagerChangedEvent(this, BackupGridServiceManagerChangedEvent.Type.ADDED, backupGridServiceManager);
            this.backupGridServiceManagerChangedEventManager.processingUnitBackupGridServiceManagerChanged(event);
            ((InternalBackupGridServiceManagerChangedEventManager)this.processingUnits.getBackupGridServiceManagerChanged()).processingUnitBackupGridServiceManagerChanged(event);
        }
    }

    @Override
    public void removeBackupGridServiceManager(String gsmUID) {
        this.assertStateChangesPermitted();
        GridServiceManager existingGridServiceManager = this.backupGridServiceManagers.remove(gsmUID);
        if (existingGridServiceManager != null) {
            BackupGridServiceManagerChangedEvent event = new BackupGridServiceManagerChangedEvent(this, BackupGridServiceManagerChangedEvent.Type.REMOVED, existingGridServiceManager);
            this.backupGridServiceManagerChangedEventManager.processingUnitBackupGridServiceManagerChanged(event);
            ((InternalBackupGridServiceManagerChangedEventManager)this.processingUnits.getBackupGridServiceManagerChanged()).processingUnitBackupGridServiceManagerChanged(event);
        }
    }

    @Override
    public boolean setStatus(int statusCode) {
        DeploymentStatus tempStatus;
        this.assertStateChangesPermitted();
        switch (statusCode) {
            case 0: {
                tempStatus = DeploymentStatus.UNDEPLOYED;
                break;
            }
            case 1: {
                tempStatus = DeploymentStatus.SCHEDULED;
                break;
            }
            case 2: {
                tempStatus = DeploymentStatus.DEPLOYED;
                break;
            }
            case 3: {
                tempStatus = DeploymentStatus.BROKEN;
                break;
            }
            case 4: {
                tempStatus = DeploymentStatus.COMPROMISED;
                break;
            }
            case 5: {
                tempStatus = DeploymentStatus.INTACT;
                break;
            }
            default: {
                throw new IllegalStateException("No status match");
            }
        }
        if (tempStatus != this.deploymentStatus) {
            ProcessingUnitStatusChangedEvent event = new ProcessingUnitStatusChangedEvent(this, this.deploymentStatus, tempStatus);
            this.processingUnitStatusChangedEventManager.processingUnitStatusChanged(event);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ProcessingUnit " + event.getProcessingUnit().getName() + " status changed from " + (Object)((Object)event.getPreviousStatus()) + " to " + (Object)((Object)event.getNewStatus())));
            }
            ((InternalProcessingUnitStatusChangedEventManager)this.processingUnits.getProcessingUnitStatusChanged()).processingUnitStatusChanged(event);
            this.deploymentStatus = tempStatus;
            return true;
        }
        this.deploymentStatus = tempStatus;
        return false;
    }

    @Override
    public Iterator<ProcessingUnitInstance> iterator() {
        return Collections.unmodifiableCollection(this.processingUnitInstances.values()).iterator();
    }

    @Override
    public ProcessingUnitInstance[] getInstances() {
        return this.processingUnitInstances.values().toArray(new ProcessingUnitInstance[0]);
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        return this.getInstances();
    }

    @Override
    public ProcessingUnitPartition[] getPartitions() {
        return this.processingUnitPartitions.values().toArray(new ProcessingUnitPartition[0]);
    }

    @Override
    public ProcessingUnitPartition getPartition(int partitionId) {
        return this.processingUnitPartitions.get(partitionId);
    }

    @Override
    public void addProcessingUnitInstance(final ProcessingUnitInstance processingUnitInstance) {
        this.assertStateChangesPermitted();
        ProcessingUnitInstance existingProcessingUnitInstance = this.processingUnitInstances.put(processingUnitInstance.getUid(), processingUnitInstance);
        InternalProcessingUnitPartition partition = this.getPartition(processingUnitInstance);
        if (partition == null) {
            throw new IllegalStateException("getPartition(processingUnitInstance) returned null for processingUnitInstance.instanceId=" + processingUnitInstance.getInstanceId() + " numberOfBackups=" + this.numberOfBackups + " processingUnitPartitions=" + this.processingUnitPartitions);
        }
        partition.addProcessingUnitInstance(processingUnitInstance);
        ((InternalProcessingUnitInstance)processingUnitInstance).setProcessingUnitPartition(partition);
        if (existingProcessingUnitInstance == null) {
            processingUnitInstance.setStatisticsInterval(this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS);
            processingUnitInstance.setStatisticsHistorySize(this.scheduledStatisticsHolder.getStatisticsHistorySize());
            if (this.isMonitoring()) {
                this.admin.raiseEvent(this, new Runnable(){

                    @Override
                    public void run() {
                        processingUnitInstance.startStatisticsMonitor();
                    }
                });
            }
            this.processingUnitInstanceAddedEventManager.processingUnitInstanceAdded(processingUnitInstance);
            ((InternalProcessingUnitInstanceAddedEventManager)this.processingUnits.getProcessingUnitInstanceAdded()).processingUnitInstanceAdded(processingUnitInstance);
            if (this.application != null) {
                ((InternalProcessingUnitInstanceAddedEventManager)this.application.getProcessingUnits().getProcessingUnitInstanceAdded()).processingUnitInstanceAdded(processingUnitInstance);
            }
        }
    }

    @Override
    public void removeProcessingUnitInstance(String uid) {
        final ProcessingUnitInstance processingUnitInstance = this.processingUnitInstances.remove(uid);
        if (processingUnitInstance != null) {
            this.admin.scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    while (processingUnitInstance.isMonitoring()) {
                        processingUnitInstance.stopStatisticsMonitor();
                    }
                }
            });
            InternalProcessingUnitPartition partition = this.getPartition(processingUnitInstance);
            partition.removeProcessingUnitInstance(uid);
            this.processingUnitInstanceRemovedEventManager.processingUnitInstanceRemoved(processingUnitInstance);
            ((InternalProcessingUnitInstanceRemovedEventManager)this.processingUnits.getProcessingUnitInstanceRemoved()).processingUnitInstanceRemoved(processingUnitInstance);
            if (this.application != null) {
                ((InternalProcessingUnitInstanceRemovedEventManager)this.application.getProcessingUnits().getProcessingUnitInstanceRemoved()).processingUnitInstanceRemoved(processingUnitInstance);
            }
        }
    }

    private InternalProcessingUnitPartition getPartition(ProcessingUnitInstance processingUnitInstance) {
        InternalProcessingUnitPartition partition = this.numberOfBackups == 0 ? (InternalProcessingUnitPartition)this.processingUnitPartitions.get(0) : (InternalProcessingUnitPartition)this.processingUnitPartitions.get(processingUnitInstance.getInstanceId() - 1);
        return partition;
    }

    @Override
    public ProcessingUnitInstanceStatisticsChangedEventManager getProcessingUnitInstanceStatisticsChanged() {
        return this.processingUnitInstanceStatisticsChangedEventManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            for (ProcessingUnitInstance processingUnitInstance : this.processingUnitInstances.values()) {
                processingUnitInstance.setStatisticsInterval(interval, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
            for (ProcessingUnitInstance processingUnitInstance : this.processingUnitInstances.values()) {
                processingUnitInstance.setStatisticsHistorySize(historySize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.rescheduleStatisticsMonitor();
            for (ProcessingUnitInstance processingUnitInstance : this.processingUnitInstances.values()) {
                processingUnitInstance.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.stopScheduledStatisticsMonitor();
            for (ProcessingUnitInstance processingUnitInstance : this.processingUnitInstances.values()) {
                processingUnitInstance.stopStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScheduledStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    DefaultProcessingUnit.this.getStatistics();
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProcessingUnit that = (DefaultProcessingUnit)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public void scale(ScaleStrategyConfig strategyConfig) {
        InternalGridServiceManager gsm = (InternalGridServiceManager)this.getManagingGridServiceManager();
        if (gsm == null) {
            throw new AdminException("Processing Unit " + this.getName() + " does not have an associated managing GSM");
        }
        if (this.admin.getElasticServiceManagers().getSize() != 1) {
            throw new AdminException("ESM server is not running.");
        }
        gsm.setProcessingUnitScaleStrategyConfig(this, strategyConfig);
    }

    @Override
    public void scaleAndWait(ScaleStrategyConfig strategyConfig) {
        this.scaleAndWait(strategyConfig, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public boolean scaleAndWait(ScaleStrategyConfig strategyConfig, long timeout, TimeUnit timeunit) {
        InternalElasticServiceManager esm;
        ElasticServiceManager[] elasticManagers;
        long end = SystemTime.timeMillis() + timeunit.toMillis(timeout);
        this.scale(strategyConfig);
        while ((elasticManagers = ((InternalElasticServiceManagers)this.admin.getElasticServiceManagers()).getManagersNonFiltered()).length != 1 || !(esm = (InternalElasticServiceManager)elasticManagers[0]).isManagingProcessingUnitAndScaleNotInProgressNoCache(this)) {
            long sleepDuration = end - SystemTime.timeMillis();
            if (sleepDuration <= 0L) {
                return false;
            }
            try {
                Thread.sleep(Math.min(1000L, sleepDuration));
            }
            catch (InterruptedException e) {
                throw new AdminException("scaleAndWait interrupted", e);
            }
        }
        return true;
    }

    @Deprecated
    public void setElasticProperties(Map<String, String> properties) {
        if (this.getManagingGridServiceManager() == null) {
            throw new AdminException("Processing Unit " + this.getName() + " does not have an associated managing GSM");
        }
        ((InternalGridServiceManager)this.getManagingGridServiceManager()).setProcessingUnitElasticProperties(this, properties);
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public void setApplication(Application application) {
        this.assertStateChangesPermitted();
        this.application = (InternalApplication)application;
    }

    @Override
    public ScaleStrategyConfig getScaleStrategyConfig() {
        if (this.getManagingGridServiceManager() == null) {
            throw new AdminException("Processing Unit " + this.getName() + " does not have an associated managing GSM");
        }
        return ((InternalGridServiceManager)this.getManagingGridServiceManager()).getProcessingUnitScaleStrategyConfig(this);
    }

    @Override
    public boolean decrementPlannedInstances() {
        if (this.getManagingGridServiceManager() == null) {
            throw new AdminException("Processing Unit " + this.getName() + " does not have an associated managing GSM");
        }
        return ((InternalGridServiceManager)this.managingGridServiceManager).decrementPlannedInstances(this);
    }

    @Override
    public String getApplicationDependencies() {
        ArrayList<String> orderedNames = new ArrayList<String>();
        String deprecatedDependenciesValue = this.getBeanLevelProperties().getContextProperties().getProperty(APPLICATION_DEPENDENCIES_CONTEXT_PROPERTY);
        if (deprecatedDependenciesValue != null) {
            String[] deprecatedDependencies;
            String trimmedDeprecatedDependenciesValue = deprecatedDependenciesValue.replace('[', ' ').replace(']', ' ').trim();
            for (String name : deprecatedDependencies = StringUtils.delimitedListToStringArray((String)trimmedDeprecatedDependenciesValue, (String)",")) {
                if (orderedNames.contains(name)) continue;
                orderedNames.add(name);
            }
        }
        for (String name : this.dependencies.getDeploymentDependencies().getRequiredProcessingUnitsNames()) {
            if (orderedNames.contains(name)) continue;
            orderedNames.add(name);
        }
        if (orderedNames.isEmpty()) {
            return "";
        }
        return "[" + StringUtils.collectionToCommaDelimitedString(orderedNames) + "]";
    }

    @Override
    public ProcessingUnitDependencies<ProcessingUnitDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void processProvisionEvent(ProvisionLifeCycleEvent provisionLifeCycleEvent) {
        ProvisionStatus lastProvisionStatus;
        ProvisionStatus newStatus;
        switch (provisionLifeCycleEvent.getStatus()) {
            case 0: {
                newStatus = ProvisionStatus.ATTEMPT;
                break;
            }
            case 1: {
                newStatus = ProvisionStatus.SUCCESS;
                break;
            }
            case 2: {
                newStatus = ProvisionStatus.FAILURE;
                break;
            }
            case 3: {
                newStatus = ProvisionStatus.PENDING;
                break;
            }
            default: {
                throw new IllegalStateException("unknown provision life-cycle status");
            }
        }
        InternalProvisionStatusHolder provisionStatusHolder = this.provisionStatus.get(provisionLifeCycleEvent.getProcessingUnitInstanceName());
        if (provisionStatusHolder == null) {
            provisionStatusHolder = new InternalProvisionStatusHolder();
        }
        if (newStatus != (lastProvisionStatus = provisionStatusHolder.getNewProvisionStatus())) {
            String processingUnitInstanceName = provisionLifeCycleEvent.getProcessingUnitInstanceName();
            ProcessingUnitInstanceProvisionFailure failure = null;
            String exceptionMessage = provisionLifeCycleEvent.getException();
            if (exceptionMessage != null) {
                boolean uninstantiable = provisionLifeCycleEvent.isUninstantiable();
                failure = new ProcessingUnitInstanceProvisionFailure(this, provisionLifeCycleEvent.getGscServiceId(), exceptionMessage, uninstantiable);
                try {
                    Field field = ((Object)((Object)newStatus)).getClass().getDeclaredField("provisionFailure");
                    field.setAccessible(true);
                    field.set((Object)newStatus, failure);
                }
                catch (Exception e) {
                    this.admin.getAdminLogger().warn((Object)("failed to set provision failure " + e));
                }
            }
            ProcessingUnitInstanceProvisionStatusChangedEvent event = new ProcessingUnitInstanceProvisionStatusChangedEvent(this, processingUnitInstanceName, lastProvisionStatus, newStatus, provisionLifeCycleEvent.getGscServiceId(), failure);
            provisionStatusHolder.setNewProvisionStatus(newStatus);
            provisionStatusHolder.setPrevProvisionStatus(lastProvisionStatus);
            provisionStatusHolder.setProvisionFailure(failure);
            this.provisionStatus.put(provisionLifeCycleEvent.getProcessingUnitInstanceName(), provisionStatusHolder);
            this.processingUnitInstanceProvisionStatusChangedEventManager.processingUnitInstanceProvisionStatusChanged(event);
            ((InternalProcessingUnitInstanceProvisionStatusChangedEventManager)this.getProcessingUnits().getProcessingUnitInstanceProvisionStatusChanged()).processingUnitInstanceProvisionStatusChanged(event);
        }
    }

    @Override
    public Map<String, InternalProvisionStatusHolder> getProvisionStatusPerInstance() {
        return Collections.unmodifiableMap(this.provisionStatus);
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public ProcessingUnitInstanceProvisionStatusChangedEventManager getProcessingUnitInstanceProvisionStatusChanged() {
        return this.processingUnitInstanceProvisionStatusChangedEventManager;
    }

    @Override
    public ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager getProcessingUnitInstanceMemberAliveIndicatorStatusChanged() {
        return this.processingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
    }

    @Override
    public ProcessingUnitStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics() == null) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private ProcessingUnitStatistics doGetStatistics() {
        ProcessingUnitStatistics prevStats = this.lastStatisticsHolder.getLastStatistics();
        long currentTime = SystemTime.timeMillis();
        DefaultProcessingUnitStatistics statistics = new DefaultProcessingUnitStatistics(currentTime, prevStats, this.scheduledStatisticsHolder.getStatisticsHistorySize());
        HashMap<String, ProcessingUnitInstance> instancesSnapshot = new HashMap<String, ProcessingUnitInstance>(this.processingUnitInstances);
        HashSet<ProcessingUnitStatisticsId> statisticsIdsSnapshot = new HashSet<ProcessingUnitStatisticsId>((Collection<ProcessingUnitStatisticsId>)this.statisticsIds);
        for (ProcessingUnitStatisticsId statisticsId : statisticsIdsSnapshot) {
            this.injectInstanceStatisticsIfAvailable(instancesSnapshot, statistics, statisticsId);
        }
        statistics.calculateStatistics(statisticsIdsSnapshot);
        return statistics;
    }

    private void injectInstanceStatisticsIfAvailable(Map<String, ProcessingUnitInstance> instancesSnapshot, InternalProcessingUnitStatistics statistics, ProcessingUnitStatisticsId statisticsId) {
        InstancesStatisticsConfig instancesStatistics = statisticsId.getInstancesStatistics();
        if (instancesStatistics instanceof SingleInstanceStatisticsConfig) {
            String instanceUid = ((SingleInstanceStatisticsConfig)statisticsId.getInstancesStatistics()).getInstanceUid();
            ProcessingUnitInstance instance = instancesSnapshot.get(instanceUid);
            if (instance == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to find processing unit " + this.getName() + " instance with UID " + instanceUid));
                }
            } else {
                this.injectInstanceStatisticsIfAvailable(statistics, statisticsId, instance);
            }
        } else {
            for (ProcessingUnitInstance instance : this.processingUnitInstances.values()) {
                this.injectInstanceStatisticsIfAvailable(statistics, statisticsId, instance);
            }
        }
    }

    private void injectInstanceStatisticsIfAvailable(InternalProcessingUnitStatistics puStatistics, ProcessingUnitStatisticsId statisticsId, ProcessingUnitInstance instance) {
        block12: {
            ProcessingUnitInstanceStatistics lastStatistics = ((InternalProcessingUnitInstance)instance).getLastStatistics();
            if (lastStatistics == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Failed to retrieve last statistics for for processing unit " + this.getName() + " instance " + instance.getUid()));
                }
            } else {
                ServiceMonitors serviceMonitors = lastStatistics.getMonitors().get(statisticsId.getMonitor());
                if (serviceMonitors == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to find serviceMonitors " + statisticsId.getMonitor() + " for processing unit " + this.getName()));
                    }
                } else {
                    Object value = serviceMonitors.getMonitors().get(statisticsId.getMetric());
                    if (value == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("No statistics is available for metric " + statisticsId.getMetric() + " in serviceMonitors " + statisticsId.getMonitor() + " for processing unit " + this.getName() + " serviceMonitors keys are : " + serviceMonitors.getMonitors().keySet()));
                        }
                    } else {
                        try {
                            ExactZonesConfig zones = this.getHostingGridServiceAgentZones(instance);
                            ProcessingUnitStatisticsId newStatisticsId = new ProcessingUnitStatisticsIdConfigurer().metric(statisticsId.getMetric()).monitor(statisticsId.getMonitor()).timeWindowStatistics(new LastSampleTimeWindowStatisticsConfig()).agentZones(zones).instancesStatistics(new SingleInstanceStatisticsConfigurer().instance(instance).create()).create();
                            if (logger.isTraceEnabled()) {
                                logger.trace((Object)("adding statistics id " + newStatisticsId + " with value " + value + " to processing unit statistics of " + this.getName()));
                            }
                            puStatistics.addStatistics(newStatisticsId, value);
                        }
                        catch (AdminException e) {
                            if (!logger.isDebugEnabled()) break block12;
                            logger.debug((Object)("Failed retrieving zones for processing unit instance " + this.getName() + " : " + e.getMessage()));
                        }
                    }
                }
            }
        }
    }

    @Override
    public ExactZonesConfig getHostingGridServiceAgentZones(ProcessingUnitInstance processingUnitInstance) throws AdminException {
        GridServiceContainer gridServiceContainer = processingUnitInstance.getGridServiceContainer();
        if (gridServiceContainer.getAgentId() != -1) {
            GridServiceAgent agent = gridServiceContainer.getGridServiceAgent();
            if (agent == null) {
                throw new AdminException("Not yet discovered GSA that started container " + gridServiceContainer.getAgentId());
            }
            return agent.getExactZones();
        }
        return new ExactZonesConfig();
    }

    @Override
    public void addStatisticsCalculation(ProcessingUnitStatisticsId statisticsId) {
        statisticsId.validate();
        this.statisticsIds.add((Object)statisticsId);
    }

    @Override
    public void removeStatisticsCalculation(ProcessingUnitStatisticsId statisticsId) {
        this.statisticsIds.remove((Object)statisticsId);
    }

    @Override
    public Set<ProcessingUnitStatisticsId> getStatisticsCalculations() {
        return Collections.unmodifiableSet(this.statisticsIds);
    }

    @Override
    public RequiredZonesConfig getRequiredContainerZones() {
        String[] requiredZones = this.getRequiredZones();
        if (requiredZones.length == 0) {
            return new AnyZonesConfig();
        }
        return new AtLeastOneZoneConfigurer().addZones(requiredZones).create();
    }

    @Override
    public GridServiceContainer[] getGridServiceContainers() {
        ProcessingUnitInstance[] processingUnitInstances;
        HashMap<String, GridServiceContainer> containerMap = new HashMap<String, GridServiceContainer>();
        for (ProcessingUnitInstance instance : processingUnitInstances = this.getInstances()) {
            containerMap.put(instance.getId(), instance.getGridServiceContainer());
        }
        return containerMap.values().toArray(new GridServiceContainer[containerMap.size()]);
    }

    @Override
    public boolean isBackupGsmInSync() {
        return this.backupGsmIsInSync;
    }

    @Override
    public ProcessingUnitInstance getProcessingUnitInstanceByUid(String uid) {
        return this.processingUnitInstances.get(uid);
    }

    @Override
    public boolean isStandaloneProcessingUnit() {
        ProcessingUnitInstance instance;
        ServiceDetails standaloneSvnDetails;
        ProcessingUnitInstance[] instances = this.getInstances();
        return instances.length > 0 && (standaloneSvnDetails = (instance = instances[0]).getServiceDetailsByServiceId("Standalone")) != null;
    }

    @Override
    public void setBackupGsmInSync(boolean backupGsmIsInSync) {
        this.backupGsmIsInSync = backupGsmIsInSync;
    }

    @Override
    public QuiesceResult quiesce(QuiesceRequest request) {
        if (!this.isManaged()) {
            throw new AdminException("No managing GSM to execute quiesce");
        }
        if (this.processingUnitType != ProcessingUnitType.STATEFUL) {
            throw new AdminException("Only stateful Processing Units can be quiesced");
        }
        InternalQuiesceDetails quiesceDetails = ((InternalGridServiceManager)this.managingGridServiceManager).quiesce(this, request);
        return new QuiesceResult(quiesceDetails.getToken(), quiesceDetails.getDescription());
    }

    @Override
    public void unquiesce(QuiesceRequest request) {
        if (!this.isManaged()) {
            throw new AdminException("No managing GSM to execute quiesce");
        }
        ((InternalGridServiceManager)this.managingGridServiceManager).unquiesce(this, request);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean waitFor(QuiesceState desiredState, long timeout, TimeUnit timeUnit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean instancesReachedQuiesceState(QuiesceState desiredState, QuiesceDetails currentDetails) {
        if (currentDetails.getInstancesQuiesceState() == null) {
            return false;
        }
        InstancesQuiesceState instancesQuiesceState = currentDetails.getInstancesQuiesceState();
        if (instancesQuiesceState.getMissingInstancesCount() != 0) {
            return false;
        }
        return currentDetails.getStatus().equals((Object)desiredState) && instancesQuiesceState.getFailedToQuiesceInstances().size() == 0;
    }

    @Override
    public boolean waitFor(QuiesceState desiredState) {
        return this.waitFor(desiredState, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public QuiesceDetails getQuiesceDetails() {
        if (!this.isManaged()) {
            if (this.isStandaloneProcessingUnit()) {
                return new QuiesceDetails(QuiesceState.UNQUIESCED, "n/a", new InstancesQuiesceState());
            }
            GridServiceManager[] backupGridServiceManagers = this.getBackupGridServiceManagers();
            if (backupGridServiceManagers.length > 0) {
                return ((InternalGridServiceManager)backupGridServiceManagers[0]).getQuiesceDetails(this);
            }
            throw new AdminException("No managing GSM to execute getQuiesceDetails");
        }
        return ((InternalGridServiceManager)this.managingGridServiceManager).getQuiesceDetails(this);
    }

    @Override
    public String getArchiveName() {
        return this.archiveName;
    }
}

