/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.monitor.ServiceFaultDetectionEvent;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.gsm.InternalGridServiceManager;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstanceServiceStatistics;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstance;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.DefaultSpaceInstances;
import org.openspaces.admin.internal.space.InternalSpaceInstance;
import org.openspaces.admin.internal.space.InternalSpaceInstances;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.support.AbstractGridComponent;
import org.openspaces.admin.internal.utils.NameUtils;
import org.openspaces.admin.pu.MemberAliveIndicatorStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.ProcessingUnitInstanceStatistics;
import org.openspaces.admin.pu.ProcessingUnitPartition;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceStatisticsChangedEvent;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventListener;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.core.space.SpaceType;
import org.openspaces.events.EventContainerServiceDetails;
import org.openspaces.events.asyncpolling.AsyncPollingEventContainerServiceDetails;
import org.openspaces.events.notify.NotifyEventContainerServiceDetails;
import org.openspaces.events.polling.PollingEventContainerServiceDetails;
import org.openspaces.memcached.MemcachedServiceDetails;
import org.openspaces.pu.container.jee.JeeServiceDetails;
import org.openspaces.pu.container.servicegrid.PUDetails;
import org.openspaces.pu.container.servicegrid.PUMonitors;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.pu.service.PlainServiceMonitors;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.remoting.RemotingServiceDetails;

public class DefaultProcessingUnitInstance
extends AbstractGridComponent
implements InternalProcessingUnitInstance {
    private final String id;
    private final String uid;
    private final ServiceID serviceID;
    private final PUServiceBean puServiceBean;
    private final PUDetails puDetails;
    private final ServiceDetails[] serviceDetails;
    private volatile InternalProcessingUnit processingUnit;
    private volatile GridServiceContainer gridServiceContainer;
    private volatile ProcessingUnitPartition processingUnitPartition;
    private final SpaceServiceDetails[] embeddedSpacesDetails;
    private final SpaceServiceDetails[] spacesDetails;
    private final Map<String, EventContainerServiceDetails> eventContainerServiceDetails;
    private final Map<String, PollingEventContainerServiceDetails> pollingEventContainerServiceDetails;
    private final Map<String, NotifyEventContainerServiceDetails> notifyEventContainerServiceDetails;
    private final Map<String, AsyncPollingEventContainerServiceDetails> asyncPollingEventContainerServiceDetails;
    private final RemotingServiceDetails remotingServiceDetails;
    private final JeeServiceDetails jeeDetails;
    private final MemcachedServiceDetails memcachedDetails;
    private final Map<String, ServiceDetails> servicesDetailsByServiceId;
    private final Map<String, ServiceDetails[]> servicesDetailsByServiceType;
    private final InternalSpaceInstances spaceInstances;
    private final LastStatisticsHolder<ProcessingUnitInstanceStatistics> lastStatisticsHolder = new LastStatisticsHolder();
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private final InternalProcessingUnitInstanceStatisticsChangedEventManager statisticsChangedEventManager;
    private volatile MemberAliveIndicatorStatus memberAliveIndicatorStatus = MemberAliveIndicatorStatus.ALIVE;

    public DefaultProcessingUnitInstance(ServiceID serviceID, PUDetails puDetails, PUServiceBean puServiceBean, InternalAdmin admin, JVMDetails jvmDetails) {
        super(admin, jvmDetails);
        this.serviceID = serviceID;
        this.uid = serviceID.toString();
        this.puDetails = puDetails;
        this.id = puDetails.getClusterInfo().getName() + "~" + puDetails.getClusterInfo().getSuffix();
        this.puServiceBean = puServiceBean;
        this.spaceInstances = new DefaultSpaceInstances(admin);
        this.statisticsChangedEventManager = new DefaultProcessingUnitInstanceStatisticsChangedEventManager(admin);
        this.serviceDetails = new ServiceDetails[puDetails.getDetails().length];
        for (int i = 0; i < puDetails.getDetails().length; ++i) {
            this.serviceDetails[i] = (ServiceDetails)puDetails.getDetails()[i];
        }
        ArrayList<SpaceServiceDetails> embeddedSpacesEmbeddedList = new ArrayList<SpaceServiceDetails>();
        ArrayList<SpaceServiceDetails> spacesDetailsList = new ArrayList<SpaceServiceDetails>();
        JeeServiceDetails jeeDetailsX = null;
        MemcachedServiceDetails memcachedDetailsX = null;
        RemotingServiceDetails remotingServiceDetailsX = null;
        HashMap<String, ArrayList<ServiceDetails>> servicesDetailsByServiceTypeList = new HashMap<String, ArrayList<ServiceDetails>>();
        HashMap<String, ServiceDetails> serviceDetailsByServiceId = new HashMap<String, ServiceDetails>();
        HashMap<String, EventContainerServiceDetails> eventContainerServiceDetails = new HashMap<String, EventContainerServiceDetails>();
        HashMap<String, PollingEventContainerServiceDetails> pollingEventContainerServiceDetails = new HashMap<String, PollingEventContainerServiceDetails>();
        HashMap<String, NotifyEventContainerServiceDetails> notifyEventContainerServiceDetails = new HashMap<String, NotifyEventContainerServiceDetails>();
        HashMap<String, AsyncPollingEventContainerServiceDetails> asyncPollingEventContainerServiceDetails = new HashMap<String, AsyncPollingEventContainerServiceDetails>();
        for (ServiceDetails serviceDetails : this.serviceDetails) {
            serviceDetailsByServiceId.put(serviceDetails.getId(), serviceDetails);
            ArrayList<ServiceDetails> list = (ArrayList<ServiceDetails>)servicesDetailsByServiceTypeList.get(serviceDetails.getServiceType());
            if (list == null) {
                list = new ArrayList<ServiceDetails>();
                servicesDetailsByServiceTypeList.put(serviceDetails.getServiceType(), list);
            }
            list.add(serviceDetails);
            if (serviceDetails instanceof SpaceServiceDetails) {
                SpaceServiceDetails spaceDetails = (SpaceServiceDetails)serviceDetails;
                spacesDetailsList.add(spaceDetails);
                if (spaceDetails.getSpaceType() != SpaceType.EMBEDDED) continue;
                embeddedSpacesEmbeddedList.add((SpaceServiceDetails)serviceDetails);
                continue;
            }
            if (serviceDetails instanceof JeeServiceDetails) {
                jeeDetailsX = (JeeServiceDetails)serviceDetails;
                continue;
            }
            if (serviceDetails instanceof MemcachedServiceDetails) {
                memcachedDetailsX = (MemcachedServiceDetails)serviceDetails;
                continue;
            }
            if (serviceDetails instanceof RemotingServiceDetails) {
                remotingServiceDetailsX = (RemotingServiceDetails)serviceDetails;
                continue;
            }
            if (!(serviceDetails instanceof EventContainerServiceDetails)) continue;
            eventContainerServiceDetails.put(serviceDetails.getId(), (EventContainerServiceDetails)serviceDetails);
            if (serviceDetails instanceof PollingEventContainerServiceDetails) {
                pollingEventContainerServiceDetails.put(serviceDetails.getId(), (PollingEventContainerServiceDetails)serviceDetails);
                continue;
            }
            if (serviceDetails instanceof NotifyEventContainerServiceDetails) {
                notifyEventContainerServiceDetails.put(serviceDetails.getId(), (NotifyEventContainerServiceDetails)serviceDetails);
                continue;
            }
            if (!(serviceDetails instanceof AsyncPollingEventContainerServiceDetails)) continue;
            asyncPollingEventContainerServiceDetails.put(serviceDetails.getId(), (AsyncPollingEventContainerServiceDetails)serviceDetails);
        }
        this.eventContainerServiceDetails = Collections.unmodifiableMap(eventContainerServiceDetails);
        this.pollingEventContainerServiceDetails = Collections.unmodifiableMap(pollingEventContainerServiceDetails);
        this.notifyEventContainerServiceDetails = Collections.unmodifiableMap(notifyEventContainerServiceDetails);
        this.asyncPollingEventContainerServiceDetails = Collections.unmodifiableMap(asyncPollingEventContainerServiceDetails);
        this.jeeDetails = jeeDetailsX;
        this.memcachedDetails = memcachedDetailsX;
        this.remotingServiceDetails = remotingServiceDetailsX;
        this.embeddedSpacesDetails = embeddedSpacesEmbeddedList.toArray(new SpaceServiceDetails[embeddedSpacesEmbeddedList.size()]);
        this.spacesDetails = spacesDetailsList.toArray(new SpaceServiceDetails[spacesDetailsList.size()]);
        this.servicesDetailsByServiceId = Collections.unmodifiableMap(serviceDetailsByServiceId);
        HashMap servicesDetailsTemp = new HashMap();
        for (Map.Entry entry : servicesDetailsByServiceTypeList.entrySet()) {
            servicesDetailsTemp.put(entry.getKey(), ((List)entry.getValue()).toArray(new ServiceDetails[((List)entry.getValue()).size()]));
        }
        this.servicesDetailsByServiceType = Collections.unmodifiableMap(servicesDetailsTemp);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getInstanceId() {
        return this.puDetails.getClusterInfo().getInstanceId();
    }

    @Override
    public int getBackupId() {
        if (this.puDetails.getClusterInfo().getBackupId() == null) {
            return 0;
        }
        return this.puDetails.getClusterInfo().getBackupId();
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public ProcessingUnit getProcessingUnit() {
        return this.processingUnit;
    }

    @Override
    public String getName() {
        return this.puDetails.getClusterInfo().getName();
    }

    @Override
    public String getProcessingUnitInstanceName() {
        return NameUtils.getSpaceInstanceName(this.getName(), this.getClusterInfo().getInstanceId(), this.getBackupId(), this.getClusterInfo().getNumberOfBackups());
    }

    @Override
    public String getProcessingUnitInstanceSimpleName() {
        return NameUtils.getSpaceInstanceName(((InternalProcessingUnit)this.getProcessingUnit()).getSimpleName(), this.getClusterInfo().getInstanceId(), this.getBackupId(), this.getClusterInfo().getNumberOfBackups());
    }

    @Override
    public void setProcessingUnit(ProcessingUnit processingUnit) {
        this.assertStateChangesPermitted();
        this.processingUnit = (InternalProcessingUnit)processingUnit;
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return this.puDetails.getClusterInfo();
    }

    @Override
    public BeanLevelProperties getProperties() {
        return this.puDetails.getBeanLevelProperties();
    }

    @Override
    public Iterator<ServiceDetails> iterator() {
        return Arrays.asList(this.serviceDetails).iterator();
    }

    @Override
    public Map<String, EventContainerServiceDetails> getEventContainerDetails() {
        return this.eventContainerServiceDetails;
    }

    @Override
    public Map<String, PollingEventContainerServiceDetails> getPollingEventContainerDetails() {
        return this.pollingEventContainerServiceDetails;
    }

    @Override
    public Map<String, NotifyEventContainerServiceDetails> getNotifyEventContainerDetails() {
        return this.notifyEventContainerServiceDetails;
    }

    @Override
    public Map<String, AsyncPollingEventContainerServiceDetails> getAsyncPollingEventContainerDetails() {
        return this.asyncPollingEventContainerServiceDetails;
    }

    @Override
    public SpaceServiceDetails[] getSpaceDetails() {
        return this.spacesDetails;
    }

    @Override
    public SpaceServiceDetails getEmbeddedSpaceDetails() {
        if (this.embeddedSpacesDetails.length == 0) {
            return null;
        }
        return this.embeddedSpacesDetails[0];
    }

    @Override
    public SpaceServiceDetails[] getEmbeddedSpacesDetails() {
        return this.embeddedSpacesDetails;
    }

    public ServiceDetails[] getServicesDetails() {
        return this.serviceDetails;
    }

    @Override
    public ServiceID getGridServiceContainerServiceID() {
        return this.puDetails.getGscServiceID();
    }

    @Override
    public void setGridServiceContainer(GridServiceContainer gridServiceContainer) {
        this.assertStateChangesPermitted();
        this.gridServiceContainer = gridServiceContainer;
    }

    @Override
    public GridServiceContainer getGridServiceContainer() {
        return this.gridServiceContainer;
    }

    @Override
    public void setProcessingUnitPartition(ProcessingUnitPartition processingUnitPartition) {
        this.assertStateChangesPermitted();
        this.processingUnitPartition = processingUnitPartition;
    }

    @Override
    public ProcessingUnitPartition getPartition() {
        return this.processingUnitPartition;
    }

    @Override
    public PUServiceBean getPUServiceBean() {
        return this.puServiceBean;
    }

    @Override
    public boolean isEmbeddedSpaces() {
        return this.spaceInstances.size() != 0;
    }

    @Override
    public SpaceInstance getSpaceInstance() {
        Iterator it = this.spaceInstances.iterator();
        if (it.hasNext()) {
            return (SpaceInstance)it.next();
        }
        return null;
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        return this.spaceInstances.getSpaceInstances();
    }

    @Override
    public SpaceInstance waitForSpaceInstance() {
        return this.waitForSpaceInstance(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public SpaceInstance waitForSpaceInstance(long timeout, TimeUnit timeUnit) {
        final AtomicReference<SpaceInstance> ref = new AtomicReference<SpaceInstance>();
        ref.set(this.getSpaceInstance());
        if (ref.get() != null) {
            return (SpaceInstance)ref.get();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        SpaceInstanceAddedEventListener listener = new SpaceInstanceAddedEventListener(){

            @Override
            public void spaceInstanceAdded(SpaceInstance spaceInstance) {
                ref.set(spaceInstance);
                latch.countDown();
            }
        };
        this.spaceInstances.getSpaceInstanceAdded().add(listener);
        try {
            latch.await(timeout, timeUnit);
            SpaceInstance spaceInstance = (SpaceInstance)ref.get();
            return spaceInstance;
        }
        catch (Exception e) {
            throw new AdminException("Failed to wait for space instance", e);
        }
        finally {
            this.spaceInstances.getSpaceInstanceAdded().remove(listener);
        }
    }

    @Override
    public boolean addSpaceInstanceIfMatching(SpaceInstance spaceInstance) {
        for (SpaceServiceDetails spaceDetails : this.embeddedSpacesDetails) {
            if (!((InternalSpaceInstance)spaceInstance).getServiceID().equals((Object)spaceDetails.getServiceID())) continue;
            this.spaceInstances.addSpaceInstance(spaceInstance);
            return true;
        }
        return false;
    }

    @Override
    public void removeSpaceInstance(String uid) {
        this.spaceInstances.removeSpaceInstance(uid);
    }

    @Override
    public boolean isJee() {
        return this.jeeDetails != null;
    }

    @Override
    public JeeServiceDetails getJeeDetails() {
        return this.jeeDetails;
    }

    @Override
    public MemcachedServiceDetails getMemcachedDetails() {
        return this.memcachedDetails;
    }

    @Override
    public RemotingServiceDetails getRemotingDetails() {
        return this.remotingServiceDetails;
    }

    @Override
    public ServiceDetails getServiceDetailsByServiceId(String serviceId) {
        return this.servicesDetailsByServiceId.get(serviceId);
    }

    @Override
    public Map<String, ServiceDetails> getServiceDetailsByServiceId() {
        return this.servicesDetailsByServiceId;
    }

    @Override
    public ServiceDetails[] getServicesDetailsByServiceType(String serviceType) {
        return this.servicesDetailsByServiceType.get(serviceType);
    }

    @Override
    public Map<String, ServiceDetails[]> getServiceDetailsByServiceType() {
        return this.servicesDetailsByServiceType;
    }

    @Override
    public void destroy() {
        if (!this.processingUnit.isManaged()) {
            throw new AdminException("No managing grid service manager for processing unit");
        }
        ((InternalGridServiceManager)this.processingUnit.getManagingGridServiceManager()).destroyInstance(this);
    }

    @Override
    public void relocate(GridServiceContainer gridServiceContainerToRelocateTo) {
        if (!this.processingUnit.isManaged()) {
            throw new AdminException("No managing grid service manager for processing unit");
        }
        ((InternalGridServiceManager)this.processingUnit.getManagingGridServiceManager()).relocate(this, gridServiceContainerToRelocateTo);
    }

    @Override
    public ProcessingUnitInstance relocateAndWait(GridServiceContainer gridServiceContainerToRelocateTo) {
        return this.relocateAndWait(gridServiceContainerToRelocateTo, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingUnitInstance relocateAndWait(GridServiceContainer gridServiceContainerToRelocateTo, long timeout, TimeUnit timeUnit) {
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(2);
        ProcessingUnitInstanceLifecycleEventListener added = new ProcessingUnitInstanceLifecycleEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                if (!processingUnitInstance.getUid().equals(DefaultProcessingUnitInstance.this.getUid()) && processingUnitInstance.getClusterInfo().getRunningNumber() == DefaultProcessingUnitInstance.this.getClusterInfo().getRunningNumber()) {
                    ref.set(processingUnitInstance);
                    latch.countDown();
                }
            }

            @Override
            public void processingUnitInstanceRemoved(ProcessingUnitInstance processingUnitInstance) {
                if (processingUnitInstance.getUid().equals(DefaultProcessingUnitInstance.this.getUid())) {
                    latch.countDown();
                }
            }
        };
        this.processingUnit.addLifecycleListener(added);
        try {
            this.relocate(gridServiceContainerToRelocateTo);
            latch.await(timeout, timeUnit);
            ProcessingUnitInstance processingUnitInstance = (ProcessingUnitInstance)ref.get();
            return processingUnitInstance;
        }
        catch (InterruptedException e) {
            ProcessingUnitInstance processingUnitInstance = null;
            return processingUnitInstance;
        }
        finally {
            this.processingUnit.removeLifecycleListener(added);
        }
    }

    @Override
    public void relocate() {
        this.relocate(null);
    }

    @Override
    public ProcessingUnitInstance relocateAndWait() {
        return this.relocateAndWait(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    @Override
    public ProcessingUnitInstance relocateAndWait(long timeout, TimeUnit timeUnit) {
        return this.relocateAndWait(null, timeout, timeUnit);
    }

    @Override
    public void restart() {
        if (!this.processingUnit.isManaged()) {
            throw new AdminException("No managing grid service manager for processing unit");
        }
        ((InternalGridServiceManager)this.processingUnit.getManagingGridServiceManager()).relocate(this, this.getGridServiceContainer());
    }

    @Override
    public ProcessingUnitInstance restartAndWait() {
        return this.restartAndWait(this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingUnitInstance restartAndWait(long timeout, TimeUnit timeUnit) {
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(2);
        ProcessingUnitInstanceLifecycleEventListener added = new ProcessingUnitInstanceLifecycleEventListener(){

            @Override
            public void processingUnitInstanceAdded(ProcessingUnitInstance processingUnitInstance) {
                if (!processingUnitInstance.getUid().equals(DefaultProcessingUnitInstance.this.getUid()) && processingUnitInstance.getClusterInfo().getRunningNumber() == DefaultProcessingUnitInstance.this.getClusterInfo().getRunningNumber()) {
                    ref.set(processingUnitInstance);
                    latch.countDown();
                }
            }

            @Override
            public void processingUnitInstanceRemoved(ProcessingUnitInstance processingUnitInstance) {
                if (processingUnitInstance.getUid().equals(DefaultProcessingUnitInstance.this.getUid())) {
                    latch.countDown();
                }
            }
        };
        this.processingUnit.addLifecycleListener(added);
        try {
            this.restart();
            latch.await(timeout, timeUnit);
            ProcessingUnitInstance processingUnitInstance = (ProcessingUnitInstance)ref.get();
            return processingUnitInstance;
        }
        catch (InterruptedException e) {
            ProcessingUnitInstance processingUnitInstance = null;
            return processingUnitInstance;
        }
        finally {
            this.processingUnit.removeLifecycleListener(added);
        }
    }

    @Override
    public void decrement() {
        if (!this.processingUnit.isManaged()) {
            throw new AdminException("No managing grid service manager for processing unit");
        }
        ((InternalGridServiceManager)this.processingUnit.getManagingGridServiceManager()).decrementInstance(this);
    }

    @Override
    public ProcessingUnitInstanceStatistics getLastStatistics() {
        return this.lastStatisticsHolder.getLastStatistics();
    }

    @Override
    public ProcessingUnitInstanceStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics() == null) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private ProcessingUnitInstanceStatistics doGetStatistics() {
        PUMonitors puMonitors;
        HashMap<String, ServiceMonitors> serviceMonitorsById = Collections.EMPTY_MAP;
        try {
            puMonitors = this.puServiceBean.getPUMonitors();
        }
        catch (RemoteException e) {
            if (this.admin.getAdminLogger().isDebugEnabled()) {
                this.admin.getAdminLogger().debug((Object)("Failed to get statistics using processing unit monitors of [" + this.getProcessingUnitInstanceName() + "]"), (Throwable)e);
            }
            return null;
        }
        for (Object monitor : puMonitors.getMonitors()) {
            ServiceMonitors serviceMonitors = (ServiceMonitors)monitor;
            if (serviceMonitors instanceof PlainServiceMonitors) {
                ((PlainServiceMonitors)serviceMonitors).setDetails(this.servicesDetailsByServiceId.get(serviceMonitors.getId()));
            }
            if (serviceMonitorsById == Collections.EMPTY_MAP) {
                serviceMonitorsById = new HashMap<String, ServiceMonitors>();
            }
            serviceMonitorsById.put(serviceMonitors.getId(), serviceMonitors);
        }
        ProcessingUnitInstanceStatistics previousStatistics = this.lastStatisticsHolder.getLastStatistics();
        return new DefaultProcessingUnitInstanceServiceStatistics(puMonitors.getTimestamp(), serviceMonitorsById, previousStatistics, this.scheduledStatisticsHolder.getStatisticsHistorySize(), this.getVirtualMachine().getMachine().getOperatingSystem().getTimeDelta());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.stopStatisticsMonitor();
                this.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStatisticsIntervalMilliseconds() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.getStatisticsInterval();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            final DefaultProcessingUnitInstance processingUnitInstance = this;
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ProcessingUnitInstanceStatistics stats = processingUnitInstance.getStatistics();
                    ProcessingUnitInstanceStatisticsChangedEvent event = new ProcessingUnitInstanceStatisticsChangedEvent(processingUnitInstance, stats);
                    DefaultProcessingUnitInstance.this.statisticsChangedEventManager.processingUnitInstanceStatisticsChanged(event);
                    ((InternalProcessingUnitInstanceStatisticsChangedEventManager)DefaultProcessingUnitInstance.this.processingUnit.getProcessingUnitInstanceStatisticsChanged()).processingUnitInstanceStatisticsChanged(event);
                    ((InternalProcessingUnitInstanceStatisticsChangedEventManager)DefaultProcessingUnitInstance.this.processingUnit.getProcessingUnits().getProcessingUnitInstanceStatisticsChanged()).processingUnitInstanceStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return this.puServiceBean.getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return this.puServiceBean.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        this.puServiceBean.enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        this.puServiceBean.disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return this.puServiceBean.fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        return this.puServiceBean.getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return this.puServiceBean.getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return this.puServiceBean.getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return this.puServiceBean.getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        this.puServiceBean.runGc();
    }

    @Override
    public Future<Object> invoke(String serviceBeanName, Map<String, Object> namedArgs) {
        try {
            Future future = (Future)this.puServiceBean.invoke(serviceBeanName, namedArgs);
            return future;
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to invoke processing unit instance", e);
        }
        finally {
            FutureContext.clear();
        }
    }

    @Override
    public boolean isUndeploying() {
        try {
            boolean startedUndeploying = !this.isDiscovered();
            boolean endedUndeploying = !this.puServiceBean.isStopping();
            return startedUndeploying && !endedUndeploying;
        }
        catch (RemoteException e) {
            throw new AdminException("Failed to check if processing unit instance is alive", e);
        }
    }

    @Override
    public void setMemberAliveIndicatorStatus(ServiceFaultDetectionEvent serviceFaultDetectionEvent) {
        MemberAliveIndicatorStatus newStatus;
        if (serviceFaultDetectionEvent.isAlive()) {
            newStatus = MemberAliveIndicatorStatus.ALIVE;
        } else if (serviceFaultDetectionEvent.isSuspectedFailure()) {
            newStatus = MemberAliveIndicatorStatus.SUSPECTING_FAILURE;
        } else if (serviceFaultDetectionEvent.isDetectedFailure()) {
            newStatus = MemberAliveIndicatorStatus.DETECTED_FAILURE;
        } else {
            throw new IllegalStateException("unknown member alive indicator status");
        }
        if (newStatus != this.memberAliveIndicatorStatus) {
            ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent event = new ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent(this, this.memberAliveIndicatorStatus, newStatus);
            ((InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager)this.processingUnit.getProcessingUnitInstanceMemberAliveIndicatorStatusChanged()).processingUnitInstanceMemberAliveIndicatorStatusChanged(event);
            ((InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager)this.processingUnit.getProcessingUnits().getProcessingUnitInstanceMemberAliveIndicatorStatusChanged()).processingUnitInstanceMemberAliveIndicatorStatusChanged(event);
            this.memberAliveIndicatorStatus = newStatus;
        }
    }

    @Override
    public MemberAliveIndicatorStatus getMemberAliveIndicatorStatus() {
        return this.memberAliveIndicatorStatus;
    }
}

