/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.pu.ProcessingUnitInstanceStatistics;
import org.openspaces.events.EventContainerServiceMonitors;
import org.openspaces.events.asyncpolling.AsyncPollingEventContainerServiceMonitors;
import org.openspaces.events.notify.NotifyEventContainerServiceMonitors;
import org.openspaces.events.polling.PollingEventContainerServiceMonitors;
import org.openspaces.memcached.MemcachedServiceMonitors;
import org.openspaces.pu.container.jee.stats.WebRequestsServiceMonitors;
import org.openspaces.pu.service.ServiceMonitors;
import org.openspaces.remoting.RemotingServiceMonitors;

public class DefaultProcessingUnitInstanceServiceStatistics
implements ProcessingUnitInstanceStatistics {
    private final long timeDelta;
    private final long timestamp;
    private final Map<String, ServiceMonitors> serviceMonitorsById;
    private volatile ProcessingUnitInstanceStatistics previous;

    public DefaultProcessingUnitInstanceServiceStatistics(long timestamp, Map<String, ServiceMonitors> serviceMonitorsById, ProcessingUnitInstanceStatistics previous, int historySize, long timeDelta) {
        WebRequestsServiceMonitors webRequests;
        this.timestamp = timestamp;
        this.timeDelta = timeDelta;
        this.previous = previous;
        this.serviceMonitorsById = new HashMap<String, ServiceMonitors>(serviceMonitorsById);
        ProcessingUnitInstanceStatistics lastStats = previous;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultProcessingUnitInstanceServiceStatistics)lastStats).setPrevious(null);
        }
        if ((webRequests = this.getWebRequests()) != null) {
            if (previous != null) {
                webRequests.setPrevious(previous.getWebRequests(), this.getAdminTimestamp() - previous.getAdminTimestamp());
            } else {
                webRequests.setPrevious(null, 0L);
            }
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getAdminTimestamp() {
        if (this.timestamp != -1L && this.timeDelta != Integer.MIN_VALUE) {
            return this.timestamp + this.timeDelta;
        }
        return -1L;
    }

    @Override
    public Iterator<ServiceMonitors> iterator() {
        return Collections.unmodifiableCollection(this.serviceMonitorsById.values()).iterator();
    }

    @Override
    public Map<String, ServiceMonitors> getMonitors() {
        return Collections.unmodifiableMap(this.serviceMonitorsById);
    }

    @Override
    public Map<String, EventContainerServiceMonitors> getEventContainers() {
        HashMap<String, Object> eventContainerServiceMonitors = new HashMap<String, EventContainerServiceMonitors>();
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof EventContainerServiceMonitors)) continue;
            if (eventContainerServiceMonitors == Collections.EMPTY_MAP) {
                eventContainerServiceMonitors = new HashMap();
            }
            eventContainerServiceMonitors.put(monitors.getId(), (EventContainerServiceMonitors)monitors);
        }
        return eventContainerServiceMonitors;
    }

    @Override
    public Map<String, PollingEventContainerServiceMonitors> getPollingEventContainers() {
        HashMap<String, Object> pollingEventContainerServiceMonitors = new HashMap<String, PollingEventContainerServiceMonitors>();
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof EventContainerServiceMonitors) || !(monitors instanceof PollingEventContainerServiceMonitors)) continue;
            if (pollingEventContainerServiceMonitors == Collections.EMPTY_MAP) {
                pollingEventContainerServiceMonitors = new HashMap();
            }
            pollingEventContainerServiceMonitors.put(monitors.getId(), (PollingEventContainerServiceMonitors)monitors);
        }
        return pollingEventContainerServiceMonitors;
    }

    @Override
    public Map<String, NotifyEventContainerServiceMonitors> getNotifyEventContainers() {
        HashMap<String, Object> notifyEventContainerServiceMonitors = new HashMap<String, NotifyEventContainerServiceMonitors>();
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof EventContainerServiceMonitors) || !(monitors instanceof NotifyEventContainerServiceMonitors)) continue;
            if (notifyEventContainerServiceMonitors == Collections.EMPTY_MAP) {
                notifyEventContainerServiceMonitors = new HashMap();
            }
            notifyEventContainerServiceMonitors.put(monitors.getId(), (NotifyEventContainerServiceMonitors)monitors);
        }
        return notifyEventContainerServiceMonitors;
    }

    @Override
    public Map<String, AsyncPollingEventContainerServiceMonitors> getAsyncPollingEventContainers() {
        HashMap<String, Object> asyncPollingEventContainerServiceMonitors = new HashMap<String, AsyncPollingEventContainerServiceMonitors>();
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof EventContainerServiceMonitors) || !(monitors instanceof AsyncPollingEventContainerServiceMonitors)) continue;
            if (asyncPollingEventContainerServiceMonitors == Collections.EMPTY_MAP) {
                asyncPollingEventContainerServiceMonitors = new HashMap();
            }
            asyncPollingEventContainerServiceMonitors.put(monitors.getId(), (AsyncPollingEventContainerServiceMonitors)monitors);
        }
        return asyncPollingEventContainerServiceMonitors;
    }

    @Override
    public RemotingServiceMonitors getRemoting() {
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof RemotingServiceMonitors)) continue;
            return (RemotingServiceMonitors)monitors;
        }
        return null;
    }

    @Override
    public WebRequestsServiceMonitors getWebRequests() {
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof WebRequestsServiceMonitors)) continue;
            return (WebRequestsServiceMonitors)monitors;
        }
        return null;
    }

    @Override
    public MemcachedServiceMonitors getMemcached() {
        for (ServiceMonitors monitors : this.serviceMonitorsById.values()) {
            if (!(monitors instanceof MemcachedServiceMonitors)) continue;
            return (MemcachedServiceMonitors)monitors;
        }
        return null;
    }

    @Override
    public ProcessingUnitInstanceStatistics getPrevious() {
        return this.previous;
    }

    public void setPrevious(ProcessingUnitInstanceStatistics previous) {
        this.previous = previous;
    }

    public void addMonitors(ServiceMonitors[] monitors) {
        for (ServiceMonitors serviceMonitors : monitors) {
            this.serviceMonitorsById.put(serviceMonitors.getId(), serviceMonitors);
        }
    }

    @Override
    public List<ProcessingUnitInstanceStatistics> getTimelineFromTimestamp(long fromTimestamp) {
        ArrayList<ProcessingUnitInstanceStatistics> timeline = new ArrayList<ProcessingUnitInstanceStatistics>();
        for (ProcessingUnitInstanceStatistics current = this; current != null && current.getTimestamp() > fromTimestamp; current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }
}

