/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstances;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;

public class DefaultProcessingUnitInstances
implements InternalProcessingUnitInstances {
    private static final Log logger = LogFactory.getLog(DefaultProcessingUnitInstances.class);
    private final InternalAdmin admin;
    private final Map<String, ProcessingUnitInstance> processingUnitInstances = new ConcurrentHashMap<String, ProcessingUnitInstance>();
    private final InternalProcessingUnitInstanceAddedEventManager processingUnitInstanceAddedEventManager;
    private final InternalProcessingUnitInstanceRemovedEventManager processingUnitInstanceRemovedEventManager;

    public DefaultProcessingUnitInstances(InternalAdmin admin) {
        this.admin = admin;
        this.processingUnitInstanceAddedEventManager = new DefaultProcessingUnitInstanceAddedEventManager(this, admin);
        this.processingUnitInstanceRemovedEventManager = new DefaultProcessingUnitInstanceRemovedEventManager(admin);
    }

    @Override
    public boolean contains(ProcessingUnitInstance processingUnitInstance) {
        for (ProcessingUnitInstance it : this.processingUnitInstances.values()) {
            if (!it.getUid().equals(processingUnitInstance.getUid())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addInstance(ProcessingUnitInstance processingUnitInstance) {
        this.assertStateChangesPermitted();
        ProcessingUnitInstance existingPU = this.processingUnitInstances.put(processingUnitInstance.getUid(), processingUnitInstance);
        if (existingPU == null) {
            this.processingUnitInstanceAddedEventManager.processingUnitInstanceAdded(processingUnitInstance);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(processingUnitInstance.getProcessingUnitInstanceName() + " with id [" + processingUnitInstance.getUid() + "] has already been added. No event is called."));
        }
    }

    @Override
    public ProcessingUnitInstance removeInstance(String uid) {
        this.assertStateChangesPermitted();
        ProcessingUnitInstance processingUnitInstance = this.processingUnitInstances.remove(uid);
        if (processingUnitInstance != null) {
            this.processingUnitInstanceRemovedEventManager.processingUnitInstanceRemoved(processingUnitInstance);
        }
        return processingUnitInstance;
    }

    @Override
    public Iterator<ProcessingUnitInstance> getInstancesIt() {
        return Collections.unmodifiableCollection(this.processingUnitInstances.values()).iterator();
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        return this.getInstances();
    }

    @Override
    public ProcessingUnitInstance[] getInstances() {
        return this.processingUnitInstances.values().toArray(new ProcessingUnitInstance[0]);
    }

    @Override
    public ProcessingUnitInstance[] getInstances(String processingUnitName) {
        ArrayList<ProcessingUnitInstance> retVal = new ArrayList<ProcessingUnitInstance>();
        for (ProcessingUnitInstance instance : this.processingUnitInstances.values()) {
            if (!instance.getName().equals(processingUnitName)) continue;
            retVal.add(instance);
        }
        return retVal.toArray(new ProcessingUnitInstance[retVal.size()]);
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstanceAddedEventManager;
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstanceRemovedEventManager;
    }

    @Override
    public void addProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstanceAddedEventManager.add(eventListener);
        this.processingUnitInstanceRemovedEventManager.add(eventListener);
    }

    @Override
    public void removeProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstanceAddedEventManager.remove(eventListener);
        this.processingUnitInstanceRemovedEventManager.remove(eventListener);
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public ProcessingUnitInstance getInstanceByUID(String processingUnitInstanceUid) {
        return this.processingUnitInstances.get(processingUnitInstanceUid);
    }
}

