/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnitPartition;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;

public class DefaultProcessingUnitPartition
implements InternalProcessingUnitPartition {
    private final ProcessingUnit processingUnit;
    private final int patitionId;
    private final Map<String, ProcessingUnitInstance> processingUnitInstances = new ConcurrentHashMap<String, ProcessingUnitInstance>();

    public DefaultProcessingUnitPartition(ProcessingUnit processingUnit, int patitionId) {
        this.processingUnit = processingUnit;
        this.patitionId = patitionId;
    }

    @Override
    public int getPartitionId() {
        return this.patitionId;
    }

    @Override
    public ProcessingUnitInstance[] getInstances() {
        return this.processingUnitInstances.values().toArray(new ProcessingUnitInstance[0]);
    }

    @Override
    public ProcessingUnit getProcessingUnit() {
        return this.processingUnit;
    }

    @Override
    public ProcessingUnitInstance getPrimary() {
        for (ProcessingUnitInstance processingUnitInstance : this) {
            if (!processingUnitInstance.isEmbeddedSpaces() || processingUnitInstance.getSpaceInstance().getMode() != SpaceMode.PRIMARY) continue;
            return processingUnitInstance;
        }
        return null;
    }

    @Override
    public ProcessingUnitInstance getBackup() {
        for (ProcessingUnitInstance processingUnitInstance : this) {
            if (!processingUnitInstance.isEmbeddedSpaces() || processingUnitInstance.getSpaceInstance().getMode() != SpaceMode.BACKUP) continue;
            return processingUnitInstance;
        }
        return null;
    }

    @Override
    public Iterator<ProcessingUnitInstance> iterator() {
        return this.processingUnitInstances.values().iterator();
    }

    @Override
    public void addProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.assertStateChangesPermitted();
        this.processingUnitInstances.put(processingUnitInstance.getUid(), processingUnitInstance);
    }

    @Override
    public void removeProcessingUnitInstance(String uid) {
        this.assertStateChangesPermitted();
        this.processingUnitInstances.remove(uid);
    }

    private void assertStateChangesPermitted() {
        ((InternalAdmin)this.processingUnit.getAdmin()).assertStateChangesPermitted();
    }
}

