/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.pu.ProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.statistics.InstancesStatisticsCalculator;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatisticsCalculator;
import org.openspaces.admin.internal.pu.statistics.StatisticsObjectListFunction;
import org.openspaces.admin.internal.pu.statistics.TimeWindowStatisticsCalculator;
import org.openspaces.admin.internal.pu.statistics.ZoneStatisticsCalculator;
import org.openspaces.admin.pu.statistics.InstancesStatisticsConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfig;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ZonesConfig;

public class DefaultProcessingUnitStatistics
implements InternalProcessingUnitStatistics {
    private volatile ProcessingUnitStatistics previous;
    private final long adminTimestamp;
    private final Map<ProcessingUnitStatisticsId, Object> statistics;
    private final InternalProcessingUnitStatisticsCalculator timeWindowStatisticsCalculator = new TimeWindowStatisticsCalculator();
    private final InternalProcessingUnitStatisticsCalculator instancesStatisticsCalculator = new InstancesStatisticsCalculator();
    private final InternalProcessingUnitStatisticsCalculator zoneStatisticsCalculator = new ZoneStatisticsCalculator();
    private Log logger = LogFactory.getLog(this.getClass());

    public DefaultProcessingUnitStatistics(long adminTimestamp, ProcessingUnitStatistics lastStatistics, int historySize) {
        this.statistics = new HashMap<ProcessingUnitStatisticsId, Object>();
        this.adminTimestamp = adminTimestamp;
        this.previous = lastStatistics;
        if (lastStatistics != null) {
            for (int i = 0; i < historySize && lastStatistics.getPrevious() != null; ++i) {
                lastStatistics = lastStatistics.getPrevious();
            }
            ((DefaultProcessingUnitStatistics)lastStatistics).previous = null;
        }
    }

    @Override
    public long getAdminTimestamp() {
        return this.adminTimestamp;
    }

    @Override
    public ProcessingUnitStatistics getPrevious() {
        return this.previous;
    }

    @Override
    public Map<ProcessingUnitStatisticsId, Object> getStatistics() {
        return Collections.unmodifiableMap(this.statistics);
    }

    @Override
    public void addStatistics(ProcessingUnitStatisticsId statisticsId, Object statisticsValue) {
        statisticsId.validate();
        this.statistics.put(statisticsId, statisticsValue);
    }

    @Override
    public void calculateStatistics(Iterable<ProcessingUnitStatisticsId> statisticsIds) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("statisticsIds before calculating new statistics is = " + this.statistics));
        }
        this.calculateTimeWindowStatistics(statisticsIds);
        this.calculateZoneStatistics(statisticsIds);
        this.calculateInstancesStatistics(statisticsIds);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("statisticsIds after calculation finished = " + this.statistics));
        }
    }

    private void calculateInstancesStatistics(Iterable<ProcessingUnitStatisticsId> statisticsIds) {
        ArrayList<ProcessingUnitStatisticsId> instancesCalculatedStatistics = new ArrayList<ProcessingUnitStatisticsId>();
        for (ProcessingUnitStatisticsId statisticsId : statisticsIds) {
            if (!(statisticsId.getInstancesStatistics() instanceof StatisticsObjectListFunction)) continue;
            instancesCalculatedStatistics.add(statisticsId);
        }
        this.instancesStatisticsCalculator.calculateNewStatistics(this, instancesCalculatedStatistics);
    }

    private void calculateZoneStatistics(Iterable<ProcessingUnitStatisticsId> statisticIds) {
        ArrayList<ProcessingUnitStatisticsId> zoneCalculatedStatistics = new ArrayList<ProcessingUnitStatisticsId>();
        for (ProcessingUnitStatisticsId statisticsId : statisticIds) {
            statisticsId.validate();
            zoneCalculatedStatistics.add(statisticsId);
        }
        this.zoneStatisticsCalculator.calculateNewStatistics(this, zoneCalculatedStatistics);
    }

    private void calculateTimeWindowStatistics(Iterable<ProcessingUnitStatisticsId> statisticsIdsToCalculate) {
        HashMap<SingleInstanceStatisticsConfig, ExactZonesConfig> instances = new HashMap<SingleInstanceStatisticsConfig, ExactZonesConfig>();
        for (ProcessingUnitStatisticsId processingUnitStatisticsId : this.statistics.keySet()) {
            InstancesStatisticsConfig instancesStatistics = processingUnitStatisticsId.getInstancesStatistics();
            ZonesConfig zoneStatistics = processingUnitStatisticsId.getAgentZones();
            if (!(instancesStatistics instanceof SingleInstanceStatisticsConfig) || !(zoneStatistics instanceof ExactZonesConfig)) continue;
            instances.put((SingleInstanceStatisticsConfig)instancesStatistics, (ExactZonesConfig)processingUnitStatisticsId.getAgentZones());
        }
        ArrayList<ProcessingUnitStatisticsId> singleInstanceCalculatedStatistics = new ArrayList<ProcessingUnitStatisticsId>();
        for (ProcessingUnitStatisticsId statisticsId : statisticsIdsToCalculate) {
            ProcessingUnitStatisticsId fixedStatisticsId;
            if (statisticsId.getInstancesStatistics() instanceof SingleInstanceStatisticsConfig) {
                SingleInstanceStatisticsConfig instancesStatistics = (SingleInstanceStatisticsConfig)statisticsId.getInstancesStatistics();
                if (!instances.containsKey(instancesStatistics)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Failed to find instance UID " + instancesStatistics.getInstanceUid()));
                    continue;
                }
                ExactZonesConfig zoneStatistics = (ExactZonesConfig)instances.get(instancesStatistics);
                if (!statisticsId.getAgentZones().isSatisfiedBy(zoneStatistics)) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Failed to find instance UID " + instancesStatistics.getInstanceUid() + " with zones " + zoneStatistics.getZones() + " which satisfies zones " + statisticsId.getAgentZones()));
                    continue;
                }
                fixedStatisticsId = statisticsId.shallowClone();
                zoneStatistics.validate();
                fixedStatisticsId.setAgentZones(zoneStatistics);
                singleInstanceCalculatedStatistics.add(fixedStatisticsId);
                continue;
            }
            for (Map.Entry pair : instances.entrySet()) {
                fixedStatisticsId = statisticsId.shallowClone();
                fixedStatisticsId.setInstancesStatistics((InstancesStatisticsConfig)pair.getKey());
                fixedStatisticsId.setAgentZones((ZonesConfig)pair.getValue());
                singleInstanceCalculatedStatistics.add(fixedStatisticsId);
            }
        }
        this.timeWindowStatisticsCalculator.calculateNewStatistics(this, singleInstanceCalculatedStatistics);
    }

    public String toString() {
        return "ProcessingUnitStatistics {adminTimestamp=" + this.adminTimestamp + ", statistics=" + this.statistics + "}";
    }
}

