/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingFailureEventManager;
import org.openspaces.admin.internal.pu.elastic.events.DefaultElasticAutoScalingProgressChangedEventManager;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticAutoScalingFailureEventManager;
import org.openspaces.admin.internal.pu.elastic.events.InternalElasticAutoScalingProgressChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultBackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitAddedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitRemovedEventManager;
import org.openspaces.admin.internal.pu.events.DefaultProcessingUnitStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalBackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitAddedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitRemovedEventManager;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitStatusChangedEventManager;
import org.openspaces.admin.internal.space.InternalSpace;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.elastic.events.ElasticAutoScalingFailureEvent;
import org.openspaces.admin.pu.elastic.events.ElasticAutoScalingFailureEventManager;
import org.openspaces.admin.pu.elastic.events.ElasticAutoScalingProgressChangedEvent;
import org.openspaces.admin.pu.elastic.events.ElasticAutoScalingProgressChangedEventManager;
import org.openspaces.admin.pu.elastic.events.ElasticProcessingUnitEvent;
import org.openspaces.admin.pu.elastic.events.ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent;
import org.openspaces.admin.pu.events.BackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.pu.events.ManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitAddedEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEventManager;

public class DefaultProcessingUnits
implements InternalProcessingUnits {
    private final InternalAdmin admin;
    private final Map<String, ProcessingUnit> processingUnits = new SizeConcurrentHashMap();
    private final InternalProcessingUnitAddedEventManager processingUnitAddedEventManager;
    private final InternalProcessingUnitRemovedEventManager processingUnitRemovedEventManager;
    private final InternalManagingGridServiceManagerChangedEventManager managingGridServiceManagerChangedEventManager;
    private final InternalBackupGridServiceManagerChangedEventManager backupGridServiceManagerChangedEventManager;
    private final InternalProcessingUnitStatusChangedEventManager processingUnitStatusChangedEventManager;
    private final InternalProcessingUnitInstanceAddedEventManager processingUnitInstanceAddedEventManager;
    private final InternalProcessingUnitInstanceRemovedEventManager processingUnitInstanceRemovedEventManager;
    private final InternalProcessingUnitInstanceStatisticsChangedEventManager processingUnitInstanceStatisticsChangedEventManager;
    private final InternalProcessingUnitInstanceProvisionStatusChangedEventManager processingUnitInstanceProvisionStatusChangedEventManager;
    private final InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager processingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
    private final InternalElasticAutoScalingProgressChangedEventManager elasticAutoScalingProgressChangedEventManager;
    private final InternalElasticAutoScalingFailureEventManager elasticAutoScalingFailureEventManager;
    private volatile long statisticsInterval = 5000L;
    private volatile int statisticsHistorySize = 120;
    private volatile boolean scheduledStatisticsMonitor = false;
    private Map<String, Integer> plannedNumberOfInstances = new ConcurrentHashMap<String, Integer>();

    public DefaultProcessingUnits(InternalAdmin admin) {
        this.admin = admin;
        this.processingUnitAddedEventManager = new DefaultProcessingUnitAddedEventManager(this);
        this.processingUnitRemovedEventManager = new DefaultProcessingUnitRemovedEventManager(this);
        this.managingGridServiceManagerChangedEventManager = new DefaultManagingGridServiceManagerChangedEventManager(admin);
        this.backupGridServiceManagerChangedEventManager = new DefaultBackupGridServiceManagerChangedEventManager(admin);
        this.processingUnitStatusChangedEventManager = new DefaultProcessingUnitStatusChangedEventManager(admin);
        this.processingUnitInstanceAddedEventManager = new DefaultProcessingUnitInstanceAddedEventManager(this, admin);
        this.processingUnitInstanceRemovedEventManager = new DefaultProcessingUnitInstanceRemovedEventManager(admin);
        this.processingUnitInstanceStatisticsChangedEventManager = new DefaultProcessingUnitInstanceStatisticsChangedEventManager(admin);
        this.processingUnitInstanceProvisionStatusChangedEventManager = new DefaultProcessingUnitInstanceProvisionStatusChangedEventManager(admin);
        this.processingUnitInstanceMemberAliveIndicatorStatusChangedEventManager = new DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager(admin);
        this.elasticAutoScalingProgressChangedEventManager = new DefaultElasticAutoScalingProgressChangedEventManager(admin);
        this.elasticAutoScalingFailureEventManager = new DefaultElasticAutoScalingFailureEventManager(admin);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public ProcessingUnitAddedEventManager getProcessingUnitAdded() {
        return this.processingUnitAddedEventManager;
    }

    @Override
    public ProcessingUnitRemovedEventManager getProcessingUnitRemoved() {
        return this.processingUnitRemovedEventManager;
    }

    @Override
    public ManagingGridServiceManagerChangedEventManager getManagingGridServiceManagerChanged() {
        return this.managingGridServiceManagerChangedEventManager;
    }

    @Override
    public BackupGridServiceManagerChangedEventManager getBackupGridServiceManagerChanged() {
        return this.backupGridServiceManagerChangedEventManager;
    }

    @Override
    public ProcessingUnitStatusChangedEventManager getProcessingUnitStatusChanged() {
        return this.processingUnitStatusChangedEventManager;
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstanceAddedEventManager;
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstanceRemovedEventManager;
    }

    @Override
    public Iterator<ProcessingUnit> iterator() {
        return Collections.unmodifiableCollection(this.processingUnits.values()).iterator();
    }

    @Override
    public ProcessingUnit[] getProcessingUnits() {
        return this.processingUnits.values().toArray(new ProcessingUnit[0]);
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        ArrayList<ProcessingUnitInstance> processingUnitInstances = new ArrayList<ProcessingUnitInstance>();
        for (ProcessingUnit processingUnit : this) {
            for (ProcessingUnitInstance processingUnitInstance : processingUnit) {
                processingUnitInstances.add(processingUnitInstance);
            }
        }
        return processingUnitInstances.toArray(new ProcessingUnitInstance[processingUnitInstances.size()]);
    }

    @Override
    public ProcessingUnit getProcessingUnit(String name) {
        return this.processingUnits.get(name);
    }

    @Override
    public Map<String, ProcessingUnit> getNames() {
        return Collections.unmodifiableMap(this.processingUnits);
    }

    @Override
    public int getSize() {
        return this.processingUnits.size();
    }

    @Override
    public boolean isEmpty() {
        return this.processingUnits.isEmpty();
    }

    @Override
    public ProcessingUnit waitFor(String processingUnitName) {
        return this.waitFor(processingUnitName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingUnit waitFor(final String processingUnitName, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ProcessingUnitAddedEventListener added = new ProcessingUnitAddedEventListener(){

            @Override
            public void processingUnitAdded(ProcessingUnit processingUnit) {
                if (processingUnitName.equals(processingUnit.getName())) {
                    ref.set(processingUnit);
                    latch.countDown();
                }
            }
        };
        this.getProcessingUnitAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            ProcessingUnit processingUnit = (ProcessingUnit)ref.get();
            return processingUnit;
        }
        catch (InterruptedException e) {
            ProcessingUnit processingUnit = null;
            return processingUnit;
        }
        finally {
            this.getProcessingUnitAdded().remove(added);
        }
    }

    @Override
    public void addLifecycleListener(ProcessingUnitLifecycleEventListener eventListener) {
        this.getProcessingUnitAdded().add(eventListener);
        this.getProcessingUnitRemoved().add(eventListener);
        this.getProcessingUnitStatusChanged().add(eventListener);
        this.getManagingGridServiceManagerChanged().add(eventListener);
        this.getBackupGridServiceManagerChanged().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(ProcessingUnitLifecycleEventListener eventListener) {
        this.getProcessingUnitAdded().remove(eventListener);
        this.getProcessingUnitRemoved().remove(eventListener);
        this.getProcessingUnitStatusChanged().remove(eventListener);
        this.getManagingGridServiceManagerChanged().remove(eventListener);
        this.getBackupGridServiceManagerChanged().remove(eventListener);
    }

    @Override
    public void addLifecycleListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.getProcessingUnitInstanceAdded().add(eventListener);
        this.getProcessingUnitInstanceRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.getProcessingUnitInstanceAdded().remove(eventListener);
        this.getProcessingUnitInstanceRemoved().remove(eventListener);
    }

    @Override
    public void addProcessingUnit(final ProcessingUnit processingUnit) {
        this.assertStateChangesPermitted();
        ProcessingUnit existingProcessingUnit = this.processingUnits.put(processingUnit.getName(), processingUnit);
        if (existingProcessingUnit == null) {
            this.processingUnitAddedEventManager.processingUnitAdded(processingUnit);
        }
        processingUnit.setStatisticsInterval(this.statisticsInterval, TimeUnit.MILLISECONDS);
        processingUnit.setStatisticsHistorySize(this.statisticsHistorySize);
        if (this.isMonitoring()) {
            this.admin.raiseEvent(this, new Runnable(){

                @Override
                public void run() {
                    processingUnit.startStatisticsMonitor();
                }
            });
        }
    }

    @Override
    public void removeProcessingUnit(String name) {
        this.assertStateChangesPermitted();
        ProcessingUnit existingProcessingUnit = this.processingUnits.remove(name);
        if (existingProcessingUnit != null) {
            existingProcessingUnit.stopStatisticsMonitor();
            ((InternalProcessingUnit)existingProcessingUnit).setStatus(0);
            this.processingUnitRemovedEventManager.processingUnitRemoved(existingProcessingUnit);
        }
    }

    @Override
    public ProcessingUnitInstanceStatisticsChangedEventManager getProcessingUnitInstanceStatisticsChanged() {
        return this.processingUnitInstanceStatisticsChangedEventManager;
    }

    @Override
    public ProcessingUnitInstanceProvisionStatusChangedEventManager getProcessingUnitInstanceProvisionStatusChanged() {
        return this.processingUnitInstanceProvisionStatusChangedEventManager;
    }

    @Override
    public ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager getProcessingUnitInstanceMemberAliveIndicatorStatusChanged() {
        return this.processingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
    }

    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        this.statisticsInterval = timeUnit.toMillis(interval);
        for (ProcessingUnit processingUnit : this.processingUnits.values()) {
            processingUnit.setStatisticsInterval(this.statisticsInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void setStatisticsHistorySize(int historySize) {
        this.statisticsHistorySize = historySize;
        for (ProcessingUnit processingUnit : this.processingUnits.values()) {
            processingUnit.setStatisticsHistorySize(this.statisticsHistorySize);
        }
    }

    @Override
    public void startStatisticsMonitor() {
        this.scheduledStatisticsMonitor = true;
        for (ProcessingUnit processingUnit : this.processingUnits.values()) {
            processingUnit.startStatisticsMonitor();
        }
    }

    @Override
    public void stopStatisticsMonitor() {
        this.scheduledStatisticsMonitor = false;
        for (ProcessingUnit processingUnit : this.processingUnits.values()) {
            processingUnit.stopStatisticsMonitor();
        }
    }

    @Override
    public boolean isMonitoring() {
        return this.scheduledStatisticsMonitor;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public ElasticAutoScalingProgressChangedEventManager getElasticAutoScalingProgressChanged() {
        return this.elasticAutoScalingProgressChangedEventManager;
    }

    @Override
    public ElasticAutoScalingFailureEventManager getElasticAutoScalingFailure() {
        return this.elasticAutoScalingFailureEventManager;
    }

    @Override
    public void processElasticScaleStrategyEvent(ElasticProcessingUnitEvent event) {
        ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent puEvent;
        if (event instanceof ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent && (puEvent = (ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent)event).getGridServiceAgentZones() == null && puEvent.getProcessingUnitName() != null) {
            int newPlan = puEvent.getNewPlannedNumberOfInstances();
            this.assertStateChangesPermitted();
            this.plannedNumberOfInstances.put(event.getProcessingUnitName(), newPlan);
        }
        if (event instanceof ElasticAutoScalingFailureEvent) {
            this.elasticAutoScalingFailureEventManager.elasticAutoScalingFailure((ElasticAutoScalingFailureEvent)event);
        } else if (event instanceof ElasticAutoScalingProgressChangedEvent) {
            this.elasticAutoScalingProgressChangedEventManager.elasticAutoScalingProgressChanged((ElasticAutoScalingProgressChangedEvent)event);
        }
    }

    @Override
    public ProcessingUnit removeEmbeddedSpace(InternalSpace space) {
        this.assertStateChangesPermitted();
        for (ProcessingUnit pu : this.processingUnits.values()) {
            if (!((InternalProcessingUnit)pu).removeEmbeddedSpace(space)) continue;
            return pu;
        }
        return null;
    }

    @Override
    public Integer getPlannedNumberOfInstancesOfElasticPU(ProcessingUnit pu) {
        return this.plannedNumberOfInstances.get(pu.getName());
    }
}

