/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jini.rio.core.RequiredDependencies;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependency;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDetailedDependencies;
import org.openspaces.admin.internal.pu.dependency.ProcessingUnitDetailedDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.pu.container.support.CommandLineParser;
import org.openspaces.pu.container.support.RequiredDependenciesCommandLineParser;
import org.springframework.util.StringUtils;

public abstract class AbstractProcessingUnitDependencies<T extends ProcessingUnitDependency, IT extends InternalProcessingUnitDependency> {
    private final Map<String, RequiredDependencies> requiredDependeciesPerCommandLineOption = new HashMap<String, RequiredDependencies>();

    protected AbstractProcessingUnitDependencies() {
    }

    public void addDetailedDependenciesByCommandLineOption(String commandLineOption, RequiredDependencies requiredDependencies) {
        if (!requiredDependencies.isEmpty()) {
            RequiredDependencies existingRequiredDependencies = this.requiredDependeciesPerCommandLineOption.get(commandLineOption);
            if (existingRequiredDependencies != null) {
                existingRequiredDependencies.addRequiredDependencies(requiredDependencies);
            } else {
                this.requiredDependeciesPerCommandLineOption.put(commandLineOption, requiredDependencies);
            }
        }
    }

    public void addDetailedDependencies(ProcessingUnitDetailedDependencies<? extends ProcessingUnitDependency> detailedDependencies) {
        InternalProcessingUnitDetailedDependencies internalDependencies = (InternalProcessingUnitDetailedDependencies)detailedDependencies;
        this.addDetailedDependenciesByCommandLineOption(internalDependencies.getCommandLineOption(), internalDependencies.toRequiredDependencies());
    }

    protected void addDetailedAllDependencies(ProcessingUnitDependencies<? extends ProcessingUnitDependency> dependencies) {
        Map<String, RequiredDependencies> map = ((AbstractProcessingUnitDependencies)((Object)dependencies)).requiredDependeciesPerCommandLineOption;
        for (Map.Entry<String, RequiredDependencies> entry : map.entrySet()) {
            this.addDetailedDependenciesByCommandLineOption(entry.getKey(), entry.getValue());
        }
    }

    protected <Z extends InternalProcessingUnitDetailedDependencies<T, IT>> Z getDetailedDependencies(Z newDetailedDependencies) {
        RequiredDependencies requiredDependencies = this.requiredDependeciesPerCommandLineOption.get(newDetailedDependencies.getCommandLineOption());
        if (requiredDependencies != null) {
            newDetailedDependencies.addDependencies(requiredDependencies);
        }
        return newDetailedDependencies;
    }

    protected <Z extends InternalProcessingUnitDetailedDependencies<T, IT>> void setDetailedDependencies(Z newDetailedDependencies) {
        this.requiredDependeciesPerCommandLineOption.put(newDetailedDependencies.getCommandLineOption(), newDetailedDependencies.toRequiredDependencies());
    }

    public CommandLineParser.Parameter[] toCommandLineParameters() {
        ArrayList<CommandLineParser.Parameter> parameters = new ArrayList<CommandLineParser.Parameter>();
        for (Map.Entry<String, RequiredDependencies> entry : this.requiredDependeciesPerCommandLineOption.entrySet()) {
            RequiredDependencies requiredDependencies = entry.getValue();
            if (requiredDependencies.isEmpty()) continue;
            String commandLineOption = entry.getKey();
            CommandLineParser.Parameter parameter = RequiredDependenciesCommandLineParser.convertRequiredDependenciesToCommandLineParameter(commandLineOption, requiredDependencies);
            parameters.add(parameter);
        }
        return parameters.toArray(new CommandLineParser.Parameter[parameters.size()]);
    }

    public String[] getDependenciesRequiredProcessingUnitNames() {
        ArrayList<String> requiredProcessingUnitNames = new ArrayList<String>();
        for (RequiredDependencies requiredDependencies : this.requiredDependeciesPerCommandLineOption.values()) {
            for (String requiredProcessingUnitName : requiredDependencies.getRequiredDependenciesNames()) {
                if (requiredProcessingUnitNames.contains(requiredProcessingUnitName)) continue;
                requiredProcessingUnitNames.add(requiredProcessingUnitName);
            }
        }
        return requiredProcessingUnitNames.toArray(new String[requiredProcessingUnitNames.size()]);
    }

    public String toString() {
        ArrayList<String> commandline = new ArrayList<String>();
        for (Map.Entry<String, RequiredDependencies> entry : this.requiredDependeciesPerCommandLineOption.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            CommandLineParser.Parameter parameter = RequiredDependenciesCommandLineParser.convertRequiredDependenciesToCommandLineParameter(entry.getKey(), entry.getValue());
            commandline.add("-" + parameter.getName());
            commandline.addAll(Arrays.asList(parameter.getArguments()));
        }
        return StringUtils.collectionToDelimitedString(commandline, (String)" ");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requiredDependeciesPerCommandLineOption == null ? 0 : this.requiredDependeciesPerCommandLineOption.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProcessingUnitDependencies other = (AbstractProcessingUnitDependencies)obj;
        return !(this.requiredDependeciesPerCommandLineOption == null ? other.requiredDependeciesPerCommandLineOption != null : !this.requiredDependeciesPerCommandLineOption.equals(other.requiredDependeciesPerCommandLineOption));
    }
}

