/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.dependency;

import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependency;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencyFactory;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDetailedDependencies;
import org.openspaces.admin.internal.pu.dependency.ProcessingUnitDetailedDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;

public abstract class AbstractProcessingUnitDependenciesConfigurer<T extends ProcessingUnitDependency, IT extends InternalProcessingUnitDependency, S extends ProcessingUnitDetailedDependencies<T>, IS extends InternalProcessingUnitDetailedDependencies<T, IT>> {
    private final IS dependencies;
    private final InternalProcessingUnitDependencyFactory<IT> dependencyFactory;

    public AbstractProcessingUnitDependenciesConfigurer(InternalProcessingUnitDependencyFactory<IT> dependencyFactory, IS dependencies) {
        this.dependencyFactory = dependencyFactory;
        this.dependencies = dependencies;
    }

    public S create() {
        return (S)this.dependencies;
    }

    public AbstractProcessingUnitDependenciesConfigurer<T, IT, S, IS> dependsOnMinimumNumberOfDeployedInstances(String requiredProcessingUnitName, int minimumNumberOfDeployedInstances) {
        IT dependency = this.createDependency(requiredProcessingUnitName);
        dependency.setMinimumNumberOfDeployedInstances(minimumNumberOfDeployedInstances);
        this.addDependency(dependency);
        return this;
    }

    public AbstractProcessingUnitDependenciesConfigurer<T, IT, S, IS> dependsOnMinimumNumberOfDeployedInstancesPerPartition(String requiredProcessingUnitName, int minimumNumberOfDeployedInstances) {
        IT dependency = this.createDependency(requiredProcessingUnitName);
        dependency.setMinimumNumberOfDeployedInstancesPerPartition(minimumNumberOfDeployedInstances);
        this.addDependency(dependency);
        return this;
    }

    public AbstractProcessingUnitDependenciesConfigurer<T, IT, S, IS> dependsOnDeployed(String requiredProcessingUnitName) {
        IT dependency = this.createDependency(requiredProcessingUnitName);
        dependency.setWaitForDeploymentToComplete(true);
        this.addDependency(dependency);
        return this;
    }

    protected IT createDependency(String requiredProcessingUnitName) {
        return this.dependencyFactory.create(requiredProcessingUnitName);
    }

    protected void addDependency(IT dependency) {
        this.dependencies.addDependency(dependency);
    }
}

