/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.dependency;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jini.rio.core.RequiredDependencies;
import org.jini.rio.core.RequiredDependency;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependency;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencyFactory;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDetailedDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;

public abstract class AbstractProcessingUnitDetailedDependencies<T extends ProcessingUnitDependency, IT extends InternalProcessingUnitDependency>
implements InternalProcessingUnitDetailedDependencies<T, IT> {
    private final List<IT> deploymentDependencies = new LinkedList<IT>();
    private final InternalProcessingUnitDependencyFactory<IT> dependencyFactory;

    public AbstractProcessingUnitDetailedDependencies(InternalProcessingUnitDependencyFactory<IT> dependencyFactory) {
        this.dependencyFactory = dependencyFactory;
    }

    @Override
    public boolean isEmpty() {
        return this.deploymentDependencies.isEmpty();
    }

    @Override
    public String[] getRequiredProcessingUnitsNames() {
        ArrayList<String> names = new ArrayList<String>(this.deploymentDependencies.size());
        for (InternalProcessingUnitDependency dependency : this.deploymentDependencies) {
            names.add(dependency.getRequiredProcessingUnitName());
        }
        return names.toArray(new String[this.deploymentDependencies.size()]);
    }

    @Override
    public void addDependency(T newDependency) {
        String requiredProcessingUnitName = newDependency.getRequiredProcessingUnitName();
        InternalProcessingUnitDependency existingDependency = (InternalProcessingUnitDependency)this.getDependencyByName(requiredProcessingUnitName);
        if (existingDependency != null) {
            existingDependency.mergeDependency((ProcessingUnitDependency)newDependency);
        } else {
            this.deploymentDependencies.add((InternalProcessingUnitDependency)newDependency);
        }
    }

    @Override
    public T getDependencyByName(String requiredProcessingUnitName) {
        for (InternalProcessingUnitDependency dependency : this.deploymentDependencies) {
            if (!requiredProcessingUnitName.equals(dependency.getRequiredProcessingUnitName())) continue;
            return (T)dependency;
        }
        return null;
    }

    @Override
    public RequiredDependencies toRequiredDependencies() {
        RequiredDependencies requiredDependencies = new RequiredDependencies();
        for (InternalProcessingUnitDependency dependency : this.deploymentDependencies) {
            requiredDependencies.addRequiredDependency(dependency.toRequiredDependency());
        }
        return requiredDependencies;
    }

    @Override
    public void addDependencies(RequiredDependencies requiredDependencies) {
        for (String requiredDependencyName : requiredDependencies.getRequiredDependenciesNames()) {
            RequiredDependency requiredDependency = requiredDependencies.getRequiredDependencyByName(requiredDependencyName);
            IT dependency = this.dependencyFactory.create(requiredDependency.getRequiredProcessingUnitName());
            dependency.mergeDependency(requiredDependency);
            this.addDependency(dependency);
        }
    }
}

