/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.elastic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.bean.BeanConfigNotFoundException;
import org.openspaces.admin.bean.BeanConfigPropertiesManager;
import org.openspaces.admin.bean.EnabledBeanConfigCannotBeChangedException;
import org.openspaces.core.util.StringProperties;

public class FlattenedBeanConfigPropertiesManager
implements BeanConfigPropertiesManager {
    private final StringProperties properties;
    private final String enabledClassnameKey;
    private final String classnamesKey;

    public FlattenedBeanConfigPropertiesManager(String classnamesKey, String enabledClassnameKey, Map<String, String> properties) {
        this.properties = new StringProperties(properties);
        this.enabledClassnameKey = enabledClassnameKey;
        this.classnamesKey = classnamesKey;
    }

    @Override
    public void setBeanConfig(String beanClassName, Map<String, String> properties) throws BeanConfigNotFoundException {
        if (this.isBeanEnabled(beanClassName)) {
            throw new EnabledBeanConfigCannotBeChangedException("Cannot modify bean [" + beanClassName + "] configuration while it is enabled. Disable it first.");
        }
        this.properties.putMap(this.getKeyPrefix(beanClassName), properties);
        this.addBeanInternal(beanClassName);
    }

    @Override
    public void enableBean(String beanClassName) throws BeanConfigNotFoundException {
        this.properties.putArray(this.enabledClassnameKey, new String[]{beanClassName}, ",");
    }

    @Override
    public void disableBean(String beanClassName) throws BeanConfigNotFoundException {
        ArrayList<String> enabled = new ArrayList<String>(Arrays.asList(this.getEnabledBeansClassNames()));
        if (enabled.contains(beanClassName)) {
            enabled.remove(beanClassName);
            this.properties.putArray(this.enabledClassnameKey, enabled.toArray(new String[0]), ",");
        }
    }

    @Override
    public boolean removeBeanConfig(String beanClassName) {
        if (this.isBeanEnabled(beanClassName)) {
            throw new EnabledBeanConfigCannotBeChangedException("Cannot remove configuration of beanClassName " + beanClassName + " since it is enabled. disable it first.");
        }
        boolean removed = false;
        if (this.containsBeanInternal(beanClassName)) {
            removed = this.removeBeanInternal(beanClassName);
        }
        return removed;
    }

    @Override
    public boolean isBeanEnabled(String beanClassName) {
        return Arrays.asList(this.getEnabledBeansClassNames()).contains(beanClassName);
    }

    @Override
    public String[] getEnabledBeansClassNames() {
        return this.properties.getArray(this.enabledClassnameKey, ",", new String[0]);
    }

    @Override
    public Map<String, String> getBeanConfig(String beanClassName) throws BeanConfigNotFoundException {
        return this.properties.getMap(this.getKeyPrefix(beanClassName), new HashMap());
    }

    private String getKeyPrefix(String beanClassName) {
        return beanClassName + ".";
    }

    @Override
    public String[] getBeansClassNames() {
        return this.properties.getArray(this.classnamesKey, ",", new String[0]);
    }

    @Override
    public void disableAllBeans() {
        this.properties.remove(this.enabledClassnameKey);
    }

    private void addBeanInternal(String beanClassName) {
        ArrayList<String> beanList = new ArrayList<String>(Arrays.asList(this.getBeansClassNames()));
        if (!beanList.contains(beanClassName)) {
            beanList.add(beanClassName);
            this.properties.putArray(this.enabledClassnameKey, beanList.toArray(new String[0]), ",");
        }
    }

    private boolean removeBeanInternal(String beanClassName) {
        boolean removed = false;
        ArrayList<String> beanList = new ArrayList<String>(Arrays.asList(this.getBeansClassNames()));
        if (beanList.contains(beanClassName)) {
            beanList.remove(beanClassName);
            this.properties.putArray(this.enabledClassnameKey, beanList.toArray(new String[0]), ",");
            removed = true;
        }
        return removed;
    }

    private boolean containsBeanInternal(String beanClassName) {
        return Arrays.asList(this.getEnabledBeansClassNames()).contains(beanClassName);
    }

    protected StringProperties getProperties() {
        return this.properties;
    }
}

