/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.elastic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.core.util.StringProperties;

public class GridServiceAgentFailureDetectionConfig {
    private static final String DISABLED_FAILURE_DETECTION_KEY = "agent.disabled-failure-detection.";
    StringProperties properties;

    public GridServiceAgentFailureDetectionConfig(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    private Map<String, String> getDisabledFailureDetection() {
        return this.properties.getMap(DISABLED_FAILURE_DETECTION_KEY, null);
    }

    private void setDisabledFailureDetection(Map<String, String> disabledFailureDetection) {
        this.properties.putMap(DISABLED_FAILURE_DETECTION_KEY, disabledFailureDetection);
    }

    public void disableFailureDetection(String ipAddress, long expireTimestamp) {
        Map<String, String> ipAddresses = this.getDisabledFailureDetection();
        if (ipAddresses == null) {
            ipAddresses = new HashMap<String, String>();
        }
        ipAddresses.put(ipAddress, String.valueOf(expireTimestamp));
        this.setDisabledFailureDetection(ipAddresses);
    }

    public void enableFailureDetection(String ipAddress) {
        this.disableFailureDetection(ipAddress, 0L);
    }

    public FailureDetectionStatus getFailureDetectionStatus(String ipAddress, long now) {
        String value;
        Map<String, String> disabledFailureDetection = this.getDisabledFailureDetection();
        String string = value = disabledFailureDetection != null ? disabledFailureDetection.get(ipAddress) : null;
        if (value == null) {
            return FailureDetectionStatus.DONT_CARE;
        }
        Long expireTimestamp = Long.valueOf(value);
        if (now < expireTimestamp) {
            return FailureDetectionStatus.DISABLE_FAILURE_DETECTION;
        }
        return FailureDetectionStatus.ENABLE_FAILURE_DETECTION;
    }

    public Set<String> getFailureDetectionIpAddresses() {
        Map<String, String> disabledFailureDetection = this.getDisabledFailureDetection();
        return disabledFailureDetection != null ? disabledFailureDetection.keySet() : Collections.EMPTY_SET;
    }

    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridServiceContainerConfig other = (GridServiceContainerConfig)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals((Object)other.properties));
    }

    public static enum FailureDetectionStatus {
        DISABLE_FAILURE_DETECTION,
        ENABLE_FAILURE_DETECTION,
        DONT_CARE;

    }
}

