/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.elastic;

import com.gigaspaces.grid.gsa.GSProcessOptions;
import com.gigaspaces.grid.gsa.GSProcessRestartOnExit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.core.util.MemoryUnit;
import org.openspaces.core.util.StringProperties;

public class GridServiceContainerConfig {
    private static final String ENVIRONMENT_VARIABLES_KEY = "container.environmentVariables.";
    private static final HashMap<String, String> ENVIRONMENT_VARIABLES_DEFAULT = new HashMap();
    private static final String OVERRIDE_COMMAND_LINE_ARGUMENTS_KEY = "container.override-commandline-arguments";
    private static final boolean OVERRIDE_COMMAND_LINE_ARGUMENTS_DEFAULT = false;
    private static final String COMMAND_LINE_ARGUMENTS_KEY = "container.commandline-arguments";
    private static final String[] COMMAND_LINE_ARGUMENTS_DEFAULT = new String[0];
    private static final String USE_SCRIPT_KEY = "container.use-script";
    private static final boolean USE_SCRIPT_DEFAULT = false;
    private static final String MAXIMUM_MEMORY_CAPACITY_MEGABYTES_KEY = "container.memory-capacity";
    private static final Long MAXIMUM_MEMORY_CAPACITY_MEGABYTES_DEFAULT = 0L;
    private static final String RESTART_ON_EXIT_KEY = "restart-on-exit";
    StringProperties properties;

    public GridServiceContainerConfig(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    public boolean getUseScript() {
        return this.properties.getBoolean(USE_SCRIPT_KEY, false);
    }

    public void setUseScript(boolean useScript) {
        this.properties.putBoolean(USE_SCRIPT_KEY, useScript);
    }

    public String[] getCommandLineArguments() {
        return this.properties.getArgumentsArray(COMMAND_LINE_ARGUMENTS_KEY, COMMAND_LINE_ARGUMENTS_DEFAULT);
    }

    public void setCommandLineArguments(String[] commandLineArguments) {
        this.properties.putArgumentsArray(COMMAND_LINE_ARGUMENTS_KEY, commandLineArguments);
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.properties.getMap(ENVIRONMENT_VARIABLES_KEY, ENVIRONMENT_VARIABLES_DEFAULT);
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.properties.putMap(ENVIRONMENT_VARIABLES_KEY, environmentVariables);
    }

    public boolean getOverrideCommandLineArguments() {
        return this.properties.getBoolean(OVERRIDE_COMMAND_LINE_ARGUMENTS_KEY, false);
    }

    public void setOverrideCommandLineArguments(boolean overrideCommandLineArguments) {
        this.properties.putBoolean(OVERRIDE_COMMAND_LINE_ARGUMENTS_KEY, overrideCommandLineArguments);
    }

    public long getMaximumJavaHeapSizeInMB() {
        long memoryInMB = MAXIMUM_MEMORY_CAPACITY_MEGABYTES_DEFAULT;
        String memory = this.getCommandLineArgumentIfExists("-Xmx");
        if (memory != null) {
            memoryInMB = MemoryUnit.toMegaBytes((String)memory);
        }
        return memoryInMB;
    }

    public long getMinimumJavaHeapSizeInMB() {
        long memoryInMB = 0L;
        String memory = this.getCommandLineArgumentIfExists("-Xms");
        if (memory != null) {
            memoryInMB = MemoryUnit.toMegaBytes((String)memory);
        }
        return memoryInMB;
    }

    public void addMaximumJavaHeapSizeInMBCommandLineArgument(long maximumMemoryCapacityInMB) {
        this.addCommandLineArgument("-Xmx" + maximumMemoryCapacityInMB + MemoryUnit.MEGABYTES.getPostfix());
    }

    public void addMinimumJavaHeapSizeInMBCommandLineArgument(long minimumMemoryCapacityInMB) {
        this.addCommandLineArgument("-Xms" + minimumMemoryCapacityInMB + MemoryUnit.MEGABYTES.getPostfix());
    }

    public long getMaximumMemoryCapacityInMB() {
        return this.properties.getLong(MAXIMUM_MEMORY_CAPACITY_MEGABYTES_KEY, MAXIMUM_MEMORY_CAPACITY_MEGABYTES_DEFAULT.longValue());
    }

    public void setMaximumMemoryCapacityInMB(long memoryInMB) {
        this.properties.putLong(MAXIMUM_MEMORY_CAPACITY_MEGABYTES_KEY, memoryInMB);
    }

    public String[] getZones() {
        return this.getEnvironmentVariableIfExists("com.gs.zones").split(",");
    }

    private String getEnvironmentVariableIfExists(String name) {
        String value = this.getCommandLineArgumentIfExists("-D" + name + "=");
        if (value == null) {
            value = this.getEnvironmentVariables().get(name);
        }
        return value;
    }

    private String getCommandLineArgumentIfExists(String prefix) {
        String requiredArg = null;
        for (String arg : this.getCommandLineArguments()) {
            if (!arg.startsWith(prefix)) continue;
            requiredArg = arg;
        }
        if (requiredArg != null) {
            requiredArg = requiredArg.substring(prefix.length());
        }
        return requiredArg;
    }

    public void addCommandLineArgument(String argument) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(Arrays.asList(this.getCommandLineArguments()));
        arguments.add(argument);
        this.setCommandLineArguments(arguments.toArray(new String[0]));
    }

    public void setEnvironmentVariable(String name, String value) {
        Map<String, String> environmentVariables = this.getEnvironmentVariables();
        environmentVariables.put(name, value);
        this.setEnvironmentVariables(environmentVariables);
    }

    public GSProcessRestartOnExit getRestartOnExit() {
        GSProcessRestartOnExit restartOnExit = null;
        String value = this.properties.get(RESTART_ON_EXIT_KEY);
        if (value != null) {
            restartOnExit = GSProcessRestartOnExit.valueOf((String)value);
        }
        return restartOnExit;
    }

    public void setRestartOnExit(GSProcessRestartOnExit restartOnExit) {
        this.properties.put(RESTART_ON_EXIT_KEY, restartOnExit.toString());
    }

    public GSProcessOptions getOptions() {
        GSProcessOptions options = new GSProcessOptions("gsc");
        options.setUseScript(this.getUseScript());
        if (this.getOverrideCommandLineArguments()) {
            options.setVmInputArguments(this.getCommandLineArguments());
        } else {
            options.setVmAppendableInputArguments(this.getCommandLineArguments());
        }
        options.setEnvironmentVariables(this.getEnvironmentVariables());
        options.setRestartOnExit(this.getRestartOnExit());
        return options;
    }

    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridServiceContainerConfig other = (GridServiceContainerConfig)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals((Object)other.properties));
    }
}

