/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.elastic;

import java.util.Map;
import org.openspaces.core.util.StringProperties;

public class ProcessingUnitSchemaConfig {
    private static final String ASYNC_REPLICATED_SCHEMA = "async_replicated";
    private static final String SYNC_REPLICATED_SCHEMA = "sync_replicated";
    private static final String PARTITIONED = "partitioned";
    private static final String SCHEMA_KEY = "schema";
    private static final String DEFAULT_SCHEMA = "default";
    private StringProperties elasticProperties;

    public ProcessingUnitSchemaConfig(Map<String, String> elasticProperties) {
        this.elasticProperties = new StringProperties(elasticProperties);
    }

    public boolean isPartitionedSchema() {
        return this.isSchema(PARTITIONED) || this.isSchema("partitioned-sync2backup");
    }

    @Deprecated
    public boolean isPartitionedSync2BackupSchema() {
        return this.isPartitionedSchema();
    }

    public void setDefaultSchema() {
        this.setSchema(DEFAULT_SCHEMA);
    }

    public boolean isDefaultSchema() {
        return this.isSchema(DEFAULT_SCHEMA);
    }

    public void setPartitionedSchema() {
        this.setSchema(PARTITIONED);
    }

    @Deprecated
    public void setPartitionedSync2BackupSchema() {
        this.setPartitionedSchema();
    }

    public void setAsyncReplicatedSchema() {
        this.setSchema(ASYNC_REPLICATED_SCHEMA);
    }

    public boolean isAsyncReplicatedSchema() {
        return this.isSchema(ASYNC_REPLICATED_SCHEMA);
    }

    public boolean isSyncReplicatedSchema() {
        return this.isSchema(SYNC_REPLICATED_SCHEMA);
    }

    public void setSyncReplicatedSchema() {
        this.setSchema(SYNC_REPLICATED_SCHEMA);
    }

    private void setSchema(String schema) {
        this.elasticProperties.put(SCHEMA_KEY, schema);
    }

    private boolean isSchema(String schema) {
        return schema.equals(this.getSchema());
    }

    public String getSchema() {
        return this.elasticProperties.get(SCHEMA_KEY, DEFAULT_SCHEMA);
    }
}

