/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.elastic.config;

import com.gigaspaces.grid.gsa.GSProcessRestartOnExit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.openspaces.admin.bean.BeanConfig;
import org.openspaces.admin.bean.BeanConfigPropertiesManager;
import org.openspaces.admin.internal.pu.dependency.DefaultProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.DefaultProcessingUnitDeploymentDependencies;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.elastic.ElasticMachineIsolationConfig;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.internal.pu.elastic.MachineProvisioningBeanPropertiesManager;
import org.openspaces.admin.internal.pu.elastic.ScaleStrategyBeanPropertiesManager;
import org.openspaces.admin.pu.config.ProcessingUnitConfig;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.elastic.ElasticMachineProvisioningConfig;
import org.openspaces.admin.pu.elastic.config.DiscoveredMachineProvisioningConfig;
import org.openspaces.admin.pu.elastic.config.EagerScaleConfig;
import org.openspaces.admin.pu.elastic.config.ManualCapacityScaleConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;

@Deprecated
public class AbstractElasticProcessingUnitConfig {
    private String processingUnit;
    private String name;
    private Map<String, String> contextProperties = new HashMap<String, String>();
    private Map<String, String> defaultContextProperties = new HashMap<String, String>();
    private UserDetailsConfig userDetails;
    private Boolean secured;
    private Map<String, String> elasticProperties = new HashMap<String, String>();
    private ProcessingUnitDependencies<ProcessingUnitDependency> dependencies = new DefaultProcessingUnitDependencies();
    private ElasticMachineProvisioningConfig machineProvisioning;
    private ScaleStrategyConfig scaleStrategy;

    private GridServiceContainerConfig getGridServiceContainerConfig() {
        return new GridServiceContainerConfig(this.getElasticProperties());
    }

    private ElasticMachineIsolationConfig getElasticMachineIsolationConfig() {
        return new ElasticMachineIsolationConfig(this.getElasticProperties());
    }

    private MachineProvisioningBeanPropertiesManager getMachineProvisioningBeanPropertiesManager() {
        return new MachineProvisioningBeanPropertiesManager(this.getElasticProperties());
    }

    private ScaleStrategyBeanPropertiesManager getScaleStrategyBeanPropertiesManager() {
        return new ScaleStrategyBeanPropertiesManager(this.getElasticProperties());
    }

    public String getProcessingUnit() {
        return this.processingUnit;
    }

    public void setProcessingUnit(String processingUnit) {
        this.processingUnit = processingUnit;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map<String, String> contextProperties) {
        this.contextProperties = contextProperties;
    }

    protected void addContextProperty(String key, String value) {
        this.contextProperties.put(key, value);
    }

    protected void addContextPropertyDefault(String key, String value) {
        this.defaultContextProperties.put(key, value);
    }

    public Map<String, String> getDefaultContextProperties() {
        return this.defaultContextProperties;
    }

    public void setDefaultContextProperties(Map<String, String> defaultContextProperties) {
        this.defaultContextProperties = defaultContextProperties;
    }

    public UserDetailsConfig getUserDetails() {
        return this.userDetails;
    }

    public void setUserDetails(UserDetailsConfig userDetails) {
        this.userDetails = userDetails;
    }

    public Boolean getSecured() {
        return this.secured;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public Map<String, String> getElasticProperties() {
        return this.elasticProperties;
    }

    @XmlTransient
    public void setElasticProperties(Map<String, String> elasticProperties) {
        this.elasticProperties = elasticProperties;
    }

    public void setUseScript(boolean useScript) {
        this.getGridServiceContainerConfig().setUseScript(useScript);
    }

    public boolean getUseScript() {
        return this.getGridServiceContainerConfig().getUseScript();
    }

    public void setOverrideCommandLineArguments(boolean overrideCommandLineArguments) {
        this.getGridServiceContainerConfig().setOverrideCommandLineArguments(overrideCommandLineArguments);
    }

    public boolean getOverrideCommandLineArguments() {
        return this.getGridServiceContainerConfig().getOverrideCommandLineArguments();
    }

    public void setMemoryCapacityPerContainerInMB(long memoryInMB) {
        this.getGridServiceContainerConfig().setMaximumMemoryCapacityInMB(memoryInMB);
    }

    public long getMemoryCapacityPerContainerInMB() {
        return this.getGridServiceContainerConfig().getMaximumMemoryCapacityInMB();
    }

    public String[] getCommandLineArguments() {
        return this.getGridServiceContainerConfig().getCommandLineArguments();
    }

    public void setCommandLineArguments(String[] commandLineArguments) {
        this.getGridServiceContainerConfig().setCommandLineArguments(commandLineArguments);
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.getGridServiceContainerConfig().getEnvironmentVariables();
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.getGridServiceContainerConfig().setEnvironmentVariables(environmentVariables);
    }

    @XmlTransient
    public void setDedicatedIsolation() {
        this.getElasticMachineIsolationConfig().setDedicated();
    }

    public void setPublicIsolation() {
        this.getElasticMachineIsolationConfig().setPublic();
    }

    public boolean getDedicatedIsolationConfig() {
        return this.getElasticMachineIsolationConfig().isDedicatedIsolation();
    }

    public boolean getPublicIsolationConfig() {
        return this.getElasticMachineIsolationConfig().isPublicMachineIsolation();
    }

    public void setSharedIsolation(String sharingId) {
        this.getElasticMachineIsolationConfig().setSharingId(sharingId);
    }

    public String getSharedIsolation() {
        return this.getElasticMachineIsolationConfig().getSharingId();
    }

    public ElasticMachineProvisioningConfig getMachineProvisioning() {
        return this.machineProvisioning;
    }

    @XmlTransient
    public void setMachineProvisioning(ElasticMachineProvisioningConfig machineProvisioningConfig) {
        if ((machineProvisioningConfig.getGridServiceAgentZones() == null || machineProvisioningConfig.getGridServiceAgentZones().getZones().isEmpty()) && machineProvisioningConfig.isGridServiceAgentZoneMandatory()) {
            throw new IllegalArgumentException("isGridServiceAgentZoneMandatory returns true, but no Grid Service Agent zone is specified.");
        }
        this.machineProvisioning = machineProvisioningConfig;
    }

    public ProcessingUnitConfig toProcessingUnitConfig() {
        GridServiceContainerConfig containerConfig = this.getGridServiceContainerConfig();
        if (containerConfig.getMaximumMemoryCapacityInMB() <= 0L && containerConfig.getMaximumJavaHeapSizeInMB() <= 0L) {
            throw new IllegalArgumentException("maximumMemoryCapacity or Xmx commandline must be defined.");
        }
        if (containerConfig.getMaximumMemoryCapacityInMB() <= 0L && containerConfig.getMaximumJavaHeapSizeInMB() > 0L) {
            containerConfig.setMaximumMemoryCapacityInMB(containerConfig.getMaximumJavaHeapSizeInMB());
        } else if (containerConfig.getMaximumMemoryCapacityInMB() > 0L && containerConfig.getMaximumJavaHeapSizeInMB() <= 0L) {
            containerConfig.addMaximumJavaHeapSizeInMBCommandLineArgument(containerConfig.getMaximumMemoryCapacityInMB());
        } else if (containerConfig.getMaximumMemoryCapacityInMB() < containerConfig.getMaximumJavaHeapSizeInMB()) {
            throw new IllegalArgumentException("maximumMemoryCapacity cannot be less than Xmx commandline argument.");
        }
        if (containerConfig.getMinimumJavaHeapSizeInMB() <= 0L) {
            containerConfig.addMinimumJavaHeapSizeInMBCommandLineArgument(containerConfig.getMaximumJavaHeapSizeInMB());
        } else if (containerConfig.getMinimumJavaHeapSizeInMB() > containerConfig.getMaximumJavaHeapSizeInMB()) {
            throw new IllegalArgumentException("Xmx commandline argument " + containerConfig.getMaximumJavaHeapSizeInMB() + "MB cannot be less than Xms commandline argument " + containerConfig.getMinimumJavaHeapSizeInMB() + "MB.");
        }
        containerConfig.setRestartOnExit(GSProcessRestartOnExit.NEVER);
        if (this.machineProvisioning == null) {
            this.machineProvisioning = new DiscoveredMachineProvisioningConfig();
        }
        if (this.scaleStrategy == null) {
            this.scaleStrategy = new ManualCapacityScaleConfig();
        }
        if (this.machineProvisioning instanceof EagerScaleConfig && !(this.scaleStrategy instanceof DiscoveredMachineProvisioningConfig)) {
            throw new IllegalArgumentException("Eager scale does not support " + this.machineProvisioning.getClass() + " machine provisioning. Remove machineProvisioning or use DiscoveredMachineProvisioningConfig() instead.");
        }
        AbstractElasticProcessingUnitConfig.enableBean(this.getMachineProvisioningBeanPropertiesManager(), this.machineProvisioning);
        AbstractElasticProcessingUnitConfig.enableBean(this.getScaleStrategyBeanPropertiesManager(), this.scaleStrategy);
        ProcessingUnitConfig config = new ProcessingUnitConfig();
        config.setProcessingUnit(this.processingUnit);
        if (this.name != null) {
            config.setName(this.name);
        }
        if (this.secured != null) {
            config.setSecured(this.secured);
        }
        if (this.userDetails != null) {
            config.setUserDetails(this.userDetails);
        }
        String containerZone = this.getDefaultZone();
        this.addCommandLineArgument("-Dcom.gs.zones=" + containerZone);
        config.setZones(new String[]{containerZone});
        Map<String, String> mergedContextProperties = this.defaultContextProperties;
        mergedContextProperties.putAll(this.contextProperties);
        config.setContextProperties(mergedContextProperties);
        config.setElasticProperties(this.elasticProperties);
        config.setDependencies(this.dependencies);
        return config;
    }

    public void setScaleStrategy(ScaleStrategyConfig scaleStrategy) {
        this.scaleStrategy = scaleStrategy;
    }

    public ScaleStrategyConfig getScaleStrategy() {
        return this.scaleStrategy;
    }

    private String getDefaultZone() {
        String zone = this.getName();
        if (zone == null) {
            int seperatorIndex;
            zone = this.getProcessingUnit();
            if (zone.endsWith("/") || zone.endsWith("\\")) {
                zone = zone.substring(0, zone.length() - 1);
            }
            if ((seperatorIndex = Math.max(zone.lastIndexOf("/"), zone.lastIndexOf("\\"))) >= 0 && seperatorIndex < zone.length() - 1) {
                zone = zone.substring(seperatorIndex + 1, zone.length());
            }
            if (zone.endsWith(".zip") || zone.endsWith(".jar") || zone.endsWith(".war")) {
                zone = zone.substring(0, zone.length() - 4);
            }
        }
        zone = zone.replace(' ', '_');
        return zone;
    }

    public void addCommandLineArgument(String argument) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(this.getCommandLineArguments()));
        arguments.add(argument);
        this.setCommandLineArguments(arguments.toArray(new String[arguments.size()]));
    }

    private static void enableBean(BeanConfigPropertiesManager propertiesManager, BeanConfig config) {
        propertiesManager.disableAllBeans();
        propertiesManager.setBeanConfig(config.getBeanClassName(), config.getProperties());
        propertiesManager.enableBean(config.getBeanClassName());
    }

    public ProcessingUnitDependencies<ProcessingUnitDependency> getDependencies() {
        return this.dependencies;
    }

    @XmlTransient
    public void setDependencies(ProcessingUnitDependencies<ProcessingUnitDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setDeploymentDependencies(ProcessingUnitDependency[] dependencies) {
        DefaultProcessingUnitDeploymentDependencies deploymentDependencies = new DefaultProcessingUnitDeploymentDependencies();
        for (ProcessingUnitDependency dependency : dependencies) {
            deploymentDependencies.addDependency(dependency);
        }
        ((InternalProcessingUnitDependencies)this.getDependencies()).setDeploymentDependencies(deploymentDependencies);
    }

    public ProcessingUnitDependency[] getDeploymentDependencies() {
        ArrayList dependenciesAsList = new ArrayList();
        for (String name : this.getDependencies().getDeploymentDependencies().getRequiredProcessingUnitsNames()) {
            dependenciesAsList.add(this.getDependencies().getDeploymentDependencies().getDependencyByName(name));
        }
        return dependenciesAsList.toArray(new ProcessingUnitDependency[dependenciesAsList.size()]);
    }
}

