/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.events.ClosureBackupGridServiceManagerChangedEventListener;
import org.openspaces.admin.internal.pu.events.InternalBackupGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.events.BackupGridServiceManagerChangedEvent;
import org.openspaces.admin.pu.events.BackupGridServiceManagerChangedEventListener;

public class DefaultBackupGridServiceManagerChangedEventManager
implements InternalBackupGridServiceManagerChangedEventManager {
    private final InternalAdmin admin;
    private final List<BackupGridServiceManagerChangedEventListener> listeners = new CopyOnWriteArrayList<BackupGridServiceManagerChangedEventListener>();
    private final ProcessingUnit processingUnit;

    public DefaultBackupGridServiceManagerChangedEventManager(InternalAdmin admin) {
        this(admin, null);
    }

    public DefaultBackupGridServiceManagerChangedEventManager(InternalAdmin admin, ProcessingUnit processingUnit) {
        this.admin = admin;
        this.processingUnit = processingUnit;
    }

    @Override
    public void processingUnitBackupGridServiceManagerChanged(final BackupGridServiceManagerChangedEvent event) {
        for (final BackupGridServiceManagerChangedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitBackupGridServiceManagerChanged(event);
                }
            });
        }
    }

    @Override
    public void add(BackupGridServiceManagerChangedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final BackupGridServiceManagerChangedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    if (DefaultBackupGridServiceManagerChangedEventManager.this.processingUnit == null) {
                        for (ProcessingUnit pu : DefaultBackupGridServiceManagerChangedEventManager.this.admin.getProcessingUnits()) {
                            for (GridServiceManager backupGsm : pu.getBackupGridServiceManagers()) {
                                eventListener.processingUnitBackupGridServiceManagerChanged(new BackupGridServiceManagerChangedEvent(pu, BackupGridServiceManagerChangedEvent.Type.ADDED, backupGsm));
                            }
                        }
                    } else {
                        for (GridServiceManager backupGsm : DefaultBackupGridServiceManagerChangedEventManager.this.processingUnit.getBackupGridServiceManagers()) {
                            eventListener.processingUnitBackupGridServiceManagerChanged(new BackupGridServiceManagerChangedEvent(DefaultBackupGridServiceManagerChangedEventManager.this.processingUnit, BackupGridServiceManagerChangedEvent.Type.ADDED, backupGsm));
                        }
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(BackupGridServiceManagerChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureBackupGridServiceManagerChangedEventListener(eventListener));
        } else {
            this.add((BackupGridServiceManagerChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureBackupGridServiceManagerChangedEventListener(eventListener));
        } else {
            this.remove((BackupGridServiceManagerChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

