/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.DefaultProcessingUnit;
import org.openspaces.admin.internal.pu.events.ClosureManagingGridServiceManagerChangedEventListener;
import org.openspaces.admin.internal.pu.events.InternalManagingGridServiceManagerChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.events.ManagingGridServiceManagerChangedEvent;
import org.openspaces.admin.pu.events.ManagingGridServiceManagerChangedEventListener;

public class DefaultManagingGridServiceManagerChangedEventManager
implements InternalManagingGridServiceManagerChangedEventManager {
    private final InternalAdmin admin;
    private final List<ManagingGridServiceManagerChangedEventListener> listeners = new CopyOnWriteArrayList<ManagingGridServiceManagerChangedEventListener>();
    private final DefaultProcessingUnit processingUnit;

    public DefaultManagingGridServiceManagerChangedEventManager(InternalAdmin admin) {
        this(admin, null);
    }

    public DefaultManagingGridServiceManagerChangedEventManager(InternalAdmin admin, DefaultProcessingUnit processingUnit) {
        this.processingUnit = processingUnit;
        this.admin = admin;
    }

    @Override
    public void processingUnitManagingGridServiceManagerChanged(final ManagingGridServiceManagerChangedEvent event) {
        for (final ManagingGridServiceManagerChangedEventListener listener : this.listeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitManagingGridServiceManagerChanged(event);
                }
            });
        }
    }

    @Override
    public void add(ManagingGridServiceManagerChangedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final ManagingGridServiceManagerChangedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    if (DefaultManagingGridServiceManagerChangedEventManager.this.processingUnit == null) {
                        for (ProcessingUnit pu : DefaultManagingGridServiceManagerChangedEventManager.this.admin.getProcessingUnits()) {
                            eventListener.processingUnitManagingGridServiceManagerChanged(new ManagingGridServiceManagerChangedEvent(pu, pu.getManagingGridServiceManager(), null));
                        }
                    } else {
                        eventListener.processingUnitManagingGridServiceManagerChanged(new ManagingGridServiceManagerChangedEvent(DefaultManagingGridServiceManagerChangedEventManager.this.processingUnit, DefaultManagingGridServiceManagerChangedEventManager.this.processingUnit.getManagingGridServiceManager(), null));
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ManagingGridServiceManagerChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureManagingGridServiceManagerChangedEventListener(eventListener));
        } else {
            this.add((ManagingGridServiceManagerChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureManagingGridServiceManagerChangedEventListener(eventListener));
        } else {
            this.remove((ManagingGridServiceManagerChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

