/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalOrphanProcessingUnitInstancesAware;
import org.openspaces.admin.internal.pu.events.InternalOrphanProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.internal.pu.events.InternalOrphanProcessingUnitInstanceLifecycleEventManager;
import org.openspaces.admin.pu.ProcessingUnitInstance;

public class DefaultOrphanProcessingUnitInstanceLifecycleEventManager
implements InternalOrphanProcessingUnitInstanceLifecycleEventManager {
    private final InternalAdmin admin;
    private final List<InternalOrphanProcessingUnitInstanceLifecycleEventListener> listeners = new CopyOnWriteArrayList<InternalOrphanProcessingUnitInstanceLifecycleEventListener>();
    private final InternalOrphanProcessingUnitInstancesAware instances;

    public DefaultOrphanProcessingUnitInstanceLifecycleEventManager(InternalOrphanProcessingUnitInstancesAware instances, InternalAdmin admin) {
        this.admin = admin;
        this.instances = instances;
    }

    @Override
    public void orphanProcessingUnitInstanceRemoved(final ProcessingUnitInstance processingUnitInstance) {
        for (final InternalOrphanProcessingUnitInstanceLifecycleEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.orphanProcessingUnitInstanceRemoved(processingUnitInstance);
                }
            });
        }
    }

    @Override
    public void orphanProcessingUnitInstanceAdded(final ProcessingUnitInstance processingUnitInstance) {
        for (final InternalOrphanProcessingUnitInstanceLifecycleEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.orphanProcessingUnitInstanceAdded(processingUnitInstance);
                }
            });
        }
    }

    @Override
    public void add(InternalOrphanProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final InternalOrphanProcessingUnitInstanceLifecycleEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (ProcessingUnitInstance processingUnitInstance : DefaultOrphanProcessingUnitInstanceLifecycleEventManager.this.instances.getOrphanProcessingUnitInstances()) {
                        eventListener.orphanProcessingUnitInstanceAdded(processingUnitInstance);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(InternalOrphanProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.listeners.remove(eventListener);
    }
}

