/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitAddedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.events.ProcessingUnitAddedEventListener;

public class DefaultProcessingUnitAddedEventManager
implements InternalProcessingUnitAddedEventManager {
    private final InternalProcessingUnits processingUnits;
    private final InternalAdmin admin;
    private final List<ProcessingUnitAddedEventListener> listeners = new CopyOnWriteArrayList<ProcessingUnitAddedEventListener>();

    public DefaultProcessingUnitAddedEventManager(InternalProcessingUnits processingUnits) {
        this.processingUnits = processingUnits;
        this.admin = (InternalAdmin)processingUnits.getAdmin();
    }

    @Override
    public void processingUnitAdded(final ProcessingUnit processingUnit) {
        for (final ProcessingUnitAddedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitAdded(processingUnit);
                }
            });
        }
    }

    @Override
    public void add(ProcessingUnitAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final ProcessingUnitAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (ProcessingUnit processingUnit : DefaultProcessingUnitAddedEventManager.this.processingUnits) {
                        eventListener.processingUnitAdded(processingUnit);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ProcessingUnitAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitAddedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitAddedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

