/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstancesAware;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitInstanceAddedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventListener;

public class DefaultProcessingUnitInstanceAddedEventManager
implements InternalProcessingUnitInstanceAddedEventManager {
    private final InternalProcessingUnitInstancesAware processingUnits;
    private final InternalAdmin admin;
    private final List<ProcessingUnitInstanceAddedEventListener> listeners = new CopyOnWriteArrayList<ProcessingUnitInstanceAddedEventListener>();

    public DefaultProcessingUnitInstanceAddedEventManager(InternalProcessingUnitInstancesAware processingUnits, InternalAdmin admin) {
        this.processingUnits = processingUnits;
        this.admin = admin;
    }

    @Override
    public void processingUnitInstanceAdded(final ProcessingUnitInstance processingUnitInstance) {
        for (final ProcessingUnitInstanceAddedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitInstanceAdded(processingUnitInstance);
                }
            });
        }
    }

    @Override
    public void add(final ProcessingUnitInstanceAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (ProcessingUnitInstance processingUnitInstance : DefaultProcessingUnitInstanceAddedEventManager.this.processingUnits.getProcessingUnitInstances()) {
                        eventListener.processingUnitInstanceAdded(processingUnitInstance);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(ProcessingUnitInstanceAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(ProcessingUnitInstanceAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitInstanceAddedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitInstanceAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitInstanceAddedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitInstanceAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

