/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener;

public class DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager
implements InternalProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager {
    private final InternalAdmin admin;
    private final List<ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener> eventListeners = new CopyOnWriteArrayList<ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener>();
    private final InternalProcessingUnit processingUnit;

    public DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager(InternalAdmin admin) {
        this(admin, null);
    }

    public DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager(InternalAdmin admin, InternalProcessingUnit processingUnit) {
        this.admin = admin;
        this.processingUnit = processingUnit;
    }

    @Override
    public void add(ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener listener) {
        this.add(listener, true);
    }

    @Override
    public void add(final ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener listener, boolean includeCurrentStatus) {
        if (includeCurrentStatus) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    if (DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager.this.processingUnit != null) {
                        this.notifyListener(listener, DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager.this.processingUnit);
                    } else {
                        for (ProcessingUnit pu : DefaultProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventManager.this.admin.getProcessingUnits()) {
                            this.notifyListener(listener, pu);
                        }
                    }
                }

                private void notifyListener(ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener listener2, ProcessingUnit pu) {
                    for (ProcessingUnitInstance instance : pu) {
                        listener2.processingUnitInstanceMemberAliveIndicatorStatusChanged(new ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent(instance, null, instance.getMemberAliveIndicatorStatus()));
                    }
                }
            });
        }
        this.eventListeners.add(listener);
    }

    @Override
    public void remove(ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void processingUnitInstanceMemberAliveIndicatorStatusChanged(final ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEvent event) {
        for (final ProcessingUnitInstanceMemberAliveIndicatorStatusChangedEventListener listener : this.eventListeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitInstanceMemberAliveIndicatorStatusChanged(event);
                }
            });
        }
    }
}

