/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.InternalProvisionStatusHolder;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceProvisionStatusChangedEventManager;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceProvisionStatusChangedEventListener;

public class DefaultProcessingUnitInstanceProvisionStatusChangedEventManager
implements InternalProcessingUnitInstanceProvisionStatusChangedEventManager {
    private final InternalAdmin admin;
    private final List<ProcessingUnitInstanceProvisionStatusChangedEventListener> eventListeners = new CopyOnWriteArrayList<ProcessingUnitInstanceProvisionStatusChangedEventListener>();
    private final InternalProcessingUnit processingUnit;

    public DefaultProcessingUnitInstanceProvisionStatusChangedEventManager(InternalAdmin admin) {
        this(admin, null);
    }

    public DefaultProcessingUnitInstanceProvisionStatusChangedEventManager(InternalAdmin admin, InternalProcessingUnit processingUnit) {
        this.admin = admin;
        this.processingUnit = processingUnit;
    }

    @Override
    public void add(ProcessingUnitInstanceProvisionStatusChangedEventListener listener) {
        this.add(listener, true);
    }

    @Override
    public void add(final ProcessingUnitInstanceProvisionStatusChangedEventListener listener, boolean includeCurrentStatus) {
        if (includeCurrentStatus) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    if (DefaultProcessingUnitInstanceProvisionStatusChangedEventManager.this.processingUnit != null) {
                        this.notifyListener(listener, DefaultProcessingUnitInstanceProvisionStatusChangedEventManager.this.processingUnit);
                    } else {
                        for (ProcessingUnit pu : DefaultProcessingUnitInstanceProvisionStatusChangedEventManager.this.admin.getProcessingUnits()) {
                            this.notifyListener(listener, pu);
                        }
                    }
                }

                private void notifyListener(ProcessingUnitInstanceProvisionStatusChangedEventListener listener2, ProcessingUnit pu) {
                    Map<String, InternalProvisionStatusHolder> provisionStatusPerInstanceMap = ((InternalProcessingUnit)pu).getProvisionStatusPerInstance();
                    for (Map.Entry<String, InternalProvisionStatusHolder> entrySet : provisionStatusPerInstanceMap.entrySet()) {
                        String processingUnitInstanceName = entrySet.getKey();
                        InternalProvisionStatusHolder statusHolder = entrySet.getValue();
                        ProcessingUnitInstance processingUnitInstance = DefaultProcessingUnitInstanceProvisionStatusChangedEventManager.this.getProcessingUnitInstanceByName(pu, processingUnitInstanceName);
                        GridServiceContainer gridServiceContainer = DefaultProcessingUnitInstanceProvisionStatusChangedEventManager.this.getGridServiceContainer(processingUnitInstance);
                        listener2.processingUnitInstanceProvisionStatusChanged(new ProcessingUnitInstanceProvisionStatusChangedEvent(pu, processingUnitInstanceName, statusHolder.getPrevProvisionStatus(), statusHolder.getNewProvisionStatus(), gridServiceContainer, processingUnitInstance, statusHolder.getProvisionFailure()));
                    }
                }
            });
        }
        this.eventListeners.add(listener);
    }

    @Override
    public void remove(ProcessingUnitInstanceProvisionStatusChangedEventListener listener) {
        this.eventListeners.remove(listener);
    }

    @Override
    public void processingUnitInstanceProvisionStatusChanged(final ProcessingUnitInstanceProvisionStatusChangedEvent event) {
        for (final ProcessingUnitInstanceProvisionStatusChangedEventListener listener : this.eventListeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitInstanceProvisionStatusChanged(event);
                }
            });
        }
    }

    private ProcessingUnitInstance getProcessingUnitInstanceByName(ProcessingUnit processingUnit, String processingUnitInstanceName) {
        for (ProcessingUnitInstance instance : processingUnit.getInstances()) {
            if (!instance.getProcessingUnitInstanceName().equals(processingUnitInstanceName)) continue;
            return instance;
        }
        return null;
    }

    private GridServiceContainer getGridServiceContainer(ProcessingUnitInstance processingUnitInstance) {
        if (processingUnitInstance == null) {
            return null;
        }
        return processingUnitInstance.getGridServiceContainer();
    }
}

