/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitInstanceRemovedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventListener;

public class DefaultProcessingUnitInstanceRemovedEventManager
implements InternalProcessingUnitInstanceRemovedEventManager {
    private final InternalAdmin admin;
    private final List<ProcessingUnitInstanceRemovedEventListener> listeners = new CopyOnWriteArrayList<ProcessingUnitInstanceRemovedEventListener>();

    public DefaultProcessingUnitInstanceRemovedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void processingUnitInstanceRemoved(final ProcessingUnitInstance processingUnitInstance) {
        for (final ProcessingUnitInstanceRemovedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitInstanceRemoved(processingUnitInstance);
                }
            });
        }
    }

    @Override
    public void add(ProcessingUnitInstanceRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ProcessingUnitInstanceRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitInstanceRemovedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitInstanceRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitInstanceRemovedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitInstanceRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

