/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitInstanceStatisticsChangedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceStatisticsChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceStatisticsChangedEventListener;

public class DefaultProcessingUnitInstanceStatisticsChangedEventManager
implements InternalProcessingUnitInstanceStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final List<ProcessingUnitInstanceStatisticsChangedEventListener> eventListeners = new CopyOnWriteArrayList<ProcessingUnitInstanceStatisticsChangedEventListener>();

    public DefaultProcessingUnitInstanceStatisticsChangedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void add(ProcessingUnitInstanceStatisticsChangedEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public void remove(ProcessingUnitInstanceStatisticsChangedEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    @Override
    public void processingUnitInstanceStatisticsChanged(final ProcessingUnitInstanceStatisticsChangedEvent event) {
        for (final ProcessingUnitInstanceStatisticsChangedEventListener listener : this.eventListeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitInstanceStatisticsChanged(event);
                }
            });
        }
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitInstanceStatisticsChangedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitInstanceStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitInstanceStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitInstanceStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

