/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnits;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitRemovedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.events.ProcessingUnitRemovedEventListener;

public class DefaultProcessingUnitRemovedEventManager
implements InternalProcessingUnitRemovedEventManager {
    private final InternalProcessingUnits processingUnits;
    private final InternalAdmin admin;
    private final List<ProcessingUnitRemovedEventListener> listeners = new CopyOnWriteArrayList<ProcessingUnitRemovedEventListener>();

    public DefaultProcessingUnitRemovedEventManager(InternalProcessingUnits processingUnits) {
        this.processingUnits = processingUnits;
        this.admin = (InternalAdmin)processingUnits.getAdmin();
    }

    @Override
    public void processingUnitRemoved(final ProcessingUnit processingUnit) {
        for (final ProcessingUnitRemovedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitRemoved(processingUnit);
                }
            });
        }
    }

    @Override
    public void add(ProcessingUnitRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ProcessingUnitRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitRemovedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitRemovedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

