/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitSpaceCorrelatedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitSpaceCorrelatedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.events.ProcessingUnitSpaceCorrelatedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitSpaceCorrelatedEventListener;
import org.openspaces.admin.space.Space;

public class DefaultProcessingUnitSpaceCorrelatedEventManager
implements InternalProcessingUnitSpaceCorrelatedEventManager {
    private final InternalAdmin admin;
    private final InternalProcessingUnit processingUnit;
    private final List<ProcessingUnitSpaceCorrelatedEventListener> listeners = new CopyOnWriteArrayList<ProcessingUnitSpaceCorrelatedEventListener>();

    public DefaultProcessingUnitSpaceCorrelatedEventManager(InternalProcessingUnit processingUnit) {
        this.processingUnit = processingUnit;
        this.admin = (InternalAdmin)processingUnit.getAdmin();
    }

    @Override
    public void processingUnitSpaceCorrelated(final ProcessingUnitSpaceCorrelatedEvent event) {
        for (final ProcessingUnitSpaceCorrelatedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitSpaceCorrelated(event);
                }
            });
        }
    }

    @Override
    public void add(final ProcessingUnitSpaceCorrelatedEventListener eventListener) {
        for (final Space space : this.processingUnit.getSpaces()) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    eventListener.processingUnitSpaceCorrelated(new ProcessingUnitSpaceCorrelatedEvent(space, DefaultProcessingUnitSpaceCorrelatedEventManager.this.processingUnit));
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ProcessingUnitSpaceCorrelatedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitSpaceCorrelatedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitSpaceCorrelatedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitSpaceCorrelatedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitSpaceCorrelatedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

