/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.pu.events.ClosureProcessingUnitStatusChangedEventListener;
import org.openspaces.admin.internal.pu.events.InternalProcessingUnitStatusChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEvent;
import org.openspaces.admin.pu.events.ProcessingUnitStatusChangedEventListener;

public class DefaultProcessingUnitStatusChangedEventManager
implements InternalProcessingUnitStatusChangedEventManager {
    private final InternalAdmin admin;
    private final List<ProcessingUnitStatusChangedEventListener> listeners = new CopyOnWriteArrayList<ProcessingUnitStatusChangedEventListener>();
    private final ProcessingUnit processingUnit;

    public DefaultProcessingUnitStatusChangedEventManager(InternalAdmin admin) {
        this(admin, null);
    }

    public DefaultProcessingUnitStatusChangedEventManager(InternalAdmin admin, ProcessingUnit processingUnit) {
        this.admin = admin;
        this.processingUnit = processingUnit;
    }

    @Override
    public void processingUnitStatusChanged(final ProcessingUnitStatusChangedEvent event) {
        for (final ProcessingUnitStatusChangedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.processingUnitStatusChanged(event);
                }
            });
        }
    }

    @Override
    public void add(ProcessingUnitStatusChangedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void add(final ProcessingUnitStatusChangedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    if (DefaultProcessingUnitStatusChangedEventManager.this.processingUnit == null) {
                        for (ProcessingUnit pu : DefaultProcessingUnitStatusChangedEventManager.this.admin.getProcessingUnits()) {
                            eventListener.processingUnitStatusChanged(new ProcessingUnitStatusChangedEvent(pu, null, pu.getStatus()));
                        }
                    } else {
                        eventListener.processingUnitStatusChanged(new ProcessingUnitStatusChangedEvent(DefaultProcessingUnitStatusChangedEventManager.this.processingUnit, null, DefaultProcessingUnitStatusChangedEventManager.this.processingUnit.getStatus()));
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ProcessingUnitStatusChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureProcessingUnitStatusChangedEventListener(eventListener));
        } else {
            this.add((ProcessingUnitStatusChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureProcessingUnitStatusChangedEventListener(eventListener));
        } else {
            this.remove((ProcessingUnitStatusChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

