/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatisticsCalculator;
import org.openspaces.admin.internal.pu.statistics.StatisticsObjectList;
import org.openspaces.admin.internal.pu.statistics.StatisticsObjectListFunction;
import org.openspaces.admin.pu.statistics.EachSingleInstanceStatisticsConfig;
import org.openspaces.admin.pu.statistics.InstancesStatisticsConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfig;

public class InstancesStatisticsCalculator
implements InternalProcessingUnitStatisticsCalculator {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void calculateNewStatistics(InternalProcessingUnitStatistics processingUnitStatistics, Collection<ProcessingUnitStatisticsId> statisticsIds) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("calculateNewStatistics(processingUnitStatistics=" + processingUnitStatistics + " , statisticsIds=" + statisticsIds));
        }
        Map<ProcessingUnitStatisticsId, Set<InstancesStatisticsConfig>> instancesStatisticsPerErasedStatisticsId = this.eraseInstancesStatistics(statisticsIds);
        Set<ProcessingUnitStatisticsId> erasedStatisticsIds = instancesStatisticsPerErasedStatisticsId.keySet();
        Map<ProcessingUnitStatisticsId, StatisticsObjectList> valuesPerErasedStatisticsId = this.getValues(processingUnitStatistics, erasedStatisticsIds);
        for (Map.Entry<ProcessingUnitStatisticsId, StatisticsObjectList> pair : valuesPerErasedStatisticsId.entrySet()) {
            ProcessingUnitStatisticsId erasedStatisticsId = pair.getKey();
            StatisticsObjectList values = pair.getValue();
            for (InstancesStatisticsConfig instancesStatistics : instancesStatisticsPerErasedStatisticsId.get(erasedStatisticsId)) {
                if (!(instancesStatistics instanceof StatisticsObjectListFunction)) continue;
                StatisticsObjectListFunction statisticsFunc = (StatisticsObjectListFunction)((Object)instancesStatistics);
                Object value = statisticsFunc.calc(values);
                ProcessingUnitStatisticsId statisticsId = this.unerase(erasedStatisticsId, instancesStatistics);
                processingUnitStatistics.addStatistics(statisticsId, value);
            }
        }
    }

    private Map<ProcessingUnitStatisticsId, StatisticsObjectList> getValues(InternalProcessingUnitStatistics processingUnitStatistics, Set<ProcessingUnitStatisticsId> erasedStatisticsIds) {
        HashMap<ProcessingUnitStatisticsId, StatisticsObjectList> values = new HashMap<ProcessingUnitStatisticsId, StatisticsObjectList>();
        for (Map.Entry<ProcessingUnitStatisticsId, Object> pair : processingUnitStatistics.getStatistics().entrySet()) {
            ProcessingUnitStatisticsId erasedStatisticsId;
            ProcessingUnitStatisticsId statisticsId = pair.getKey();
            if (statisticsId.getInstancesStatistics() instanceof EachSingleInstanceStatisticsConfig) {
                throw new IllegalArgumentException("Unsupported statisticsId. Use " + SingleInstanceStatisticsConfig.class + " instead of " + EachSingleInstanceStatisticsConfig.class);
            }
            if (!(statisticsId.getInstancesStatistics() instanceof SingleInstanceStatisticsConfig) || !erasedStatisticsIds.contains(erasedStatisticsId = this.erase(statisticsId))) continue;
            if (!values.containsKey(erasedStatisticsId)) {
                values.put(erasedStatisticsId, new StatisticsObjectList());
            }
            Object value = pair.getValue();
            long timeStamp = processingUnitStatistics.getAdminTimestamp();
            ((StatisticsObjectList)values.get(erasedStatisticsId)).add(value, timeStamp);
        }
        return values;
    }

    private Map<ProcessingUnitStatisticsId, Set<InstancesStatisticsConfig>> eraseInstancesStatistics(Iterable<ProcessingUnitStatisticsId> statisticsIds) {
        HashMap<ProcessingUnitStatisticsId, Set<InstancesStatisticsConfig>> groupBy = new HashMap<ProcessingUnitStatisticsId, Set<InstancesStatisticsConfig>>();
        for (ProcessingUnitStatisticsId statisticsId : statisticsIds) {
            InstancesStatisticsConfig instancesStatistics = statisticsId.getInstancesStatistics();
            ProcessingUnitStatisticsId key = this.erase(statisticsId);
            if (!groupBy.containsKey(key)) {
                groupBy.put(key, new HashSet());
            }
            ((Set)groupBy.get(key)).add(instancesStatistics);
        }
        return groupBy;
    }

    private ProcessingUnitStatisticsId erase(ProcessingUnitStatisticsId statisticsId) {
        statisticsId.validate();
        ProcessingUnitStatisticsId erased = statisticsId.shallowClone();
        erased.setInstancesStatistics(null);
        return erased;
    }

    private ProcessingUnitStatisticsId unerase(ProcessingUnitStatisticsId erasedStatisticsId, InstancesStatisticsConfig instancesStatistics) {
        ProcessingUnitStatisticsId unerased;
        if (erasedStatisticsId.getInstancesStatistics() != null) {
            unerased = erasedStatisticsId;
        } else {
            unerased = erasedStatisticsId.shallowClone();
            unerased.setInstancesStatistics(instancesStatistics);
        }
        unerased.validate();
        return unerased;
    }
}

