/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatisticsObjectList {
    private static final Log logger = LogFactory.getLog(StatisticsObjectList.class);
    private final List values = new ArrayList();
    private Double sum = 0.0;
    private Comparable min = null;
    private Long firstTimeStampMillis = null;
    private Long lastTimeStampMillis = null;
    private Comparable max = null;
    private Class<?> notComparableClass = null;
    private Class<?> notNumberClass = null;
    private boolean sorted = false;
    private Object last = null;
    private Object first = null;

    public void add(Object value, long timeStampMillis) {
        this.values.add(value);
        if (this.first == null) {
            this.first = value;
        }
        if (this.firstTimeStampMillis == null) {
            this.firstTimeStampMillis = timeStampMillis;
        }
        this.last = value;
        this.lastTimeStampMillis = timeStampMillis;
        this.sorted = false;
        if (this.notNumberClass == null) {
            if (value instanceof Number) {
                this.sum = this.sum + ((Number)value).doubleValue();
            } else {
                this.notNumberClass = value.getClass();
            }
        }
        if (this.notComparableClass == null) {
            if (value instanceof Comparable) {
                if (this.min == null || this.min.compareTo(value) > 0) {
                    this.min = (Comparable)value;
                }
                if (this.max == null || this.max.compareTo(value) < 0) {
                    this.max = (Comparable)value;
                }
            } else {
                this.notComparableClass = value.getClass();
            }
        }
    }

    public Double getAverage() {
        if (this.notNumberClass != null) {
            throw new ClassCastException(this.notNumberClass + " cannot be cast to a Number");
        }
        if (this.values.isEmpty()) {
            return null;
        }
        double average = this.sum / (double)this.values.size();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("average(" + this.toString() + ")=" + average));
        }
        return average;
    }

    public Object getMinimum() {
        if (this.notComparableClass != null) {
            throw new ClassCastException(this.notComparableClass + " cannot be cast to a Comparable");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("minimum(" + this.toString() + ")=" + this.min));
        }
        return this.min;
    }

    public Object getMaximum() {
        if (this.notComparableClass != null) {
            throw new ClassCastException(this.notComparableClass + " cannot be cast to a Comparable");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("maximum(" + this.toString() + ")=" + this.max));
        }
        return this.max;
    }

    public Object getLast() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("last(" + this.toString() + ")=" + this.last));
        }
        return this.last;
    }

    public Object getPercentile(double percentile) {
        if (percentile < 0.0) {
            throw new IllegalArgumentException("percentile (" + percentile + ") must be between 0 and 100.");
        }
        if (percentile > 100.0) {
            throw new IllegalArgumentException("percentile (" + percentile + ") must be between 0 and 100");
        }
        if (this.notComparableClass != null) {
            throw new ClassCastException(this.notComparableClass + " cannot be cast to a Comparable");
        }
        if (this.values.isEmpty()) {
            return null;
        }
        if (!this.sorted) {
            Collections.sort(this.values);
            this.sorted = true;
        }
        int index = (int)Math.round((double)(this.values.size() - 1) * percentile / 100.0);
        Object percentileValue = this.values.get(index);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("percentile(" + percentile + "," + this.toString() + ")=" + percentileValue));
        }
        return percentileValue;
    }

    public Double getDeltaValuePerNanoSecond() {
        return this.getDeltaPerTimeunit(TimeUnit.NANOSECONDS);
    }

    public Double getDeltaValuePerMilliSecond() {
        return this.getDeltaPerTimeunit(TimeUnit.MILLISECONDS);
    }

    public Double getDeltaValuePerSecond() {
        return this.getDeltaPerTimeunit(TimeUnit.SECONDS);
    }

    private Double getDeltaPerTimeunit(TimeUnit timeUnit) {
        if (this.notNumberClass != null) {
            throw new ClassCastException(this.notNumberClass + " cannot be cast to a Number");
        }
        if (this.values.size() < 2) {
            return null;
        }
        Long timeWindowInTimeunit = timeUnit.convert(this.lastTimeStampMillis - this.firstTimeStampMillis, TimeUnit.MILLISECONDS);
        double lastValue = ((Number)this.last).doubleValue();
        double firstValue = ((Number)this.first).doubleValue();
        double deltaValuePerTimeunit = (lastValue - firstValue) / (double)timeWindowInTimeunit.longValue();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deltaValuePer" + timeUnit.toString() + "(" + this.toString() + ")=(" + lastValue + "-" + firstValue + ")/" + timeWindowInTimeunit + "=" + deltaValuePerTimeunit));
        }
        return deltaValuePerTimeunit;
    }

    public String toString() {
        return this.values.toString();
    }
}

