/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.pu.ProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.statistics.ErasedTimeWindowStatisticsConfig;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatisticsCalculator;
import org.openspaces.admin.internal.pu.statistics.StatisticsObjectList;
import org.openspaces.admin.internal.pu.statistics.StatisticsObjectListFunction;
import org.openspaces.admin.pu.statistics.AbstractTimeWindowStatisticsConfig;
import org.openspaces.admin.pu.statistics.LastSampleTimeWindowStatisticsConfig;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.pu.statistics.SingleInstanceStatisticsConfig;
import org.openspaces.admin.pu.statistics.TimeWindowStatisticsConfig;

public class TimeWindowStatisticsCalculator
implements InternalProcessingUnitStatisticsCalculator {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void calculateNewStatistics(InternalProcessingUnitStatistics processingUnitStatistics, Collection<ProcessingUnitStatisticsId> statisticsIds) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("calculateNewStatistics(processingUnitStatistics=" + processingUnitStatistics + " , statisticsIds=" + statisticsIds));
        }
        Map<ProcessingUnitStatisticsId, Set<TimeWindowStatisticsConfig>> timeWindowStatisticsPerErasedStatisticsId = this.eraseTimeWindowStatistics(statisticsIds);
        Set<ProcessingUnitStatisticsId> erasedStatisticsIds = timeWindowStatisticsPerErasedStatisticsId.keySet();
        Map<ProcessingUnitStatisticsId, StatisticsObjectList> valuesPerErasedStatisticsId = this.getValues(processingUnitStatistics, erasedStatisticsIds);
        for (Map.Entry<ProcessingUnitStatisticsId, StatisticsObjectList> pair : valuesPerErasedStatisticsId.entrySet()) {
            ProcessingUnitStatisticsId erasedStatisticsId = pair.getKey();
            StatisticsObjectList values = pair.getValue();
            for (TimeWindowStatisticsConfig timeWindowStatistics : timeWindowStatisticsPerErasedStatisticsId.get(erasedStatisticsId)) {
                if (!(timeWindowStatistics instanceof StatisticsObjectListFunction)) continue;
                StatisticsObjectListFunction statisticsFunc = (StatisticsObjectListFunction)((Object)timeWindowStatistics);
                Object value = statisticsFunc.calc(values);
                ProcessingUnitStatisticsId statisticsId = this.unerase(erasedStatisticsId, timeWindowStatistics);
                processingUnitStatistics.addStatistics(statisticsId, value);
            }
        }
    }

    private Map<ProcessingUnitStatisticsId, Set<TimeWindowStatisticsConfig>> eraseTimeWindowStatistics(Iterable<ProcessingUnitStatisticsId> statisticsIds) {
        HashMap<ProcessingUnitStatisticsId, Set<TimeWindowStatisticsConfig>> groupBy = new HashMap<ProcessingUnitStatisticsId, Set<TimeWindowStatisticsConfig>>();
        for (ProcessingUnitStatisticsId statisticsId : statisticsIds) {
            if (!(statisticsId.getTimeWindowStatistics() instanceof AbstractTimeWindowStatisticsConfig)) continue;
            ProcessingUnitStatisticsId key = this.erase(statisticsId);
            if (!groupBy.containsKey(key)) {
                groupBy.put(key, new HashSet());
            }
            ((Set)groupBy.get(key)).add(statisticsId.getTimeWindowStatistics());
        }
        return groupBy;
    }

    private ProcessingUnitStatisticsId erase(ProcessingUnitStatisticsId statisticsId) {
        statisticsId.validate();
        if (!(statisticsId.getInstancesStatistics() instanceof SingleInstanceStatisticsConfig)) {
            throw new IllegalArgumentException("Unsupported statisticsId. Only " + SingleInstanceStatisticsConfig.class.getName() + " is supported. Offending id=" + statisticsId);
        }
        ProcessingUnitStatisticsId erased = statisticsId.shallowClone();
        erased.setTimeWindowStatistics(new ErasedTimeWindowStatisticsConfig((AbstractTimeWindowStatisticsConfig)erased.getTimeWindowStatistics()));
        return erased;
    }

    private ProcessingUnitStatisticsId unerase(ProcessingUnitStatisticsId erasedStatisticsId, TimeWindowStatisticsConfig timeWindowStatistics) {
        if (!(erasedStatisticsId.getTimeWindowStatistics() instanceof ErasedTimeWindowStatisticsConfig)) {
            return erasedStatisticsId;
        }
        ProcessingUnitStatisticsId unerased = erasedStatisticsId.shallowClone();
        unerased.setTimeWindowStatistics(timeWindowStatistics);
        return unerased;
    }

    private Map<ProcessingUnitStatisticsId, StatisticsObjectList> getValues(InternalProcessingUnitStatistics processingUnitStatistics, Set<ProcessingUnitStatisticsId> newStatisticsIds) {
        if (processingUnitStatistics == null) {
            throw new IllegalArgumentException("processingUnitStatistics cannot be null");
        }
        HashMap<ProcessingUnitStatisticsId, StatisticsObjectList> temporaryValues = new HashMap<ProcessingUnitStatisticsId, StatisticsObjectList>();
        for (ProcessingUnitStatisticsId statisticsId : newStatisticsIds) {
            temporaryValues.put(statisticsId, new StatisticsObjectList());
        }
        HashMap<ProcessingUnitStatisticsId, StatisticsObjectList> returnValues = new HashMap<ProcessingUnitStatisticsId, StatisticsObjectList>();
        for (ProcessingUnitStatistics statistics = processingUnitStatistics; statistics != null; statistics = statistics.getPrevious()) {
            long timeDelta = processingUnitStatistics.getAdminTimestamp() - statistics.getAdminTimestamp();
            Map<ProcessingUnitStatisticsId, Object> values = statistics.getStatistics();
            for (ProcessingUnitStatisticsId statisticsId : newStatisticsIds) {
                StatisticsObjectList timeline = (StatisticsObjectList)temporaryValues.get(statisticsId);
                ErasedTimeWindowStatisticsConfig timeWindowStatistics = (ErasedTimeWindowStatisticsConfig)statisticsId.getTimeWindowStatistics();
                timeWindowStatistics.validate();
                long timeWindowMilliSeconds = TimeUnit.SECONDS.toMillis(timeWindowStatistics.getTimeWindowSeconds());
                long minTimeWindowMilliSeconds = TimeUnit.SECONDS.toMillis(timeWindowStatistics.getMinimumTimeWindowSeconds());
                long maxTimeWindowMilliSeconds = TimeUnit.SECONDS.toMillis(timeWindowStatistics.getMaximumTimeWindowSeconds());
                if (timeline == null) continue;
                ProcessingUnitStatisticsId fixedStatisticsId = this.getStatisticsIdWithLastTimestamp(statisticsId);
                Object value = values.get(fixedStatisticsId);
                if (timeDelta > maxTimeWindowMilliSeconds || value == null) {
                    temporaryValues.remove(statisticsId);
                    continue;
                }
                long timeStamp = statistics.getAdminTimestamp();
                timeline.add(value, timeStamp);
                if (timeDelta >= minTimeWindowMilliSeconds) {
                    returnValues.put(statisticsId, timeline);
                }
                if (timeDelta < timeWindowMilliSeconds) continue;
                temporaryValues.remove(statisticsId);
            }
        }
        return returnValues;
    }

    private ProcessingUnitStatisticsId getStatisticsIdWithLastTimestamp(ProcessingUnitStatisticsId statisticsId) {
        ProcessingUnitStatisticsId fixedStatisticsId = statisticsId.shallowClone();
        fixedStatisticsId.setTimeWindowStatistics(new LastSampleTimeWindowStatisticsConfig());
        return fixedStatisticsId;
    }
}

