/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.pu.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatistics;
import org.openspaces.admin.internal.pu.statistics.InternalProcessingUnitStatisticsCalculator;
import org.openspaces.admin.pu.statistics.ProcessingUnitStatisticsId;
import org.openspaces.admin.zone.config.ExactZonesConfig;
import org.openspaces.admin.zone.config.ZonesConfig;

public class ZoneStatisticsCalculator
implements InternalProcessingUnitStatisticsCalculator {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public void calculateNewStatistics(InternalProcessingUnitStatistics processingUnitStatistics, Collection<ProcessingUnitStatisticsId> requestedStatisticsIds) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("calculateNewStatistics(processingUnitStatistics=" + processingUnitStatistics + " , statisticsIds=" + requestedStatisticsIds + " admin timestamp = " + processingUnitStatistics.getAdminTimestamp()));
        }
        HashMap<ProcessingUnitStatisticsId, Object> statistics = new HashMap<ProcessingUnitStatisticsId, Object>(processingUnitStatistics.getStatistics());
        for (ProcessingUnitStatisticsId requestedStatisticsId : requestedStatisticsIds) {
            this.calculateNewStatistics(processingUnitStatistics, statistics, requestedStatisticsId);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("calculateNewStatistics(processingUnitStatistics=" + processingUnitStatistics + " , statisticsIds=" + requestedStatisticsIds + " admin timestamp = " + processingUnitStatistics.getAdminTimestamp()));
        }
    }

    private void calculateNewStatistics(InternalProcessingUnitStatistics processingUnitStatistics, Map<ProcessingUnitStatisticsId, Object> copyOfStatistics, ProcessingUnitStatisticsId requestedStatisticsId) {
        requestedStatisticsId.validate();
        boolean statisfied = false;
        for (Map.Entry<ProcessingUnitStatisticsId, Object> statisticsEntry : copyOfStatistics.entrySet()) {
            if (!this.calculateNewStatistics(processingUnitStatistics, statisticsEntry, requestedStatisticsId)) continue;
            statisfied = true;
        }
        if (!statisfied && this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("requestedZoneStatisticsConfig : " + requestedStatisticsId.getAgentZones() + " is not satisfied by any existing statistics"));
        }
    }

    private boolean calculateNewStatistics(InternalProcessingUnitStatistics internalProcessingUnitStatistics, Map.Entry<ProcessingUnitStatisticsId, Object> statisticsEntry, ProcessingUnitStatisticsId requestedStatisticsId) {
        ProcessingUnitStatisticsId existingProcessingUnitStatisticsId = statisticsEntry.getKey();
        Object value = statisticsEntry.getValue();
        ZonesConfig requestedZoneStatisticsConfig = requestedStatisticsId.getAgentZones();
        ProcessingUnitStatisticsId erasedExistingProcessingUnitStatisticsId = this.erase(existingProcessingUnitStatisticsId);
        ProcessingUnitStatisticsId erasedrequestedStatisticsId = this.erase(requestedStatisticsId);
        ExactZonesConfig existingZoneStatisticsConfig = null;
        if (!(existingProcessingUnitStatisticsId.getAgentZones() instanceof ExactZonesConfig)) {
            throw new IllegalStateException("found a map entry with key = " + existingProcessingUnitStatisticsId + " and value = " + value + " in processing unit statistics = " + internalProcessingUnitStatistics + ". ZonesConfig for this entry is not an instance of ExactZonesConfig.requestedStatisticsId for calculation was = " + requestedStatisticsId);
        }
        existingZoneStatisticsConfig = (ExactZonesConfig)existingProcessingUnitStatisticsId.getAgentZones();
        if (requestedZoneStatisticsConfig.isSatisfiedBy(existingZoneStatisticsConfig) && erasedrequestedStatisticsId.equals(erasedExistingProcessingUnitStatisticsId)) {
            ProcessingUnitStatisticsId newProcessingUnitStatisticsId = existingProcessingUnitStatisticsId.shallowClone();
            requestedZoneStatisticsConfig.validate();
            newProcessingUnitStatisticsId.setAgentZones(requestedZoneStatisticsConfig);
            internalProcessingUnitStatistics.addStatistics(newProcessingUnitStatisticsId, value);
            return true;
        }
        return false;
    }

    private ProcessingUnitStatisticsId erase(ProcessingUnitStatisticsId processingUnitStatisticsId) {
        processingUnitStatisticsId.validate();
        ProcessingUnitStatisticsId erased = processingUnitStatisticsId.shallowClone();
        erased.setAgentZones(null);
        erased.setInstancesStatistics(null);
        return erased;
    }
}

