/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.cluster.activeelection.InactiveSpaceException;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.security.service.SecuredService;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.RuntimeHolder;
import com.j_spaces.core.exception.SpaceUnavailableException;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.filters.StatisticsHolder;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.internal.admin.AdminClosedException;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.DefaultSpacePartition;
import org.openspaces.admin.internal.space.DefaultSpaceReplicationManager;
import org.openspaces.admin.internal.space.DefaultSpaceRuntimeDetails;
import org.openspaces.admin.internal.space.DefaultSpaceStatistics;
import org.openspaces.admin.internal.space.InternalSpace;
import org.openspaces.admin.internal.space.InternalSpaceInstance;
import org.openspaces.admin.internal.space.InternalSpacePartition;
import org.openspaces.admin.internal.space.InternalSpaces;
import org.openspaces.admin.internal.space.events.DefaultReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceRemovedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceModeChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceRemovedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceModeChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.support.NetworkExceptionHelper;
import org.openspaces.admin.pu.DeploymentStatus;
import org.openspaces.admin.pu.ProcessingUnit;
import org.openspaces.admin.space.ReplicationStatus;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.ReplicationTargetType;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.SpaceInstanceStatistics;
import org.openspaces.admin.space.SpacePartition;
import org.openspaces.admin.space.SpaceReplicationManager;
import org.openspaces.admin.space.SpaceRuntimeDetails;
import org.openspaces.admin.space.SpaceStatistics;
import org.openspaces.admin.space.Spaces;
import org.openspaces.admin.space.events.ReplicationStatusChangedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventListener;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.space.events.SpaceModeChangedEvent;
import org.openspaces.admin.space.events.SpaceModeChangedEventListener;
import org.openspaces.admin.space.events.SpaceModeChangedEventManager;
import org.openspaces.admin.space.events.SpaceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceStatisticsChangedEventManager;
import org.openspaces.admin.space.events.SpaceSuspendTypeChangedEventManager;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;

public class DefaultSpace
implements InternalSpace {
    private static final Log logger = LogFactory.getLog(DefaultSpace.class);
    private final InternalAdmin admin;
    private final InternalSpaces spaces;
    private final String uid;
    private final String name;
    private volatile IJSpace space;
    private volatile GigaSpace gigaSpace;
    private final Map<String, SpaceInstance> spaceInstancesByUID = new SizeConcurrentHashMap();
    private final Map<String, SpaceInstance> spaceInstancesByMemberName = new ConcurrentHashMap<String, SpaceInstance>();
    private final Map<Integer, SpacePartition> spacePartitions = new SizeConcurrentHashMap();
    private final Map<String, Future> scheduledRuntimeFetchers = new ConcurrentHashMap<String, Future>();
    private final InternalSpaceInstanceAddedEventManager spaceInstanceAddedEventManager;
    private final InternalSpaceInstanceRemovedEventManager spaceInstanceRemovedEventManager;
    private final InternalSpaceModeChangedEventManager spaceModeChangedEventManager;
    private final InternalSpaceSuspendTypeChangedEventManager spaceSuspendTypeChangedManager;
    private final InternalReplicationStatusChangedEventManager replicationStatusChangedEventManager;
    private final InternalSpaceStatisticsChangedEventManager statisticsChangedEventManager;
    private final InternalSpaceInstanceStatisticsChangedEventManager instanceStatisticsChangedEventManager;
    private final LastStatisticsHolder<SpaceStatistics> lastStatisticsHolder = new LastStatisticsHolder();
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private final LastStatisticsHolder<SpaceStatistics> lastStatisticsHolderPrimaries = new LastStatisticsHolder();
    private final LastStatisticsHolder<SpaceStatistics> lastStatisticsHolderBackups = new LastStatisticsHolder();
    private final SpaceRuntimeDetails spaceRuntimeDetails;
    private final SpaceReplicationManager spaceReplicationManager;
    private int numberOfInstances = -1;
    private int numberOfBackups = -1;

    public DefaultSpace(InternalSpaces spaces, String uid, String name) {
        this.spaces = spaces;
        this.admin = (InternalAdmin)spaces.getAdmin();
        this.uid = uid;
        this.name = name;
        this.spaceInstanceAddedEventManager = new DefaultSpaceInstanceAddedEventManager(this.admin, this);
        this.spaceInstanceRemovedEventManager = new DefaultSpaceInstanceRemovedEventManager(this.admin);
        this.spaceModeChangedEventManager = new DefaultSpaceModeChangedEventManager(this, this.admin);
        this.spaceSuspendTypeChangedManager = new DefaultSpaceSuspendTypeChangedEventManager(this, this.admin);
        this.replicationStatusChangedEventManager = new DefaultReplicationStatusChangedEventManager(this.admin);
        this.statisticsChangedEventManager = new DefaultSpaceStatisticsChangedEventManager(this.admin);
        this.instanceStatisticsChangedEventManager = new DefaultSpaceInstanceStatisticsChangedEventManager(this.admin);
        this.spaceRuntimeDetails = new DefaultSpaceRuntimeDetails(this);
        this.spaceReplicationManager = new DefaultSpaceReplicationManager(this);
    }

    @Override
    public Spaces getSpaces() {
        return this.spaces;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.rescheduleStatisticsMonitor();
            }
            for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
                spaceInstance.setStatisticsInterval(interval, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
            for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
                spaceInstance.setStatisticsHistorySize(historySize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.rescheduleStatisticsMonitor();
            for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
                spaceInstance.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.stopScheduledStatisticsMonitor();
            for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
                spaceInstance.stopStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScheduledStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    SpaceStatistics stats = DefaultSpace.this.getStatistics();
                    SpaceStatisticsChangedEvent event = new SpaceStatisticsChangedEvent(DefaultSpace.this, stats);
                    DefaultSpace.this.statisticsChangedEventManager.spaceStatisticsChanged(event);
                    ((InternalSpaceStatisticsChangedEventManager)DefaultSpace.this.spaces.getSpaceStatisticsChanged()).spaceStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public int getNumberOfInstances() {
        if (this.numberOfInstances != -1) {
            return this.numberOfInstances;
        }
        this.numberOfInstances = this.doWithInstance(new InstanceCallback<Integer>(){

            @Override
            public Integer doWithinstance(InternalSpaceInstance spaceInstance) {
                return spaceInstance.getNumberOfInstances();
            }
        }, -1);
        return this.numberOfInstances;
    }

    @Override
    public int getNumberOfBackups() {
        if (this.numberOfBackups != -1) {
            return this.numberOfBackups;
        }
        this.numberOfBackups = this.doWithInstance(new InstanceCallback<Integer>(){

            @Override
            public Integer doWithinstance(InternalSpaceInstance spaceInstance) {
                return spaceInstance.getNumberOfBackups();
            }
        }, -1);
        return this.numberOfBackups;
    }

    @Override
    public int getTotalNumberOfInstances() {
        return this.getNumberOfInstances() * (this.getNumberOfBackups() + 1);
    }

    @Override
    public SpaceInstance[] getInstances() {
        return this.spaceInstancesByUID.values().toArray(new SpaceInstance[0]);
    }

    @Override
    public Iterator<SpaceInstance> iterator() {
        return Collections.unmodifiableCollection(this.spaceInstancesByUID.values()).iterator();
    }

    @Override
    public SpacePartition[] getPartitions() {
        return this.spacePartitions.values().toArray(new SpacePartition[0]);
    }

    @Override
    public SpacePartition getPartition(int partitionId) {
        return this.spacePartitions.get(partitionId);
    }

    @Override
    public SpaceModeChangedEventManager getSpaceModeChanged() {
        return this.spaceModeChangedEventManager;
    }

    @Override
    public SpaceSuspendTypeChangedEventManager getSpaceSuspendTypeChanged() {
        return this.spaceSuspendTypeChangedManager;
    }

    @Override
    public ReplicationStatusChangedEventManager getReplicationStatusChanged() {
        return this.replicationStatusChangedEventManager;
    }

    @Override
    public SpaceStatisticsChangedEventManager getStatisticsChanged() {
        return this.statisticsChangedEventManager;
    }

    @Override
    public SpaceInstanceStatisticsChangedEventManager getInstanceStatisticsChanged() {
        return this.instanceStatisticsChangedEventManager;
    }

    @Override
    public SpaceStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics() == null) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private SpaceStatistics doGetStatistics() {
        ArrayList<SpaceInstanceStatistics> stats = new ArrayList<SpaceInstanceStatistics>(this.spaceInstancesByUID.size());
        for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
            stats.add(spaceInstance.getStatistics());
        }
        SpaceStatistics prevStats = this.lastStatisticsHolder.getLastStatistics();
        return new DefaultSpaceStatistics(stats.toArray(new SpaceInstanceStatistics[stats.size()]), prevStats, this.scheduledStatisticsHolder.getStatisticsHistorySize());
    }

    @Override
    public SpaceStatistics getPrimariesStatistics() {
        if (this.lastStatisticsHolderPrimaries.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolderPrimaries.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolderPrimaries.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolderPrimaries.updateLastStatistics(this.doGetStatisticsPrimaries());
            }
            finally {
                this.lastStatisticsHolderPrimaries.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolderPrimaries.getLastStatistics() == null) {
            this.lastStatisticsHolderPrimaries.waitForLastStatistics();
        }
        return this.lastStatisticsHolderPrimaries.getLastStatistics();
    }

    private SpaceStatistics doGetStatisticsPrimaries() {
        ArrayList<SpaceInstanceStatistics> stats = new ArrayList<SpaceInstanceStatistics>(this.spaceInstancesByUID.size() / 2);
        for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
            if (spaceInstance.getMode() != SpaceMode.PRIMARY) continue;
            stats.add(spaceInstance.getStatistics());
        }
        SpaceStatistics prevStatistics = this.lastStatisticsHolderPrimaries.getLastStatistics();
        return new DefaultSpaceStatistics(stats.toArray(new SpaceInstanceStatistics[stats.size()]), prevStatistics, this.scheduledStatisticsHolder.getStatisticsHistorySize());
    }

    @Override
    public SpaceStatistics getBackupsStatistics() {
        if (this.lastStatisticsHolderBackups.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolderBackups.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolderBackups.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolderBackups.updateLastStatistics(this.doGetStatisticsBackups());
            }
            finally {
                this.lastStatisticsHolderBackups.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolderBackups.getLastStatistics() == null) {
            this.lastStatisticsHolderBackups.waitForLastStatistics();
        }
        return this.lastStatisticsHolderBackups.getLastStatistics();
    }

    private SpaceStatistics doGetStatisticsBackups() {
        ArrayList<SpaceInstanceStatistics> stats = new ArrayList<SpaceInstanceStatistics>(this.spaceInstancesByUID.size() / 2);
        for (SpaceInstance spaceInstance : this.spaceInstancesByUID.values()) {
            if (spaceInstance.getMode() != SpaceMode.BACKUP) continue;
            stats.add(spaceInstance.getStatistics());
        }
        SpaceStatistics prevStatistics = this.lastStatisticsHolderBackups.getLastStatistics();
        return new DefaultSpaceStatistics(stats.toArray(new SpaceInstanceStatistics[stats.size()]), prevStatistics, this.scheduledStatisticsHolder.getStatisticsHistorySize());
    }

    @Override
    public SpaceRuntimeDetails getRuntimeDetails() {
        return this.spaceRuntimeDetails;
    }

    @Override
    public SpaceReplicationManager getReplicationManager() {
        return this.spaceReplicationManager;
    }

    @Override
    public void addInstance(final SpaceInstance spaceInstance) {
        ScheduledFuture<?> fetcher;
        this.assertStateChangesPermitted();
        InternalSpaceInstance internalSpaceInstance = (InternalSpaceInstance)spaceInstance;
        if (this.spaceInstancesByUID.isEmpty()) {
            int i;
            if (internalSpaceInstance.getClusterSchema() != null && internalSpaceInstance.getClusterSchema().contains("partition")) {
                for (i = 0; i < internalSpaceInstance.getNumberOfInstances(); ++i) {
                    this.spacePartitions.put(i, new DefaultSpacePartition(this, i));
                }
            } else if (internalSpaceInstance.getNumberOfBackups() == 0) {
                this.spacePartitions.put(0, new DefaultSpacePartition(this, 0));
            } else {
                for (i = 0; i < internalSpaceInstance.getNumberOfInstances(); ++i) {
                    this.spacePartitions.put(i, new DefaultSpacePartition(this, i));
                }
            }
        }
        SpaceInstance existing = this.spaceInstancesByUID.put(spaceInstance.getUid(), spaceInstance);
        String fullSpaceName = JSpaceUtilities.createFullSpaceName((String)spaceInstance.getSpaceUrl().getContainerName(), (String)spaceInstance.getSpaceUrl().getSpaceName());
        this.spaceInstancesByMemberName.put(fullSpaceName, spaceInstance);
        InternalSpacePartition spacePartition = this.getPartition(internalSpaceInstance);
        if (spacePartition == null) {
            throw new IllegalStateException("getPartition(spaceInstance) returned null for spaceInstance.instanceId=" + internalSpaceInstance.getInstanceId() + " spaceInstance.getNumberOfBackups()=" + internalSpaceInstance.getNumberOfBackups() + " spacePartitions=" + this.spacePartitions);
        }
        internalSpaceInstance.setPartition(spacePartition);
        spacePartition.addSpaceInstance(spaceInstance);
        if (existing == null) {
            this.spaceInstanceAddedEventManager.spaceInstanceAdded(spaceInstance);
            ((InternalSpaceInstanceAddedEventManager)this.spaces.getSpaceInstanceAdded()).spaceInstanceAdded(spaceInstance);
        }
        spaceInstance.setStatisticsInterval(this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS);
        spaceInstance.setStatisticsHistorySize(this.scheduledStatisticsHolder.getStatisticsHistorySize());
        if (this.isMonitoring()) {
            this.admin.raiseEvent(this, new Runnable(){

                @Override
                public void run() {
                    spaceInstance.startStatisticsMonitor();
                }
            });
        }
        if ((fetcher = this.scheduledRuntimeFetchers.get(spaceInstance.getUid())) == null) {
            fetcher = this.admin.scheduleWithFixedDelay(new ScheduledRuntimeFetcher(spaceInstance), this.admin.getScheduledSpaceMonitorInterval(), this.admin.getScheduledSpaceMonitorInterval(), TimeUnit.MILLISECONDS);
            this.scheduledRuntimeFetchers.put(spaceInstance.getUid(), fetcher);
        }
    }

    @Override
    public InternalSpaceInstance removeInstance(String uid) {
        this.assertStateChangesPermitted();
        final InternalSpaceInstance spaceInstance = (InternalSpaceInstance)this.spaceInstancesByUID.remove(uid);
        if (spaceInstance != null) {
            this.admin.scheduleAdminOperation(new Runnable(){

                @Override
                public void run() {
                    while (spaceInstance.isMonitoring()) {
                        spaceInstance.stopStatisticsMonitor();
                    }
                }
            });
            this.getPartition(spaceInstance).removeSpaceInstance(uid);
            String fullSpaceName = JSpaceUtilities.createFullSpaceName((String)spaceInstance.getSpaceUrl().getContainerName(), (String)spaceInstance.getSpaceUrl().getSpaceName());
            this.spaceInstancesByMemberName.remove(fullSpaceName);
            this.spaceInstanceRemovedEventManager.spaceInstanceRemoved(spaceInstance);
            ((InternalSpaceInstanceRemovedEventManager)this.spaces.getSpaceInstanceRemoved()).spaceInstanceRemoved(spaceInstance);
            Future fetcher = this.scheduledRuntimeFetchers.remove(uid);
            if (fetcher != null) {
                fetcher.cancel(true);
            }
        }
        return spaceInstance;
    }

    private InternalSpacePartition getPartition(InternalSpaceInstance spaceInstance) {
        if (spaceInstance.getClusterSchema() != null && spaceInstance.getClusterSchema().contains("partition")) {
            return (InternalSpacePartition)this.spacePartitions.get(spaceInstance.getInstanceId() - 1);
        }
        if (spaceInstance.getNumberOfBackups() == 0) {
            return (InternalSpacePartition)this.spacePartitions.get(0);
        }
        return (InternalSpacePartition)this.spacePartitions.get(spaceInstance.getInstanceId() - 1);
    }

    @Override
    public void refreshScheduledSpaceMonitors() {
        for (Future fetcher : this.scheduledRuntimeFetchers.values()) {
            fetcher.cancel(false);
        }
        for (SpaceInstance spaceInstance : this) {
            ScheduledFuture<?> fetcher = this.admin.scheduleWithFixedDelay(new ScheduledRuntimeFetcher(spaceInstance), this.admin.getScheduledSpaceMonitorInterval(), this.admin.getScheduledSpaceMonitorInterval(), TimeUnit.MILLISECONDS);
            this.scheduledRuntimeFetchers.put(spaceInstance.getUid(), fetcher);
        }
    }

    @Override
    public int getSize() {
        return this.spaceInstancesByUID.size();
    }

    @Override
    public boolean isEmpty() {
        return this.spaceInstancesByUID.size() == 0;
    }

    public IJSpace getIJSpace() {
        if (this.space == null) {
            SpaceInstance firstInstance = null;
            Iterator<SpaceInstance> iterator = this.spaceInstancesByUID.values().iterator();
            if (iterator.hasNext()) {
                SpaceInstance instance;
                firstInstance = instance = iterator.next();
            }
            if (firstInstance == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Space " + this.getName() + " cannot create IJSpace since it has no instances"));
                }
                return null;
            }
            try {
                this.space = ((InternalSpaceInstance)firstInstance).getIJSpace().getDirectProxy().getClusteredProxy();
                this.admin.login((SecuredService)this.space);
            }
            catch (AdminException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AdminException("Failed to fetch space", e);
            }
        }
        return this.space;
    }

    @Override
    public GigaSpace getGigaSpace() {
        if (this.gigaSpace == null) {
            IJSpace ijSpace = this.getIJSpace();
            if (ijSpace == null) {
                throw new AdminException("Cannot create GigaSpace object since no space instance is discovered");
            }
            this.gigaSpace = new GigaSpaceConfigurer(ijSpace).clustered(true).gigaSpace();
        }
        return this.gigaSpace;
    }

    @Override
    public boolean waitFor(int numberOfSpaceInstances) {
        return this.waitFor(numberOfSpaceInstances, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfSpaceInstances, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(numberOfSpaceInstances);
        SpaceInstanceAddedEventListener added = new SpaceInstanceAddedEventListener(){

            @Override
            public void spaceInstanceAdded(SpaceInstance spaceInstance) {
                latch.countDown();
            }
        };
        this.getSpaceInstanceAdded().add(added);
        try {
            boolean bl = latch.await(timeout, timeUnit);
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getSpaceInstanceAdded().remove(added);
        }
    }

    @Override
    public boolean waitFor(int numberOfSpaceInstances, SpaceMode spaceMode) {
        return this.waitFor(numberOfSpaceInstances, spaceMode, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitFor(int numberOfSpaceInstances, final SpaceMode spaceMode, long timeout, TimeUnit timeUnit) {
        boolean result;
        final CountDownLatch latch = new CountDownLatch(numberOfSpaceInstances);
        SpaceModeChangedEventListener modeChanged = new SpaceModeChangedEventListener(){

            @Override
            public void spaceModeChanged(SpaceModeChangedEvent event) {
                if (event.getNewMode() == spaceMode) {
                    latch.countDown();
                }
            }
        };
        this.getSpaceModeChanged().add(modeChanged);
        try {
            result = latch.await(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getSpaceModeChanged().remove(modeChanged);
        }
        if (result) {
            int sum = 0;
            for (SpaceInstance spaceInstance : this) {
                if (spaceInstance.getMode() != spaceMode) continue;
                ++sum;
            }
            if (sum < numberOfSpaceInstances) {
                return this.waitFor(numberOfSpaceInstances, spaceMode, timeout, timeUnit);
            }
        }
        return result;
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        return this.getInstances();
    }

    @Override
    public SpaceInstanceAddedEventManager getSpaceInstanceAdded() {
        return this.spaceInstanceAddedEventManager;
    }

    @Override
    public SpaceInstanceRemovedEventManager getSpaceInstanceRemoved() {
        return this.spaceInstanceRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstanceAddedEventManager.add(eventListener);
        this.spaceInstanceRemovedEventManager.add(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstanceAddedEventManager.remove(eventListener);
        this.spaceInstanceRemovedEventManager.remove(eventListener);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public SpaceInstance getSpaceInstanceByUid(String uid) {
        return this.spaceInstancesByUID.get(uid);
    }

    private <T> T doWithInstance(InstanceCallback<T> callback, T naValue) {
        Iterator<SpaceInstance> iterator = this.spaceInstancesByUID.values().iterator();
        if (iterator.hasNext()) {
            SpaceInstance spaceInstance = iterator.next();
            return callback.doWithinstance((InternalSpaceInstance)spaceInstance);
        }
        return naValue;
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    private class ScheduledRuntimeFetcher
    implements Runnable {
        private final InternalSpaceInstance spaceInstance;

        private ScheduledRuntimeFetcher(SpaceInstance spaceInstance) {
            this.spaceInstance = (InternalSpaceInstance)spaceInstance;
        }

        @Override
        public void run() {
            try {
                ReplicationStatistics replicationStatistics;
                final RuntimeHolder runtimeHolder = this.spaceInstance.getRuntimeHolder();
                StatisticsHolder statisticsHolder = this.spaceInstance.getStatisticsHolder();
                ReplicationStatistics replicationStatistics2 = replicationStatistics = statisticsHolder == null ? null : statisticsHolder.getReplicationStatistics();
                if (runtimeHolder.getSpaceState() != null && (runtimeHolder.getSpaceState() == 2 || runtimeHolder.getSpaceState() == 0)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Ignoring runtimeHolder of space:" + this.spaceInstance.getSpaceName() + " serviceID:" + this.spaceInstance.getServiceID() + " state=" + runtimeHolder.getSpaceState()));
                    }
                    return;
                }
                DefaultSpace.this.admin.scheduleNonBlockingStateChange(new Runnable(){

                    @Override
                    public void run() {
                        ScheduledRuntimeFetcher.this.spaceInstance.setMode(runtimeHolder.getSpaceMode());
                        ScheduledRuntimeFetcher.this.spaceInstance.setSuspendInfo(runtimeHolder.getSuspendInfo());
                        if (replicationStatistics != null) {
                            List channels = replicationStatistics.getOutgoingReplication().getChannels();
                            ReplicationTarget[] replicationTargets = new ReplicationTarget[channels.size()];
                            int index = 0;
                            for (ReplicationStatistics.OutgoingChannel outgoingChannel : channels) {
                                ReplicationStatus replicationStatus;
                                ReplicationTargetType replicationTargetType;
                                switch (outgoingChannel.getReplicationMode()) {
                                    case MIRROR: {
                                        replicationTargetType = ReplicationTargetType.MIRROR_SERVICE;
                                        break;
                                    }
                                    case GATEWAY: {
                                        replicationTargetType = ReplicationTargetType.GATEWAY;
                                        break;
                                    }
                                    case LOCAL_VIEW: {
                                        replicationTargetType = ReplicationTargetType.LOCAL_VIEW;
                                        break;
                                    }
                                    case DURABLE_NOTIFICATION: {
                                        replicationTargetType = ReplicationTargetType.DURABLE_NOTIFICATION;
                                        break;
                                    }
                                    case ACTIVE_SPACE: 
                                    case BACKUP_SPACE: {
                                        replicationTargetType = ReplicationTargetType.SPACE_INSTANCE;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unexpected replication mode: " + outgoingChannel.getReplicationMode());
                                    }
                                }
                                switch (outgoingChannel.getChannelState()) {
                                    case ACTIVE: {
                                        replicationStatus = ReplicationStatus.ACTIVE;
                                        break;
                                    }
                                    case CONNECTED: 
                                    case DISCONNECTED: {
                                        replicationStatus = ReplicationStatus.DISCONNECTED;
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unexpected channel state: " + outgoingChannel.getChannelState());
                                    }
                                }
                                SpaceInstance targetSpaceInstance = (SpaceInstance)DefaultSpace.this.spaceInstancesByMemberName.get(outgoingChannel.getTargetMemberName());
                                if (targetSpaceInstance == null && replicationTargetType == ReplicationTargetType.MIRROR_SERVICE) {
                                    SpaceInstance mirrorInstance;
                                    SpaceInstance[] instances;
                                    String mirrorServiceName = outgoingChannel.getTargetMemberName().split(":")[1];
                                    Space mirrorServiceSpace = ScheduledRuntimeFetcher.this.spaceInstance.getAdmin().getSpaces().getSpaceByName(mirrorServiceName);
                                    if (mirrorServiceSpace != null && (instances = mirrorServiceSpace.getInstances()).length > 0 && (mirrorInstance = instances[0]) != null && mirrorInstance.getSpaceUrl().getSchema().equals("mirror")) {
                                        targetSpaceInstance = mirrorInstance;
                                    }
                                }
                                replicationTargets[index++] = new ReplicationTarget((InternalSpaceInstance)targetSpaceInstance, replicationStatus, outgoingChannel.getTargetMemberName(), replicationTargetType);
                            }
                            ScheduledRuntimeFetcher.this.spaceInstance.setReplicationTargets(replicationTargets);
                        }
                    }
                });
            }
            catch (SpaceUnavailableException runtimeHolder) {
            }
            catch (InactiveSpaceException runtimeHolder) {
            }
            catch (InterruptedSpaceException e) {
                ProcessingUnit pu = DefaultSpace.this.admin.getProcessingUnits().getProcessingUnit(DefaultSpace.this.name);
                if (pu == null || pu.getStatus() == DeploymentStatus.UNDEPLOYED) {
                    logger.debug((Object)"Failed to get runtime information", (Throwable)e);
                } else {
                    logger.warn((Object)"Failed to get runtime information", (Throwable)e);
                }
            }
            catch (AdminClosedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Failed to get runtime information since admin is already closed", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof SpaceUnavailableException) {
                    logger.debug((Object)"Failed to get runtime information", (Throwable)e);
                }
                if (NetworkExceptionHelper.isConnectOrCloseException(e)) {
                    logger.debug((Object)"Failed to get runtime information", (Throwable)e);
                }
                logger.warn((Object)"Failed to get runtime information", (Throwable)e);
            }
        }
    }

    private static interface InstanceCallback<T> {
        public T doWithinstance(InternalSpaceInstance var1);
    }
}

