/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.utils.concurrent.ExchangeCountDownLatch;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.service.SecuredService;
import com.gigaspaces.server.space.suspend.SuspendInfo;
import com.gigaspaces.server.space.suspend.SuspendType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.RuntimeHolder;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.filters.StatisticsHolder;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import org.jini.rio.boot.SpaceInstanceRemoteClassLoaderInfo;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.StatisticsMonitor;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.DefaultSpaceInstanceRuntimeDetails;
import org.openspaces.admin.internal.space.DefaultSpaceInstanceStatistics;
import org.openspaces.admin.internal.space.InternalSpaceInstance;
import org.openspaces.admin.internal.space.events.DefaultReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceModeChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceModeChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.support.AbstractGridComponent;
import org.openspaces.admin.internal.utils.NameUtils;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstanceRuntimeDetails;
import org.openspaces.admin.space.SpaceInstanceStatistics;
import org.openspaces.admin.space.SpacePartition;
import org.openspaces.admin.space.events.ReplicationStatusChangedEvent;
import org.openspaces.admin.space.events.ReplicationStatusChangedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.space.events.SpaceModeChangedEvent;
import org.openspaces.admin.space.events.SpaceModeChangedEventListener;
import org.openspaces.admin.space.events.SpaceModeChangedEventManager;
import org.openspaces.admin.space.events.SpaceSuspendTypeChangedEvent;
import org.openspaces.admin.space.events.SpaceSuspendTypeChangedEventManager;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.pu.container.servicegrid.PUServiceBean;
import org.openspaces.pu.container.servicegrid.PUServiceBeanImpl;
import org.openspaces.pu.container.support.ClusterInfoParser;

public class DefaultSpaceInstance
extends AbstractGridComponent
implements InternalSpaceInstance,
StatisticsMonitor {
    private final String id;
    private final String uid;
    private final ServiceID serviceID;
    private final PUServiceBean puService;
    private volatile ISpaceProxy ijspace;
    private volatile GigaSpace gigaSpace;
    private volatile IInternalRemoteJSpaceAdmin spaceAdmin;
    private volatile SpaceConfig spaceConfig;
    private final SpaceURL spaceURL;
    private final ClusterInfo clusterInfo;
    private volatile Space space;
    private volatile SpacePartition spacePartition;
    private volatile SpaceMode spaceMode = SpaceMode.NONE;
    private static final ReplicationTarget[] NO_REPLICATION_STATUS = new ReplicationTarget[0];
    private volatile ReplicationTarget[] replicationTargets = NO_REPLICATION_STATUS;
    private final InternalSpaceModeChangedEventManager spaceModeChangedEventManager;
    private final InternalSpaceSuspendTypeChangedEventManager spaceSuspendTypeChangedEventManager;
    private final InternalReplicationStatusChangedEventManager replicationStatusChangedEventManager;
    private final InternalSpaceInstanceStatisticsChangedEventManager statisticsChangedEventManager;
    private final LastStatisticsHolder<SpaceInstanceStatistics> lastStatisticsHolder = new LastStatisticsHolder<DefaultSpaceInstanceStatistics>(new DefaultSpaceInstanceStatistics());
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private final SpaceInstanceRuntimeDetails spaceInstanceRuntimeDetails;
    private volatile SuspendInfo suspendInfo = new SuspendInfo(SuspendType.NONE);

    public DefaultSpaceInstance(ServiceID serviceID, IJSpace directSpace, IInternalRemoteJSpaceAdmin spaceAdmin, InternalAdmin admin, JVMDetails jvmDetails) {
        super(admin, jvmDetails);
        this.puService = new PUServiceBeanImpl();
        this.uid = serviceID.toString();
        this.serviceID = serviceID;
        this.setIJSpace((ISpaceProxy)directSpace);
        this.gigaSpace = new GigaSpaceConfigurer(directSpace).gigaSpace();
        this.spaceAdmin = spaceAdmin;
        this.spaceURL = this.ijspace.getURL();
        this.clusterInfo = ClusterInfoParser.parse((SpaceURL)this.spaceURL);
        this.id = this.spaceURL.getSpaceName() + "~" + this.clusterInfo.getSuffix();
        this.spaceModeChangedEventManager = new DefaultSpaceModeChangedEventManager(null, admin);
        this.spaceSuspendTypeChangedEventManager = new DefaultSpaceSuspendTypeChangedEventManager(null, admin);
        this.replicationStatusChangedEventManager = new DefaultReplicationStatusChangedEventManager(admin);
        this.statisticsChangedEventManager = new DefaultSpaceInstanceStatisticsChangedEventManager(admin);
        this.spaceInstanceRuntimeDetails = new DefaultSpaceInstanceRuntimeDetails(this);
    }

    public DefaultSpaceInstance(PUServiceBean puService, SpaceServiceDetails spaceServiceDetails, InternalAdmin admin, JVMDetails jvmDetails) {
        super(admin, jvmDetails);
        this.uid = spaceServiceDetails.getServiceID().toString();
        this.serviceID = spaceServiceDetails.getServiceID();
        this.puService = puService;
        this.spaceURL = spaceServiceDetails.getSpaceUrl();
        this.clusterInfo = ClusterInfoParser.parse((SpaceURL)this.spaceURL);
        this.id = this.spaceURL.getSpaceName() + "~" + this.clusterInfo.getSuffix();
        this.spaceModeChangedEventManager = new DefaultSpaceModeChangedEventManager(null, admin);
        this.spaceSuspendTypeChangedEventManager = new DefaultSpaceSuspendTypeChangedEventManager(null, admin);
        this.replicationStatusChangedEventManager = new DefaultReplicationStatusChangedEventManager(admin);
        this.statisticsChangedEventManager = new DefaultSpaceInstanceStatisticsChangedEventManager(admin);
        this.spaceInstanceRuntimeDetails = new DefaultSpaceInstanceRuntimeDetails(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public ServiceID getServiceID() {
        return this.serviceID;
    }

    @Override
    public GigaSpace getGigaSpace() {
        if (this.gigaSpace == null) {
            this.gigaSpace = new GigaSpaceConfigurer(this.getIJSpace()).gigaSpace();
        }
        return this.gigaSpace;
    }

    @Override
    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    @Override
    public String getClusterSchema() {
        return this.clusterInfo.getSchema();
    }

    @Override
    public int getNumberOfInstances() {
        return this.clusterInfo.getNumberOfInstances();
    }

    @Override
    public int getNumberOfBackups() {
        return this.clusterInfo.getNumberOfBackups();
    }

    @Override
    public SpaceURL getSpaceUrl() {
        return this.spaceURL;
    }

    @Override
    public String getSpaceName() {
        return this.spaceURL.getSpaceName();
    }

    @Override
    public SpaceModeChangedEventManager getSpaceModeChanged() {
        return this.spaceModeChangedEventManager;
    }

    @Override
    public SpaceSuspendTypeChangedEventManager getSpaceSuspendTypeChanged() {
        return this.spaceSuspendTypeChangedEventManager;
    }

    @Override
    public ReplicationStatusChangedEventManager getReplicationStatusChanged() {
        return this.replicationStatusChangedEventManager;
    }

    @Override
    public SpaceInstanceStatisticsChangedEventManager getStatisticsChanged() {
        return this.statisticsChangedEventManager;
    }

    @Override
    public String getSpaceInstanceName() {
        return NameUtils.getSpaceInstanceName(this.getSpace().getName(), this.getInstanceId(), this.getBackupId(), this.getSpace().getNumberOfBackups());
    }

    @Override
    public int getInstanceId() {
        return this.clusterInfo.getInstanceId();
    }

    @Override
    public int getBackupId() {
        Integer backupId = this.clusterInfo.getBackupId();
        return backupId != null ? backupId : 0;
    }

    @Override
    public IJSpace getIJSpace() {
        if (this.ijspace == null) {
            try {
                this.setIJSpace((ISpaceProxy)this.puService.getSpaceDirect(this.serviceID));
                this.admin.login((SecuredService)this.ijspace);
            }
            catch (RemoteException e) {
                throw new AdminException("Failed to fetch space", e);
            }
        }
        return this.ijspace;
    }

    protected void setIJSpace(ISpaceProxy spaceProxy) {
        this.ijspace = spaceProxy;
        if (spaceProxy instanceof SpaceProxyImpl) {
            String url = SpaceUrlUtils.buildJiniUrl((String)spaceProxy.getURL().getContainerName(), (String)spaceProxy.getURL().getSpaceName(), (String[])this.admin.getGroups(), (LookupLocator[])this.admin.getLocators());
            try {
                ((SpaceProxyImpl)spaceProxy).setFinderURL(SpaceURLParser.parseURL((String)url));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to build finder url", e);
            }
        }
    }

    @Override
    public IInternalRemoteJSpaceAdmin getSpaceAdmin() {
        if (this.spaceAdmin == null) {
            try {
                this.spaceAdmin = (IInternalRemoteJSpaceAdmin)this.getIJSpace().getAdmin();
            }
            catch (RemoteException e) {
                return null;
            }
        }
        return this.spaceAdmin;
    }

    @Override
    public RuntimeHolder getRuntimeHolder() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getRuntimeHolder();
        }
        return this.puService.getSpaceRuntimeHolder(this.serviceID);
    }

    @Override
    public void setMode(SpaceMode spaceMode) {
        this.assertStateChangesPermitted();
        SpaceMode previousSpaceMode = this.spaceMode;
        SpaceMode newSpaceMode = spaceMode;
        this.spaceMode = spaceMode;
        if (previousSpaceMode != newSpaceMode) {
            SpaceModeChangedEvent event = new SpaceModeChangedEvent(this, previousSpaceMode, newSpaceMode);
            this.spaceModeChangedEventManager.spaceModeChanged(event);
            ((InternalSpaceModeChangedEventManager)this.getSpace().getSpaceModeChanged()).spaceModeChanged(event);
            ((InternalSpaceModeChangedEventManager)this.getSpace().getSpaces().getSpaceModeChanged()).spaceModeChanged(event);
        }
    }

    @Override
    public SpaceMode getMode() {
        return this.spaceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForMode(final SpaceMode requiredMode, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean result = new AtomicBoolean(false);
        SpaceModeChangedEventListener changed = new SpaceModeChangedEventListener(){

            @Override
            public void spaceModeChanged(SpaceModeChangedEvent event) {
                if (event.getNewMode().equals((Object)requiredMode)) {
                    result.set(true);
                    latch.countDown();
                }
            }
        };
        this.spaceModeChangedEventManager.add(changed);
        try {
            if (this.spaceMode.equals((Object)requiredMode)) {
                boolean bl = true;
                return bl;
            }
            latch.await(timeout, timeUnit);
            boolean bl = result.get();
            return bl;
        }
        catch (InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.spaceModeChangedEventManager.remove(changed);
        }
    }

    @Override
    public SpaceInstanceStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics().isNA()) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private SpaceInstanceStatistics doGetStatistics() {
        try {
            if (this.getVirtualMachine().getMachine() == null) {
                return null;
            }
            StatisticsHolder holder = this.getStatisticsHolder();
            SpaceInstanceStatistics previousStats = this.lastStatisticsHolder.getLastStatistics();
            return new DefaultSpaceInstanceStatistics(holder, previousStats, this.scheduledStatisticsHolder.getStatisticsHistorySize(), this.getVirtualMachine().getMachine().getOperatingSystem().getTimeDelta());
        }
        catch (RemoteException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.stopStatisticsMonitor();
                this.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            final DefaultSpaceInstance spaceInstance = this;
            this.scheduledStatisticsHolder.updateMonitor(((InternalAdmin)this.getAdmin()).scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    SpaceInstanceStatistics stats = spaceInstance.getStatistics();
                    SpaceInstanceStatisticsChangedEvent event = new SpaceInstanceStatisticsChangedEvent(spaceInstance, stats);
                    DefaultSpaceInstance.this.statisticsChangedEventManager.spaceInstanceStatisticsChanged(event);
                    ((InternalSpaceInstanceStatisticsChangedEventManager)DefaultSpaceInstance.this.space.getInstanceStatisticsChanged()).spaceInstanceStatisticsChanged(event);
                    ((InternalSpaceInstanceStatisticsChangedEventManager)DefaultSpaceInstance.this.space.getSpaces().getSpaceInstanceStatisticsChanged()).spaceInstanceStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    @Override
    public SpaceInstanceRuntimeDetails getRuntimeDetails() {
        return this.spaceInstanceRuntimeDetails;
    }

    @Override
    public SpaceInstanceRemoteClassLoaderInfo getSpaceInstanceRemoteClassLoaderInfo() {
        SpaceInstanceRemoteClassLoaderInfo RemoteClassLoaderInfo = null;
        IInternalRemoteJSpaceAdmin spaceAdmin = this.getSpaceAdmin();
        if (spaceAdmin != null) {
            try {
                RemoteClassLoaderInfo = spaceAdmin.getSpaceInstanceRemoteClassLoaderInfo();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return RemoteClassLoaderInfo;
    }

    @Override
    public ReplicationTarget[] getReplicationTargets() {
        return this.replicationTargets;
    }

    @Override
    public void setReplicationTargets(ReplicationTarget[] replicationTargets) {
        this.assertStateChangesPermitted();
        ReplicationTarget[] previousReplicationTargets = this.replicationTargets;
        ReplicationTarget[] newReplicationTargets = replicationTargets;
        this.replicationTargets = replicationTargets;
        ArrayList<ReplicationStatusChangedEvent> events = new ArrayList<ReplicationStatusChangedEvent>();
        if (previousReplicationTargets == NO_REPLICATION_STATUS) {
            for (ReplicationTarget replicationTarget : newReplicationTargets) {
                events.add(new ReplicationStatusChangedEvent(this, replicationTarget, null, replicationTarget.getReplicationStatus()));
            }
        } else {
            for (int i = 0; i < newReplicationTargets.length; ++i) {
                ReplicationTarget newReplicationTarget = newReplicationTargets[i];
                ReplicationTarget previousReplicationTarget = this.locatePreviousReplicationTarget(newReplicationTarget, previousReplicationTargets);
                if (previousReplicationTarget == null) {
                    for (ReplicationTarget replicationTarget : newReplicationTargets) {
                        events.add(new ReplicationStatusChangedEvent(this, replicationTarget, null, replicationTarget.getReplicationStatus()));
                    }
                    continue;
                }
                if (newReplicationTarget.getReplicationStatus() == previousReplicationTarget.getReplicationStatus()) continue;
                events.add(new ReplicationStatusChangedEvent(this, newReplicationTarget, previousReplicationTarget.getReplicationStatus(), newReplicationTarget.getReplicationStatus()));
            }
        }
        for (ReplicationStatusChangedEvent event : events) {
            this.replicationStatusChangedEventManager.replicationStatusChanged(event);
            ((InternalReplicationStatusChangedEventManager)this.getSpace().getReplicationStatusChanged()).replicationStatusChanged(event);
            ((InternalReplicationStatusChangedEventManager)this.getSpace().getSpaces().getReplicationStatusChanged()).replicationStatusChanged(event);
        }
    }

    private ReplicationTarget locatePreviousReplicationTarget(ReplicationTarget newReplicationTarget, ReplicationTarget[] previousReplicationTargets) {
        for (ReplicationTarget prevReplicationTarget : previousReplicationTargets) {
            String pevReplicationTargetMemberName = prevReplicationTarget.getMemberName();
            String newReplicationTargetMemberName = newReplicationTarget.getMemberName();
            if (!newReplicationTargetMemberName.equals(pevReplicationTargetMemberName)) continue;
            return prevReplicationTarget;
        }
        return null;
    }

    @Override
    public Space getSpace() {
        return this.space;
    }

    @Override
    public void setSpace(Space space) {
        this.assertStateChangesPermitted();
        this.space = space;
    }

    @Override
    public void setPartition(SpacePartition spacePartition) {
        this.assertStateChangesPermitted();
        this.spacePartition = spacePartition;
    }

    @Override
    public SpacePartition getPartition() {
        return this.spacePartition;
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getNIODetails();
        }
        return this.puService.getNIODetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getNIOStatistics();
        }
        return this.puService.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        if (this.spaceAdmin != null) {
            this.spaceAdmin.enableLRMIMonitoring();
        }
        this.puService.enableLRMIMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        if (this.spaceAdmin != null) {
            this.spaceAdmin.disableLRMIMonitoring();
        }
        this.puService.disableLRMIMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.fetchLRMIMonitoringDetails();
        }
        return this.puService.fetchLRMIMonitoringDetails();
    }

    @Override
    public long getCurrentTimeInMillis() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getCurrentTimestamp();
        }
        return this.puService.getCurrentTimestamp();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getOSDetails();
        }
        return this.puService.getOSDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getOSStatistics();
        }
        return this.puService.getOSStatistics();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        if (this.spaceAdmin != null) {
            return this.spaceAdmin.getJVMStatistics();
        }
        return this.puService.getJVMStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        if (this.spaceAdmin != null) {
            this.spaceAdmin.runGc();
        }
        this.puService.runGc();
    }

    public String toString() {
        String name = this.getSpaceInstanceName();
        switch (this.spaceMode) {
            case PRIMARY: {
                name = name + "(P)";
                break;
            }
            case BACKUP: {
                name = name + "(B)";
            }
        }
        return name;
    }

    @Override
    public StatisticsHolder getStatisticsHolder() throws RemoteException {
        if (this.spaceAdmin != null) {
            return ((StatisticsAdmin)this.spaceAdmin).getHolder();
        }
        return this.puService.getSpaceStatisticsHolder(this.serviceID);
    }

    @Override
    public PlatformLogicalVersion getPlatformLogicalVersion() {
        return LRMIUtilities.getServicePlatformLogicalVersion((Object)((ISpaceProxy)this.getIJSpace()).getDirectProxy().getRemoteJSpace());
    }

    @Override
    public SpaceConfig getSpaceConfig() {
        if (this.spaceConfig == null) {
            this.spaceConfig = this.getIJSpace().getDirectProxy().getProxySettings().getSpaceAttributes();
        }
        return this.spaceConfig;
    }

    @Override
    public Future<?> demote(long maxSuspendTime, TimeUnit timeUnit) {
        return this.demote(maxSuspendTime, timeUnit, this.admin.getCredentialsProvider());
    }

    @Override
    public Future<?> demote(long maxSuspendTime, TimeUnit timeUnit, CredentialsProvider credentialsProvider) {
        DemoteFuture demoteFuture = new DemoteFuture(maxSuspendTime, timeUnit, credentialsProvider);
        this.admin.scheduleAdminOperation(demoteFuture);
        return demoteFuture;
    }

    @Override
    public void setSuspendInfo(SuspendInfo suspendInfo) {
        this.assertStateChangesPermitted();
        SuspendType prevSuspendType = this.suspendInfo.getSuspendType();
        SuspendType newSuspendType = suspendInfo.getSuspendType();
        this.suspendInfo = suspendInfo;
        if (prevSuspendType != suspendInfo.getSuspendType()) {
            SpaceSuspendTypeChangedEvent event = new SpaceSuspendTypeChangedEvent(this, prevSuspendType, newSuspendType);
            this.spaceSuspendTypeChangedEventManager.spaceSuspendTypeChanged(event);
            ((InternalSpaceSuspendTypeChangedEventManager)this.getSpace().getSpaceSuspendTypeChanged()).spaceSuspendTypeChanged(event);
            ((InternalSpaceSuspendTypeChangedEventManager)this.getSpace().getSpaces().getSpaceSuspendTypeChanged()).spaceSuspendTypeChanged(event);
        }
    }

    @Override
    public SuspendInfo getSuspendInfo() {
        return this.suspendInfo;
    }

    private class DemoteFuture
    implements Future<Object>,
    Runnable {
        private final ExchangeCountDownLatch<Throwable> operationLatch = new ExchangeCountDownLatch(1);
        private final CountDownLatch spaceModeChangedEventLatch = new CountDownLatch(1);
        private final TimeUnit timeUnit;
        private final CredentialsProvider credentialsProvider;
        private final long timeout;

        private DemoteFuture(long timeout, TimeUnit timeUnit, CredentialsProvider credentialsProvider) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.credentialsProvider = credentialsProvider;
        }

        @Override
        public void run() {
            SpaceModeChangedEventListener changed = new SpaceModeChangedEventListener(){

                @Override
                public void spaceModeChanged(SpaceModeChangedEvent event) {
                    if (event.getNewMode().equals((Object)SpaceMode.BACKUP)) {
                        DemoteFuture.this.spaceModeChangedEventLatch.countDown();
                        DefaultSpaceInstance.this.space.getSpaceModeChanged().remove(this);
                    }
                }
            };
            try {
                DefaultSpaceInstance.this.space.getSpaceModeChanged().add(changed);
                DefaultSpaceInstance.this.getIJSpace().getDirectProxy().demote(this.timeout, this.timeUnit, this.credentialsProvider);
                this.operationLatch.countDown(null);
            }
            catch (Exception e) {
                DefaultSpaceInstance.this.space.getSpaceModeChanged().remove(changed);
                this.operationLatch.countDown((Object)e);
                this.spaceModeChangedEventLatch.countDown();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.operationLatch.getCount() == 0L && this.spaceModeChangedEventLatch.getCount() == 0L;
        }

        @Override
        public Object get() throws InterruptedException, ExecutionException {
            Throwable result = (Throwable)this.operationLatch.waitForResult();
            if (result != null) {
                throw new ExecutionException(result);
            }
            this.spaceModeChangedEventLatch.await();
            return null;
        }

        @Override
        public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long start = System.currentTimeMillis();
            Throwable result = (Throwable)this.operationLatch.waitForResult(timeout, unit);
            if (result != null) {
                throw new ExecutionException(result);
            }
            long elapsed = System.currentTimeMillis() - start;
            long timeLeft = unit.toMillis(timeout) - elapsed;
            if (timeLeft <= 0L || !this.spaceModeChangedEventLatch.await(timeLeft, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timed out while waiting for space mode event");
            }
            return null;
        }
    }
}

