/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.management.space.LocalCacheDetails;
import com.gigaspaces.management.space.LocalViewDetails;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspaces.admin.internal.space.DefaultSpaceInstance;
import org.openspaces.admin.internal.space.DefaultSpaceInstanceConnectionDetails;
import org.openspaces.admin.internal.space.DefaultSpaceInstanceTransactionDetails;
import org.openspaces.admin.internal.space.RemoteOperationTimeBasedCache;
import org.openspaces.admin.space.SpaceInstanceConnectionDetails;
import org.openspaces.admin.space.SpaceInstanceRuntimeDetails;
import org.openspaces.admin.space.SpaceInstanceTransactionDetails;

public class DefaultSpaceInstanceRuntimeDetails
implements SpaceInstanceRuntimeDetails {
    private final SpaceRuntimeInfoCache spaceRuntimeInfoCache;
    private final LocalCacheDetailsCache localCacheDetailsCache;
    private final LocalViewDetailsCache localViewDetailsCache;
    private final DefaultSpaceInstanceTransactionDetails spaceInstanceTransactionDetails;
    private final DefaultSpaceInstanceConnectionDetails spaceInstanceConnectionDetails;

    public DefaultSpaceInstanceRuntimeDetails(DefaultSpaceInstance defaultSpaceInstance) {
        this.spaceRuntimeInfoCache = new SpaceRuntimeInfoCache(defaultSpaceInstance);
        this.localCacheDetailsCache = new LocalCacheDetailsCache(defaultSpaceInstance);
        this.localViewDetailsCache = new LocalViewDetailsCache(defaultSpaceInstance);
        this.spaceInstanceTransactionDetails = new DefaultSpaceInstanceTransactionDetails(defaultSpaceInstance);
        this.spaceInstanceConnectionDetails = new DefaultSpaceInstanceConnectionDetails(defaultSpaceInstance);
    }

    @Override
    public int getCount() {
        int count = 0;
        SpaceRuntimeInfo spaceRuntimeInfo = (SpaceRuntimeInfo)this.spaceRuntimeInfoCache.get();
        if (spaceRuntimeInfo != null) {
            for (Integer num : spaceRuntimeInfo.m_NumOFEntries) {
                count += num.intValue();
            }
        }
        return count;
    }

    @Override
    public String[] getClassNames() {
        SpaceRuntimeInfo spaceRuntimeInfo = (SpaceRuntimeInfo)this.spaceRuntimeInfoCache.get();
        if (spaceRuntimeInfo != null) {
            ArrayList classNames = new ArrayList(spaceRuntimeInfo.m_ClassNames);
            Collections.sort(classNames);
            return classNames.toArray(new String[classNames.size()]);
        }
        return new String[0];
    }

    @Override
    public Map<String, Integer> getCountPerClassName() {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        SpaceRuntimeInfo spaceRuntimeInfo = (SpaceRuntimeInfo)this.spaceRuntimeInfoCache.get();
        if (spaceRuntimeInfo != null) {
            List classNames = spaceRuntimeInfo.m_ClassNames;
            List numOfEntries = spaceRuntimeInfo.m_NumOFEntries;
            for (int i = 0; i < classNames.size(); ++i) {
                mapping.put((String)classNames.get(i), (Integer)numOfEntries.get(i));
            }
        }
        return mapping;
    }

    @Override
    public Map<String, Integer> getNotifyTemplateCountPerClassName() {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        SpaceRuntimeInfo spaceRuntimeInfo = (SpaceRuntimeInfo)this.spaceRuntimeInfoCache.get();
        if (spaceRuntimeInfo != null) {
            List classNames = spaceRuntimeInfo.m_ClassNames;
            List numOfTemplates = spaceRuntimeInfo.m_NumOFTemplates;
            for (int i = 0; i < classNames.size(); ++i) {
                mapping.put((String)classNames.get(i), (Integer)numOfTemplates.get(i));
            }
        }
        return mapping;
    }

    @Override
    public SpaceInstanceTransactionDetails getTransactionDetails() {
        return this.spaceInstanceTransactionDetails;
    }

    @Override
    public SpaceInstanceConnectionDetails getConnectionDetails() {
        return this.spaceInstanceConnectionDetails;
    }

    @Override
    public Map<String, LocalCacheDetails> getLocalCacheDetails() {
        return (Map)this.localCacheDetailsCache.get();
    }

    @Override
    public Map<String, LocalViewDetails> getLocalViewDetails() {
        return (Map)this.localViewDetailsCache.get();
    }

    private static class LocalViewDetailsCache
    extends RemoteOperationTimeBasedCache<Map<String, LocalViewDetails>> {
        private final DefaultSpaceInstance spaceInstance;

        public LocalViewDetailsCache(DefaultSpaceInstance spaceInstance) {
            this.spaceInstance = spaceInstance;
        }

        @Override
        protected Map<String, LocalViewDetails> load() throws RemoteException {
            IInternalRemoteJSpaceAdmin spaceAdmin = this.spaceInstance.getSpaceAdmin();
            return spaceAdmin != null ? spaceAdmin.getLocalViewDetails() : null;
        }
    }

    private static class LocalCacheDetailsCache
    extends RemoteOperationTimeBasedCache<Map<String, LocalCacheDetails>> {
        private final DefaultSpaceInstance spaceInstance;

        public LocalCacheDetailsCache(DefaultSpaceInstance spaceInstance) {
            this.spaceInstance = spaceInstance;
        }

        @Override
        protected Map<String, LocalCacheDetails> load() throws RemoteException {
            IInternalRemoteJSpaceAdmin spaceAdmin = this.spaceInstance.getSpaceAdmin();
            return spaceAdmin != null ? spaceAdmin.getLocalCacheDetails() : null;
        }
    }

    private static class SpaceRuntimeInfoCache
    extends RemoteOperationTimeBasedCache<SpaceRuntimeInfo> {
        private final DefaultSpaceInstance spaceInstance;

        public SpaceRuntimeInfoCache(DefaultSpaceInstance spaceInstance) {
            this.spaceInstance = spaceInstance;
        }

        @Override
        protected SpaceRuntimeInfo load() throws RemoteException {
            IInternalRemoteJSpaceAdmin spaceAdmin = this.spaceInstance.getSpaceAdmin();
            return spaceAdmin != null ? spaceAdmin.getRuntimeInfo() : null;
        }
    }
}

