/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.cluster.replication.async.mirror.MirrorStatistics;
import com.gigaspaces.server.blobstore.BlobStoreStatistics;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.filters.StatisticsHolder;
import java.util.ArrayList;
import java.util.List;
import org.openspaces.admin.space.SpaceInstanceStatistics;
import org.openspaces.admin.support.StatisticsUtils;

public class DefaultSpaceInstanceStatistics
implements SpaceInstanceStatistics {
    private final long timeDelta;
    private final StatisticsHolder statisticsHolder;
    private volatile SpaceInstanceStatistics previousStats;

    public DefaultSpaceInstanceStatistics() {
        this(new StatisticsHolder(new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L}), null, 0, -1L);
    }

    public DefaultSpaceInstanceStatistics(StatisticsHolder statisticsHolder, SpaceInstanceStatistics previousStats, int historySize, long timeDelta) {
        this.statisticsHolder = statisticsHolder;
        this.previousStats = previousStats;
        this.timeDelta = timeDelta;
        SpaceInstanceStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultSpaceInstanceStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.statisticsHolder.getOperationsCount()[0] == -1L;
    }

    @Override
    public long getTimestamp() {
        return this.statisticsHolder.getTimestamp();
    }

    @Override
    public long getAdminTimestamp() {
        if (this.statisticsHolder.getTimestamp() != -1L && this.timeDelta != Integer.MIN_VALUE) {
            return this.statisticsHolder.getTimestamp() + this.timeDelta;
        }
        return -1L;
    }

    @Override
    public long getPreviousTimestamp() {
        if (this.previousStats == null) {
            return -1L;
        }
        return this.previousStats.getTimestamp();
    }

    @Override
    public SpaceInstanceStatistics getPrevious() {
        return this.previousStats;
    }

    public void setPreviousStats(SpaceInstanceStatistics previousStats) {
        this.previousStats = previousStats;
    }

    @Override
    public long getWriteCount() {
        return this.statisticsHolder.getWriteCount();
    }

    @Override
    public double getWritePerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getWriteCount(), this.getPrevious().getWriteCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getReadCount() {
        return this.statisticsHolder.getReadCount() + this.statisticsHolder.getReadMultipleCount();
    }

    @Override
    public double getReadPerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getReadCount(), this.getPrevious().getReadCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getTakeCount() {
        return this.statisticsHolder.getTakeCount() + this.statisticsHolder.getTakeMultipleCount();
    }

    @Override
    public double getTakePerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getTakeCount(), this.getPrevious().getTakeCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getNotifyRegistrationCount() {
        return this.statisticsHolder.getNotificationsRegistrationsCount();
    }

    @Override
    public double getNotifyRegistrationPerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getNotifyRegistrationCount(), this.getPrevious().getNotifyRegistrationCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getCleanCount() {
        return this.statisticsHolder.getCleanCount();
    }

    @Override
    public double getCleanPerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getCleanCount(), this.getPrevious().getCleanCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getUpdateCount() {
        return this.statisticsHolder.getUpdateCount();
    }

    @Override
    public double getUpdatePerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getUpdateCount(), this.getPrevious().getUpdateCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getNotifyTriggerCount() {
        return this.statisticsHolder.getNotificationsTriggeredCount();
    }

    @Override
    public double getNotifyTriggerPerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getNotifyTriggerCount(), this.getPrevious().getNotifyTriggerCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getNotifyAckCount() {
        return this.statisticsHolder.getNotificationsAcksCount();
    }

    @Override
    public double getNotifyAckPerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getNotifyAckCount(), this.getPrevious().getNotifyAckCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getExecuteCount() {
        return this.statisticsHolder.getTaskExecutionsCount();
    }

    @Override
    public double getExecutePerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getExecuteCount(), this.getPrevious().getExecuteCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getRemoveCount() {
        return this.statisticsHolder.getLeaseExpiredOrCanceledCount();
    }

    @Override
    public double getRemovePerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getRemoveCount(), this.getPrevious().getRemoveCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public long getChangeCount() {
        return this.statisticsHolder.getChangeCount();
    }

    @Override
    public double getChangePerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getChangeCount(), this.getPrevious().getChangeCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public ReplicationStatistics getReplicationStatistics() {
        return this.statisticsHolder.getReplicationStatistics();
    }

    @Override
    public MirrorStatistics getMirrorStatistics() {
        return this.statisticsHolder.getMirrorStatistics();
    }

    @Override
    public BlobStoreStatistics getBlobStoreStatistics() {
        return this.statisticsHolder.getBlobStoreStatistics();
    }

    @Override
    public int getProcessorQueueSize() {
        return this.statisticsHolder.getProcessorQueueSize();
    }

    @Override
    public int getNotifierQueueSize() {
        return this.statisticsHolder.getNotifierQueueSize();
    }

    @Override
    public long getObjectCount() {
        return this.statisticsHolder.getRuntimeStatisticsHolder().getObjectCount();
    }

    @Override
    public long getNotifyTemplateCount() {
        return this.statisticsHolder.getRuntimeStatisticsHolder().getNotifyTemplateCount();
    }

    @Override
    public long getActiveConnectionCount() {
        return this.statisticsHolder.getRuntimeStatisticsHolder().getActiveConnectionCount();
    }

    @Override
    public long getActiveTransactionCount() {
        return this.statisticsHolder.getRuntimeStatisticsHolder().getActiveTransactionCount();
    }

    @Override
    public List<SpaceInstanceStatistics> getTimelineFromTimestamp(long fromTimestamp) {
        ArrayList<SpaceInstanceStatistics> timeline = new ArrayList<SpaceInstanceStatistics>();
        for (SpaceInstanceStatistics current = this; current != null && !current.isNA() && current.getTimestamp() > fromTimestamp; current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }
}

