/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpaceInstances;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceRemovedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceRemovedEventManager;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventManager;

public class DefaultSpaceInstances
implements InternalSpaceInstances {
    private final InternalAdmin admin;
    private final Map<String, SpaceInstance> spaceInstances = new SizeConcurrentHashMap();
    private final InternalSpaceInstanceAddedEventManager spaceInstanceAddedEventManager;
    private final InternalSpaceInstanceRemovedEventManager spaceInstanceRemovedEventManager;

    public DefaultSpaceInstances(InternalAdmin admin) {
        this.admin = admin;
        this.spaceInstanceAddedEventManager = new DefaultSpaceInstanceAddedEventManager(admin, this);
        this.spaceInstanceRemovedEventManager = new DefaultSpaceInstanceRemovedEventManager(admin);
    }

    @Override
    public boolean contains(SpaceInstance spaceInstance) {
        for (SpaceInstance it : this.spaceInstances.values()) {
            if (!it.getUid().equals(spaceInstance.getUid())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.spaceInstances.size();
    }

    @Override
    public Iterator<SpaceInstance> iterator() {
        return Collections.unmodifiableCollection(this.spaceInstances.values()).iterator();
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        return this.spaceInstances.values().toArray(new SpaceInstance[0]);
    }

    @Override
    public void addSpaceInstance(SpaceInstance spaceInstance) {
        this.assertStateChangesPermitted();
        SpaceInstance existing = this.spaceInstances.put(spaceInstance.getUid(), spaceInstance);
        if (existing == null) {
            this.spaceInstanceAddedEventManager.spaceInstanceAdded(spaceInstance);
        }
    }

    @Override
    public void removeSpaceInstance(String uid) {
        this.assertStateChangesPermitted();
        SpaceInstance existing = this.spaceInstances.remove(uid);
        if (existing != null) {
            this.spaceInstanceRemovedEventManager.spaceInstanceRemoved(existing);
        }
    }

    @Override
    public SpaceInstanceAddedEventManager getSpaceInstanceAdded() {
        return this.spaceInstanceAddedEventManager;
    }

    @Override
    public SpaceInstanceRemovedEventManager getSpaceInstanceRemoved() {
        return this.spaceInstanceRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstanceAddedEventManager.add(eventListener);
        this.spaceInstanceRemovedEventManager.add(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstanceAddedEventManager.remove(eventListener);
        this.spaceInstanceRemovedEventManager.remove(eventListener);
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

