/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpace;
import org.openspaces.admin.internal.space.InternalSpacePartition;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;

public class DefaultSpacePartition
implements InternalSpacePartition {
    private final Space space;
    private final int partitionId;
    private final Map<String, SpaceInstance> spaceInstances = new ConcurrentHashMap<String, SpaceInstance>();

    public DefaultSpacePartition(Space space, int partitionId) {
        this.space = space;
        this.partitionId = partitionId;
    }

    @Override
    public Space getSpace() {
        return this.space;
    }

    @Override
    public SpaceInstance getPrimary() {
        for (SpaceInstance spaceInstance : this) {
            if (spaceInstance.getMode() != SpaceMode.PRIMARY) continue;
            return spaceInstance;
        }
        return null;
    }

    @Override
    public SpaceInstance getBackup() {
        for (SpaceInstance spaceInstance : this) {
            if (spaceInstance.getMode() != SpaceMode.BACKUP) continue;
            return spaceInstance;
        }
        return null;
    }

    @Override
    public Iterator<SpaceInstance> iterator() {
        return this.spaceInstances.values().iterator();
    }

    @Override
    public SpaceInstance[] getInstances() {
        return this.spaceInstances.values().toArray(new SpaceInstance[0]);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void addSpaceInstance(SpaceInstance spaceInstance) {
        this.assertStateChangesPermitted();
        this.spaceInstances.put(spaceInstance.getUid(), spaceInstance);
    }

    @Override
    public void removeSpaceInstance(String uid) {
        this.assertStateChangesPermitted();
        this.spaceInstances.remove(uid);
    }

    private void assertStateChangesPermitted() {
        Admin admin = ((InternalSpace)this.space).getAdmin();
        ((InternalAdmin)admin).assertStateChangesPermitted();
    }
}

